/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hasor.dataway.authorization.PermissionType;
import net.hasor.dataway.authorization.RefAuthorization;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.dal.ApiStatusEnum;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.dal.QueryCondition;
import net.hasor.dataway.web.BasicController;
import net.hasor.db.Transactional;
import net.hasor.db.transaction.Propagation;
import net.hasor.utils.StringUtils;
import net.hasor.web.annotation.Post;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;

@MappingToUrl(value="/api/publish")
@RefAuthorization(value=PermissionType.ApiPublish)
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class PublishController
extends BasicController {
    @Post
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Result<Object> doPublish(@QueryParameter(value="id") String apiId, @RequestBody Map<String, Object> requestBody) {
        if (!apiId.equalsIgnoreCase(requestBody.get("id").toString())) {
            throw new IllegalArgumentException("id Parameters of the ambiguity.");
        }
        Map<FieldDef, String> object = this.dataAccessLayer.getObjectBy(EntityDef.INFO, FieldDef.ID, apiId);
        object.putAll(DatawayUtils.STATUS_UPDATE_TO_PUBLISHED.get());
        boolean updateResult = this.dataAccessLayer.updateObject(EntityDef.INFO, apiId, object);
        if (!updateResult) {
            throw new RuntimeException("interface Published failed.");
        }
        String releaseID = this.dataAccessLayer.generateId(EntityDef.RELEASE, object.get((Object)FieldDef.PATH));
        object.put(FieldDef.API_ID, object.get((Object)FieldDef.ID));
        object.put(FieldDef.ID, releaseID);
        object.put(FieldDef.RELEASE_TIME, String.valueOf(System.currentTimeMillis()));
        object.put(FieldDef.CREATE_TIME, String.valueOf(System.currentTimeMillis()));
        object.put(FieldDef.GMT_TIME, String.valueOf(System.currentTimeMillis()));
        boolean publishResult = this.dataAccessLayer.createObject(EntityDef.RELEASE, object);
        if (!publishResult) {
            throw new RuntimeException("release Published failed.");
        }
        HashMap<QueryCondition, Object> releaseQueryCondition = new HashMap<QueryCondition, Object>();
        releaseQueryCondition.put(QueryCondition.ApiId, apiId);
        List<Map<FieldDef, String>> releaseList = this.dataAccessLayer.listObjectBy(EntityDef.RELEASE, releaseQueryCondition);
        releaseList = releaseList == null ? Collections.emptyList() : releaseList;
        releaseList.stream().filter(apiRelease -> {
            String releaseItem = (String)apiRelease.get((Object)FieldDef.ID);
            ApiStatusEnum statusEnum = ApiStatusEnum.typeOf(apiRelease.get((Object)FieldDef.STATUS));
            return statusEnum != ApiStatusEnum.Disable && !StringUtils.equalsIgnoreCase((String)releaseID, (String)releaseItem);
        }).forEach(apiRelease -> {
            String releaseId = (String)apiRelease.get((Object)FieldDef.ID);
            apiRelease = this.dataAccessLayer.getObjectBy(EntityDef.RELEASE, FieldDef.ID, releaseId);
            apiRelease.putAll(DatawayUtils.STATUS_UPDATE_TO_DISABLE.get());
            this.dataAccessLayer.updateObject(EntityDef.RELEASE, releaseId, (Map<FieldDef, String>)apiRelease);
        });
        return Result.of(true);
    }
}

