/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.hasor.dataql.fx.basic.StringUdfSource;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.dal.EntityDef;
import net.hasor.dataway.dal.FieldDef;
import net.hasor.dataway.web.BasicController;
import net.hasor.dataway.web.Swagger2Query;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import net.hasor.web.annotation.Get;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;

@MappingToUrl(value="/api/docs/swagger2.json")
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class Swagger2Controller
extends BasicController {
    @Get
    public Object doSwaggerApi(Invoker invoker) throws IOException {
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        String localName = httpRequest.getHeader("Host");
        if (StringUtils.isBlank((String)localName)) {
            int localPort = httpRequest.getLocalPort();
            localName = httpRequest.getLocalAddr() + (localPort == 80 ? "" : ":" + localPort);
        }
        List<Map<FieldDef, String>> doList = this.dataAccessLayer.listObjectBy(EntityDef.RELEASE, Swagger2Controller.emptyCondition());
        final List collectList = doList.stream().map(defMap -> {
            HashMap dataMap = new HashMap();
            defMap.forEach((fieldDef, s) -> dataMap.put(StringUdfSource.lineToHump((String)fieldDef.name()), s));
            return dataMap;
        }).collect(Collectors.toList());
        String contextPathProxy = invoker.getHttpRequest().getParameter("DW_CONTEXT_PATH_PROXY");
        final String contextPath = DatawayUtils.getDwContextPath(invoker, contextPathProxy);
        final String serverHost = localName;
        return new Swagger2Query().execute(new HashMap<String, Object>(){
            {
                this.put("apiDataList", collectList);
                this.put("serverHost", serverHost);
                this.put("serverBasePath", StringUtils.isNotBlank((String)contextPath) ? contextPath : "/");
            }
        }).getData().unwrap();
    }
}

