/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.sql.DataSource;
import net.hasor.core.ApiBinder;
import net.hasor.core.MethodInterceptor;
import net.hasor.core.MethodInvocation;
import net.hasor.core.Module;
import net.hasor.core.exts.aop.Matchers;
import net.hasor.db.Level;
import net.hasor.db.Transactional;
import net.hasor.db.jdbc.JdbcOperations;
import net.hasor.db.jdbc.core.JdbcAccessor;
import net.hasor.db.jdbc.core.JdbcConnection;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.jdbc.core.JdbcTemplateProvider;
import net.hasor.db.transaction.Isolation;
import net.hasor.db.transaction.Propagation;
import net.hasor.db.transaction.TranManager;
import net.hasor.db.transaction.TransactionManager;
import net.hasor.db.transaction.TransactionStatus;
import net.hasor.db.transaction.TransactionTemplate;
import net.hasor.db.transaction.provider.TransactionManagerProvider;
import net.hasor.db.transaction.provider.TransactionTemplateProvider;
import net.hasor.utils.StringUtils;

public class JdbcModule
implements Module {
    private final Set<Level> loadLevel;
    private final String dataSourceID;
    private final Supplier<DataSource> dataSource;

    public JdbcModule(Level loadLevel, DataSource dataSource) {
        this(new Level[]{loadLevel}, null, JdbcModule.of(Objects.requireNonNull(dataSource)));
    }

    public JdbcModule(Level loadLevel, Supplier<DataSource> dataSource) {
        this(new Level[]{loadLevel}, null, dataSource);
    }

    public JdbcModule(Level loadLevel, String name, DataSource dataSource) {
        this(new Level[]{loadLevel}, name, JdbcModule.of(Objects.requireNonNull(dataSource)));
    }

    public JdbcModule(Level[] loadLevel, DataSource dataSource) {
        this(loadLevel, null, JdbcModule.of(Objects.requireNonNull(dataSource)));
    }

    public JdbcModule(Level[] loadLevel, Supplier<DataSource> dataSource) {
        this(loadLevel, null, dataSource);
    }

    public JdbcModule(Level[] loadLevel, String name, Supplier<DataSource> dataSource) {
        Objects.requireNonNull(loadLevel, "loadLevel is null.");
        Objects.requireNonNull(dataSource, "dataSource Provider is null.");
        this.loadLevel = new HashSet<Level>(Arrays.asList(loadLevel));
        this.dataSourceID = name;
        this.dataSource = dataSource;
    }

    private static <T> Supplier<T> of(T instance) {
        return () -> instance;
    }

    public void loadModule(ApiBinder apiBinder) throws Throwable {
        boolean loadTran;
        boolean loadData = this.loadLevel.contains((Object)Level.Full) || this.loadLevel.contains((Object)Level.DataSource);
        boolean loadJdbc = this.loadLevel.contains((Object)Level.Full) || this.loadLevel.contains((Object)Level.Jdbc);
        boolean bl = loadTran = this.loadLevel.contains((Object)Level.Full) || this.loadLevel.contains((Object)Level.Tran);
        if (loadData) {
            if (StringUtils.isBlank((String)this.dataSourceID)) {
                apiBinder.bindType(DataSource.class).toProvider(this.dataSource);
            } else {
                apiBinder.bindType(DataSource.class).nameWith(this.dataSourceID).toProvider(this.dataSource);
            }
        }
        if (loadJdbc) {
            JdbcTemplateProvider tempProvider = new JdbcTemplateProvider(this.dataSource);
            if (StringUtils.isBlank((String)this.dataSourceID)) {
                apiBinder.bindType(JdbcAccessor.class).toProvider((Supplier)tempProvider);
                apiBinder.bindType(JdbcConnection.class).toProvider((Supplier)tempProvider);
                apiBinder.bindType(JdbcTemplate.class).toProvider((Supplier)tempProvider);
                apiBinder.bindType(JdbcOperations.class).toProvider((Supplier)tempProvider);
            } else {
                apiBinder.bindType(JdbcAccessor.class).nameWith(this.dataSourceID).toProvider((Supplier)tempProvider);
                apiBinder.bindType(JdbcConnection.class).nameWith(this.dataSourceID).toProvider((Supplier)tempProvider);
                apiBinder.bindType(JdbcTemplate.class).nameWith(this.dataSourceID).toProvider((Supplier)tempProvider);
                apiBinder.bindType(JdbcOperations.class).nameWith(this.dataSourceID).toProvider((Supplier)tempProvider);
            }
        }
        if (loadTran) {
            TransactionManagerProvider managerProvider = new TransactionManagerProvider(this.dataSource);
            TransactionTemplateProvider templateProvider = new TransactionTemplateProvider(this.dataSource);
            if (StringUtils.isBlank((String)this.dataSourceID)) {
                apiBinder.bindType(TransactionManager.class).toProvider((Supplier)managerProvider);
                apiBinder.bindType(TransactionTemplate.class).toProvider((Supplier)templateProvider);
            } else {
                apiBinder.bindType(TransactionManager.class).nameWith(this.dataSourceID).toProvider((Supplier)managerProvider);
                apiBinder.bindType(TransactionTemplate.class).nameWith(this.dataSourceID).toProvider((Supplier)templateProvider);
            }
            TranInterceptor tranInter = new TranInterceptor(this.dataSource);
            Predicate matcherClass = Matchers.annotatedWithClass(Transactional.class);
            Predicate matcherMethod = Matchers.annotatedWithMethod(Transactional.class);
            apiBinder.bindInterceptor(matcherClass, matcherMethod, (MethodInterceptor)tranInter);
        }
    }

    private static class TranInterceptor
    implements MethodInterceptor {
        private Supplier<DataSource> dataSource = null;

        public TranInterceptor(Supplier<DataSource> dataSource) {
            this.dataSource = Objects.requireNonNull(dataSource, "dataSource Provider is null.");
        }

        private boolean testNoRollBackFor(Transactional tranAnno, Throwable e) {
            Class<? extends Throwable>[] noRollBackType;
            for (Class<? extends Throwable> cls : noRollBackType = tranAnno.noRollbackFor()) {
                if (!cls.isInstance(e)) continue;
                return true;
            }
            String[] noRollBackName = tranAnno.noRollbackForClassName();
            String errorType = e.getClass().getName();
            for (String name : noRollBackName) {
                if (!errorType.equals(name)) continue;
                return true;
            }
            return false;
        }

        public final Object invoke(MethodInvocation invocation) throws Throwable {
            Method targetMethod = invocation.getMethod();
            Transactional tranInfo = this.tranAnnotation(targetMethod);
            if (tranInfo == null) {
                return invocation.proceed();
            }
            DataSource dataSource = this.dataSource.get();
            TransactionManager manager = TranManager.getManager(dataSource);
            Propagation behavior = tranInfo.propagation();
            Isolation level = tranInfo.isolation();
            TransactionStatus tranStatus = manager.getTransaction(behavior, level);
            if (tranInfo.readOnly()) {
                tranStatus.setReadOnly();
            }
            try {
                Object object = invocation.proceed();
                return object;
            }
            catch (Throwable e) {
                if (!this.testNoRollBackFor(tranInfo, e)) {
                    tranStatus.setRollbackOnly();
                }
                throw e;
            }
            finally {
                if (!tranStatus.isCompleted()) {
                    manager.commit(tranStatus);
                }
            }
        }

        private Transactional tranAnnotation(Method targetMethod) {
            Transactional tran = targetMethod.getAnnotation(Transactional.class);
            if (tran == null) {
                Class<?> declaringClass = targetMethod.getDeclaringClass();
                tran = declaringClass.getAnnotation(Transactional.class);
            }
            return tran;
        }
    }
}

