/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import net.hasor.db.jdbc.core.ParameterDisposer;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;

public class StatementSetterUtils {
    public static void setParameterValue(PreparedStatement ps, int parameterPosition, Object inValue) throws SQLException {
        if (inValue == null) {
            ps.setObject(parameterPosition, null);
        } else {
            Class<?> valueClass = inValue.getClass();
            TypeHandler<?> typeHandler = TypeHandlerRegistry.DEFAULT.getTypeHandler(valueClass);
            typeHandler.setParameter(ps, parameterPosition, inValue, TypeHandlerRegistry.toSqlType(valueClass));
        }
    }

    public static void cleanupParameters(Object[] paramValues) {
        if (paramValues != null) {
            StatementSetterUtils.cleanupParameters(Arrays.asList(paramValues));
        }
    }

    public static void cleanupParameters(Collection<Object> paramValues) {
        if (paramValues == null) {
            return;
        }
        for (Object inValue : paramValues) {
            StatementSetterUtils.cleanupParameter(inValue);
        }
    }

    public static void cleanupParameter(Object paramValue) {
        if (paramValue == null) {
            return;
        }
        if (paramValue instanceof ParameterDisposer) {
            ((ParameterDisposer)paramValue).cleanupParameters();
        }
    }
}

