/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.lambda.query;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.hasor.db.JdbcUtils;
import net.hasor.db.jdbc.JdbcOperations;
import net.hasor.db.jdbc.ResultSetExtractor;
import net.hasor.db.jdbc.RowCallbackHandler;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.jdbc.lambda.LambdaOperations;
import net.hasor.db.jdbc.lambda.QueryExecute;
import net.hasor.db.jdbc.lambda.dialect.SqlDialect;
import net.hasor.db.jdbc.lambda.dialect.SqlDialectRegister;
import net.hasor.db.jdbc.mapping.BeanRowMapper;

public abstract class AbstractQueryExecute<T>
implements QueryExecute<T>,
LambdaOperations.BoundSql {
    protected final String dbType;
    private final SqlDialect dialect;
    private final Class<T> exampleType;
    private final BeanRowMapper<T> exampleRowMapper;
    private final JdbcOperations jdbcOperations;
    private boolean useDialect;

    public AbstractQueryExecute(Class<T> exampleType, JdbcTemplate jdbcTemplate) {
        String tmpDbType;
        this.exampleType = exampleType;
        this.jdbcOperations = jdbcTemplate;
        this.exampleRowMapper = jdbcTemplate != null ? jdbcTemplate.getMappingHandler().resolveMapper(exampleType) : BeanRowMapper.newInstance(exampleType);
        try {
            tmpDbType = this.getJdbcOperations().execute(con -> {
                DatabaseMetaData metaData = con.getMetaData();
                return JdbcUtils.getDbType(metaData.getURL(), metaData.getDriverName());
            });
        }
        catch (Exception e) {
            tmpDbType = "";
        }
        SqlDialect tempDialect = SqlDialectRegister.findOrCreate(tmpDbType);
        this.dbType = tmpDbType;
        this.dialect = tempDialect == null ? SqlDialect.DEFAULT : tempDialect;
        this.useDialect = false;
    }

    AbstractQueryExecute(Class<T> exampleType, JdbcOperations jdbcOperations, String dbType, SqlDialect dialect) {
        this.exampleType = exampleType;
        this.jdbcOperations = jdbcOperations;
        this.exampleRowMapper = jdbcOperations instanceof JdbcTemplate ? ((JdbcTemplate)jdbcOperations).getMappingHandler().resolveMapper(exampleType) : BeanRowMapper.newInstance(exampleType);
        this.dbType = dbType;
        this.dialect = dialect == null ? SqlDialect.DEFAULT : dialect;
    }

    @Override
    public Class<T> exampleType() {
        return this.exampleType;
    }

    public JdbcOperations getJdbcOperations() {
        return this.jdbcOperations;
    }

    protected BeanRowMapper<T> getRowMapper() {
        return this.exampleRowMapper;
    }

    protected SqlDialect dialect() {
        return this.useDialect && this.dialect != null ? this.dialect : SqlDialect.DEFAULT;
    }

    @Override
    public <V> QueryExecute<V> wrapperType(Class<V> wrapperType) {
        final AbstractQueryExecute self = this;
        return new AbstractQueryExecute<V>(wrapperType, this.jdbcOperations, this.dbType, this.dialect){

            @Override
            public String getSqlString() {
                return self.getSqlString();
            }

            @Override
            public Map<String, Object> getArgs() {
                return self.getArgs();
            }
        };
    }

    @Override
    public <V> V query(ResultSetExtractor<V> rse) throws SQLException {
        return this.jdbcOperations.query(this.getSqlString(), this.getArgs(), rse);
    }

    @Override
    public void query(RowCallbackHandler rch) throws SQLException {
        this.jdbcOperations.query(this.getSqlString(), this.getArgs(), rch);
    }

    @Override
    public <V> List<V> query(RowMapper<V> rowMapper) throws SQLException {
        return this.jdbcOperations.query(this.getSqlString(), this.getArgs(), rowMapper);
    }

    @Override
    public List<T> queryForList() throws SQLException {
        return this.jdbcOperations.query(this.getSqlString(), this.getArgs(), this.getRowMapper());
    }

    @Override
    public T queryForObject() throws SQLException {
        return this.jdbcOperations.queryForObject(this.getSqlString(), this.getArgs(), this.getRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap() throws SQLException {
        return this.jdbcOperations.queryForMap(this.getSqlString(), this.getArgs());
    }

    @Override
    public List<Map<String, Object>> queryForMapList() throws SQLException {
        return this.jdbcOperations.queryForList(this.getSqlString(), this.getArgs());
    }
}

