/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.lambda.segment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hasor.db.jdbc.lambda.segment.Segment;

public class MergeSqlSegment
implements Segment {
    private final List<Segment> segments = new ArrayList<Segment>();

    public MergeSqlSegment(List<Segment> segments) {
        this.segments.addAll(segments);
    }

    public MergeSqlSegment(Segment ... segments) {
        this.segments.addAll(Arrays.asList(segments));
    }

    public void addSegment(Segment segment) {
        if (segment != null) {
            this.segments.add(segment);
        }
    }

    @Override
    public String getSqlSegment() {
        return this.getSqlSegment(this.segments);
    }

    public MergeSqlSegment sub(int form) {
        return new MergeSqlSegment(this.segments.subList(form, this.segments.size()));
    }

    public String noFirstSqlSegment() {
        return this.getSqlSegment(this.segments.subList(1, this.segments.size()));
    }

    private String getSqlSegment(List<Segment> dataList) {
        StringBuilder strBuilder = new StringBuilder("");
        for (Segment segment : dataList) {
            strBuilder.append(segment.getSqlSegment()).append(" ");
        }
        return strBuilder.toString().trim();
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }
}

