/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction;

public enum Isolation {
    DEFAULT(-1),
    READ_UNCOMMITTED(1),
    READ_COMMITTED(2),
    REPEATABLE_READ(4),
    SERIALIZABLE(8);

    private int value;

    private Isolation(int value) {
        this.value = value;
    }

    public static Isolation valueOf(int value) {
        switch (value) {
            case -1: {
                return DEFAULT;
            }
            case 1: {
                return READ_UNCOMMITTED;
            }
            case 2: {
                return READ_COMMITTED;
            }
            case 4: {
                return REPEATABLE_READ;
            }
            case 8: {
                return SERIALIZABLE;
            }
        }
        throw new IllegalStateException(String.format("Connection ISOLATION error level %s.", value));
    }

    protected int value() {
        return this.value;
    }
}

