/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.hasor.db.types.EnumOfCode;
import net.hasor.db.types.EnumOfValue;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class EnumTypeHandler<E extends Enum<E>>
extends AbstractTypeHandler<E> {
    private final Class<E> type;
    private final EnumOfCode<E> ofCode;
    private final EnumOfValue<E> ofValue;

    public EnumTypeHandler(Class<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
        Enum[] enums = (Enum[])type.getEnumConstants();
        this.ofCode = enums.length > 0 && EnumOfCode.class.isAssignableFrom(type) ? (EnumOfCode)((Object)enums[0]) : null;
        this.ofValue = enums.length > 0 && EnumOfValue.class.isAssignableFrom(type) ? (EnumOfValue)((Object)enums[0]) : null;
        if (this.ofCode != null && this.ofValue != null) {
            throw new IllegalArgumentException(type.getName() + " Type EnumOfCode and EnumOfValue cannot exist at the same time.");
        }
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JDBCType jdbcType) throws SQLException {
        if (parameter instanceof EnumOfCode && this.ofCode != null) {
            ps.setString(i, ((EnumOfCode)parameter).codeName());
            return;
        }
        if (parameter instanceof EnumOfValue && this.ofValue != null) {
            ps.setInt(i, ((EnumOfValue)parameter).codeValue());
            return;
        }
        if (jdbcType == null) {
            ps.setString(i, ((Enum)parameter).name());
        } else {
            ps.setObject(i, (Object)((Enum)parameter).name(), jdbcType);
        }
    }

    @Override
    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        if (this.ofCode != null) {
            String s = rs.getString(columnName);
            return s == null ? null : (E)this.valueByOfCode(s);
        }
        if (this.ofValue != null) {
            int s = rs.getInt(columnName);
            return rs.wasNull() ? null : (E)this.valueByOfValue(s);
        }
        String s = rs.getString(columnName);
        return s == null ? null : (E)this.valueOf(s);
    }

    @Override
    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        if (this.ofCode != null) {
            String s = rs.getString(columnIndex);
            return s == null ? null : (E)this.valueByOfCode(s);
        }
        if (this.ofValue != null) {
            int s = rs.getInt(columnIndex);
            return rs.wasNull() ? null : (E)this.valueByOfValue(s);
        }
        String s = rs.getString(columnIndex);
        return s == null ? null : (E)this.valueOf(s);
    }

    @Override
    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        if (this.ofCode != null) {
            String s = cs.getString(columnIndex);
            return s == null ? null : (E)this.valueByOfCode(s);
        }
        if (this.ofValue != null) {
            int s = cs.getInt(columnIndex);
            return cs.wasNull() ? null : (E)this.valueByOfValue(s);
        }
        String s = cs.getString(columnIndex);
        return s == null ? null : (E)this.valueOf(s);
    }

    private E valueByOfValue(int s) {
        return (E)((Enum)this.ofValue.valueOfCode(s));
    }

    private E valueByOfCode(String s) {
        return (E)((Enum)this.ofCode.valueOfCode(s));
    }

    private E valueOf(String enumDat) {
        if (this.ofCode != null) {
            return (E)((Enum)this.ofCode.valueOfCode(enumDat));
        }
        return Enum.valueOf(this.type, enumDat);
    }
}

