/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.YearMonth;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class YearMonthOfNumberTypeHandler
extends AbstractTypeHandler<YearMonth> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, YearMonth yearMonth, JDBCType jdbcType) throws SQLException {
        String monthValue = String.valueOf(yearMonth.getMonthValue());
        if (monthValue.length() == 1) {
            monthValue = "0" + monthValue;
        }
        ps.setInt(i, Integer.parseInt(yearMonth.getYear() + monthValue));
    }

    @Override
    public YearMonth getNullableResult(ResultSet rs, String columnName) throws SQLException {
        int yearMonth = rs.getInt(columnName);
        return yearMonth == 0 && rs.wasNull() ? null : YearMonthOfNumberTypeHandler.parseYearMonth(yearMonth);
    }

    @Override
    public YearMonth getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        int yearMonth = rs.getInt(columnIndex);
        return yearMonth == 0 && rs.wasNull() ? null : YearMonthOfNumberTypeHandler.parseYearMonth(yearMonth);
    }

    @Override
    public YearMonth getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        int yearMonth = cs.getInt(columnIndex);
        return yearMonth == 0 && cs.wasNull() ? null : YearMonthOfNumberTypeHandler.parseYearMonth(yearMonth);
    }

    private static YearMonth parseYearMonth(int yearMonth) throws SQLException {
        String ymStr = String.valueOf(yearMonth);
        if (ymStr.length() != 6) {
            throw new SQLException("JDBC requires that the yearMonth value must be 6 Numbers");
        }
        int year = Integer.parseInt(ymStr.substring(0, 4));
        int month = Integer.parseInt(ymStr.substring(4));
        return YearMonth.of(year, month);
    }
}

