/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class YearMonthOfTimeTypeHandler
extends AbstractTypeHandler<YearMonth> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, YearMonth parameter, JDBCType jdbcType) throws SQLException {
        LocalDateTime dateTime = LocalDateTime.MIN.withYear(parameter.getYear()).withMonth(parameter.getMonthValue());
        ps.setTimestamp(i, Timestamp.valueOf(dateTime));
    }

    @Override
    public YearMonth getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnName);
        return YearMonthOfTimeTypeHandler.toYearMonth(timestamp);
    }

    @Override
    public YearMonth getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnIndex);
        return YearMonthOfTimeTypeHandler.toYearMonth(timestamp);
    }

    @Override
    public YearMonth getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Timestamp timestamp = cs.getTimestamp(columnIndex);
        return YearMonthOfTimeTypeHandler.toYearMonth(timestamp);
    }

    private static YearMonth toYearMonth(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        LocalDate localDate = timestamp.toLocalDateTime().toLocalDate();
        return YearMonth.of(localDate.getYear(), localDate.getMonthValue());
    }
}

