/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect.provider;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.utils.StringUtils;

public class InformixDialect
implements SqlDialect {
    @Override
    public String tableName(boolean useQualifier, String category, String tableName) {
        String qualifier;
        String string = qualifier = useQualifier ? "\"" : "";
        if (StringUtils.isBlank((String)category)) {
            return qualifier + tableName + qualifier;
        }
        return qualifier + category + qualifier + "." + qualifier + tableName + qualifier;
    }

    @Override
    public String columnName(boolean useQualifier, String category, String tableName, String columnName, JDBCType jdbcType, Class<?> javaType) {
        String qualifier = useQualifier ? "\"" : "";
        return qualifier + columnName + qualifier;
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, int start, int limit) {
        String sqlString = boundSql.getSqlString();
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Integer> newParam = new ArrayList<Integer>();
        sqlBuilder.append("SELECT ");
        if (start > 0) {
            sqlBuilder.append(" SKIP ? ");
            newParam.add(start);
        }
        if (limit > 0) {
            sqlBuilder.append(" FIRST ? ");
            newParam.add(limit);
        }
        sqlBuilder.append(" * FROM ( ");
        sqlBuilder.append(sqlString);
        sqlBuilder.append(" ) TEMP_T");
        paramArrays.addAll(0, newParam);
        return new BoundSql.BoundSqlObj(sqlBuilder.toString(), paramArrays.toArray());
    }
}

