/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect.provider;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.InsertSqlDialect;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.mapping.FieldInfo;
import net.hasor.utils.StringUtils;

public class MySqlDialect
implements SqlDialect,
InsertSqlDialect {
    @Override
    public String tableName(boolean useQualifier, String category, String tableName) {
        String qualifier;
        String string = qualifier = useQualifier ? "`" : "";
        if (StringUtils.isBlank((String)category)) {
            return qualifier + tableName + qualifier;
        }
        return qualifier + category + qualifier + "." + qualifier + tableName + qualifier;
    }

    @Override
    public String columnName(boolean useQualifier, String category, String tableName, String columnName, JDBCType jdbcType, Class<?> javaType) {
        String qualifier = useQualifier ? "`" : "";
        return qualifier + columnName + qualifier;
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, int start, int limit) {
        StringBuilder sqlBuilder = new StringBuilder(boundSql.getSqlString());
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        if (start <= 0) {
            sqlBuilder.append(" LIMIT ?");
            paramArrays.add(limit);
        } else {
            sqlBuilder.append(" LIMIT ?, ?");
            paramArrays.add(start);
            paramArrays.add(limit);
        }
        return new BoundSql.BoundSqlObj(sqlBuilder.toString(), paramArrays.toArray());
    }

    @Override
    public boolean supportInsertIgnore(List<FieldInfo> pkFields) {
        return true;
    }

    @Override
    public String insertWithIgnore(boolean useQualifier, String category, String tableName, List<FieldInfo> pkFields, List<FieldInfo> insertFields) {
        String allColumns = this.buildAllColumns(useQualifier, category, tableName, insertFields);
        int fieldCount = insertFields.size();
        return "INSERT IGNORE " + this.tableName(useQualifier, category, tableName) + " ( " + allColumns + " ) VALUES ( " + StringUtils.repeat((String)",?", (int)fieldCount).substring(1) + " )";
    }

    @Override
    public boolean supportInsertReplace(List<FieldInfo> pkFields) {
        return true;
    }

    @Override
    public String insertWithReplace(boolean useQualifier, String category, String tableName, List<FieldInfo> pkFields, List<FieldInfo> insertFields) {
        String allColumns = this.buildAllColumns(useQualifier, category, tableName, insertFields);
        int fieldCount = insertFields.size();
        return "REPLACE INTO " + this.tableName(useQualifier, category, tableName) + " ( " + allColumns + " ) VALUES ( " + StringUtils.repeat((String)",?", (int)fieldCount).substring(1) + " )";
    }

    private String buildAllColumns(boolean useQualifier, String category, String tableName, List<FieldInfo> insertFields) {
        return insertFields.stream().map(fieldInfo -> this.columnName(useQualifier, category, tableName, fieldInfo.getColumnName(), fieldInfo.getJdbcType(), fieldInfo.getJavaType())).reduce((s1, s2) -> s1 + " , " + s2).orElse("");
    }
}

