/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect.provider;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.InsertSqlDialect;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.mapping.FieldInfo;
import net.hasor.utils.StringUtils;

public class OracleDialect
implements SqlDialect,
InsertSqlDialect {
    @Override
    public String tableName(boolean useQualifier, String category, String tableName) {
        if (StringUtils.isBlank((String)category)) {
            return OracleDialect.fmtQualifier(useQualifier, tableName);
        }
        return OracleDialect.fmtQualifier(useQualifier, category) + "." + OracleDialect.fmtQualifier(useQualifier, tableName);
    }

    @Override
    public String columnName(boolean useQualifier, String category, String tableName, String columnName, JDBCType jdbcType, Class<?> javaType) {
        return OracleDialect.fmtQualifier(useQualifier, columnName);
    }

    @Override
    public BoundSql countSql(BoundSql boundSql) {
        String sqlBuilder = "SELECT COUNT(*) FROM (" + boundSql.getSqlString() + ") TEMP_T";
        return new BoundSql.BoundSqlObj(sqlBuilder, boundSql.getArgs());
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, int start, int limit) {
        String sqlString = boundSql.getSqlString();
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT * FROM ( SELECT TMP.*, ROWNUM ROW_ID FROM ( ");
        sqlBuilder.append(sqlString);
        sqlBuilder.append(" ) TMP WHERE ROWNUM <= ? ) WHERE ROW_ID > ?");
        paramArrays.add(start + limit);
        paramArrays.add(start);
        return new BoundSql.BoundSqlObj(sqlBuilder.toString(), paramArrays.toArray());
    }

    private static String fmtQualifier(boolean useQualifier, String fmtString) {
        String qualifier = useQualifier ? "\"" : "";
        return qualifier + fmtString + qualifier;
    }

    @Override
    public boolean supportInsertIgnore(List<FieldInfo> pkFields) {
        return !pkFields.isEmpty();
    }

    @Override
    public String insertWithIgnore(boolean useQualifier, String category, String tableName, List<FieldInfo> pkFields, List<FieldInfo> insertFields) {
        List<FieldInfo> pkColumns = insertFields.stream().filter(FieldInfo::isPrimary).collect(Collectors.toList());
        StringBuilder mergeBasic = OracleDialect.buildMergeInfoBasic(useQualifier, category, tableName, insertFields, pkColumns);
        StringBuilder mergeWhenNotMatched = OracleDialect.buildMergeInfoWhenNotMatched(useQualifier, insertFields);
        return mergeBasic.toString() + " " + mergeWhenNotMatched.toString();
    }

    @Override
    public boolean supportInsertReplace(List<FieldInfo> pkFields) {
        return !pkFields.isEmpty();
    }

    @Override
    public String insertWithReplace(boolean useQualifier, String category, String tableName, List<FieldInfo> pkFields, List<FieldInfo> insertFields) {
        List<FieldInfo> pkColumns = insertFields.stream().filter(FieldInfo::isPrimary).collect(Collectors.toList());
        StringBuilder mergeBasic = OracleDialect.buildMergeInfoBasic(useQualifier, category, tableName, insertFields, pkColumns);
        StringBuilder mergeWhenMatched = OracleDialect.buildMergeInfoWhenMatched(useQualifier, insertFields);
        return mergeBasic.toString() + " " + mergeWhenMatched.toString();
    }

    private static StringBuilder buildMergeInfoBasic(boolean useQualifier, String category, String tableName, List<FieldInfo> allColumns, List<FieldInfo> pkColumns) {
        int i;
        StringBuilder mergeBuilder = new StringBuilder();
        String finalTableName = OracleDialect.fmtQualifier(useQualifier, tableName);
        if (StringUtils.isNotBlank((String)category)) {
            finalTableName = OracleDialect.fmtQualifier(useQualifier, category) + "." + finalTableName;
        }
        mergeBuilder.append("MERGE INTO " + finalTableName + " TMP USING( SELECT ");
        for (i = 0; i < allColumns.size(); ++i) {
            FieldInfo fieldInfo = allColumns.get(i);
            if (i != 0) {
                mergeBuilder.append(" , ");
            }
            mergeBuilder.append("? " + OracleDialect.fmtQualifier(useQualifier, fieldInfo.getColumnName()));
        }
        mergeBuilder.append(" FROM dual) SRC ON (");
        for (i = 0; i < pkColumns.size(); ++i) {
            if (i != 0) {
                mergeBuilder.append(" AND ");
            }
            String pkColumn = OracleDialect.fmtQualifier(useQualifier, pkColumns.get(i).getColumnName());
            mergeBuilder.append("TMP." + pkColumn + " = SRC." + pkColumn);
        }
        mergeBuilder.append(")");
        return mergeBuilder;
    }

    private static StringBuilder buildMergeInfoWhenNotMatched(boolean useQualifier, List<FieldInfo> allColumns) {
        String allColumnString = allColumns.stream().map(fieldInfo -> OracleDialect.fmtQualifier(useQualifier, fieldInfo.getColumnName())).reduce((s1, s2) -> s1 + "," + s2).orElse("");
        StringBuilder mergeBuilder = new StringBuilder();
        mergeBuilder.append("WHEN NOT MATCHED THEN ");
        mergeBuilder.append("INSERT(" + allColumnString + ") ");
        mergeBuilder.append("VALUES( ");
        for (int i = 0; i < allColumns.size(); ++i) {
            FieldInfo column = allColumns.get(i);
            if (i != 0) {
                mergeBuilder.append(" , ");
            }
            mergeBuilder.append("SRC." + OracleDialect.fmtQualifier(useQualifier, column.getColumnName()));
        }
        mergeBuilder.append(")");
        return mergeBuilder;
    }

    private static StringBuilder buildMergeInfoWhenMatched(boolean useQualifier, List<FieldInfo> allColumns) {
        StringBuilder mergeBuilder = new StringBuilder();
        mergeBuilder.append("WHEN MATCHED THEN ");
        mergeBuilder.append("UPDATE SET ");
        for (int i = 0; i < allColumns.size(); ++i) {
            FieldInfo column = allColumns.get(i);
            if (i != 0) {
                mergeBuilder.append(" , ");
            }
            String columnName = OracleDialect.fmtQualifier(useQualifier, column.getColumnName());
            mergeBuilder.append(columnName + " = SRC." + columnName);
        }
        mergeBuilder.append(" ");
        return mergeBuilder;
    }
}

