/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect.provider;

import java.util.ArrayList;
import java.util.Arrays;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.dialect.provider.SqlServerDialect;
import net.hasor.utils.StringUtils;

public class SqlServer2005Dialect
extends SqlServerDialect
implements SqlDialect {
    private static String getOrderByPart(String sql) {
        String loweredString = sql.toLowerCase();
        int orderByIndex = loweredString.indexOf("order by");
        if (orderByIndex != -1) {
            return sql.substring(orderByIndex);
        }
        return "";
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, int start, int limit) {
        String sqlString = boundSql.getSqlString();
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        StringBuilder pagingBuilder = new StringBuilder();
        String orderby = SqlServer2005Dialect.getOrderByPart(sqlString);
        String distinctStr = "";
        String loweredString = sqlString.toLowerCase();
        String sqlPartString = sqlString;
        if (loweredString.trim().toLowerCase().startsWith("select")) {
            int index = 6;
            if (loweredString.toLowerCase().startsWith("select distinct")) {
                distinctStr = "DISTINCT ";
                index = 15;
            }
            sqlPartString = sqlPartString.substring(index);
        }
        pagingBuilder.append(sqlPartString);
        if (StringUtils.isBlank((String)orderby)) {
            orderby = "ORDER BY CURRENT_TIMESTAMP";
        }
        long firstParam = start + 1;
        long secondParam = start + limit;
        sqlString = "WITH selectTemp AS (SELECT " + distinctStr + "TOP 100 PERCENT  ROW_NUMBER() OVER (" + orderby + ") as __row_number__, " + pagingBuilder + ") SELECT * FROM selectTemp WHERE __row_number__ BETWEEN " + firstParam + " AND " + secondParam + " ORDER BY __row_number__";
        paramArrays.add(firstParam);
        paramArrays.add(secondParam);
        return new BoundSql.BoundSqlObj(sqlString, paramArrays.toArray());
    }
}

