/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.dialect.provider;

import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Arrays;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.utils.StringUtils;

public class XuGuDialect
implements SqlDialect {
    @Override
    public String tableName(boolean useQualifier, String category, String tableName) {
        String qualifier;
        String string = qualifier = useQualifier ? "`" : "";
        if (StringUtils.isBlank((String)category)) {
            return qualifier + tableName + qualifier;
        }
        return qualifier + category + qualifier + "." + qualifier + tableName + qualifier;
    }

    @Override
    public String columnName(boolean useQualifier, String category, String tableName, String columnName, JDBCType jdbcType, Class<?> javaType) {
        String qualifier = useQualifier ? "`" : "";
        return qualifier + columnName + qualifier;
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, int start, int limit) {
        StringBuilder sqlBuilder = new StringBuilder(boundSql.getSqlString());
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        if (start <= 0) {
            sqlBuilder.append(" LIMIT ?");
            paramArrays.add(limit);
        } else {
            sqlBuilder.append(" LIMIT ?, ?");
            paramArrays.add(start);
            paramArrays.add(limit);
        }
        return new BoundSql.BoundSqlObj(sqlBuilder.toString(), paramArrays.toArray());
    }
}

