/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.hasor.db.jdbc.PreparedStatementSetter;
import net.hasor.db.jdbc.core.ParameterDisposer;
import net.hasor.db.jdbc.core.StatementSetterUtils;
import net.hasor.db.types.TypeHandlerRegistry;

public class ArgPreparedStatementSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final TypeHandlerRegistry typeHandlerRegistry;
    private final Object[] args;

    public ArgPreparedStatementSetter(Object[] args) {
        this(TypeHandlerRegistry.DEFAULT, args);
    }

    public ArgPreparedStatementSetter(TypeHandlerRegistry typeHandlerRegistry, Object[] args) {
        this.typeHandlerRegistry = typeHandlerRegistry;
        this.args = args;
    }

    @Override
    public void setValues(PreparedStatement ps) throws SQLException {
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                Object arg = this.args[i];
                this.doSetValue(ps, i + 1, arg);
            }
        }
    }

    protected void doSetValue(PreparedStatement ps, int parameterPosition, Object argValue) throws SQLException {
        this.typeHandlerRegistry.setParameterValue(ps, parameterPosition, argValue);
    }

    @Override
    public void cleanupParameters() {
        StatementSetterUtils.cleanupParameters(this.args);
    }
}

