/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.extractor;

import java.util.Objects;
import java.util.function.Predicate;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.jdbc.extractor.RowMapperResultSetExtractor;

public class FilterResultSetExtractor<T>
extends RowMapperResultSetExtractor<T> {
    private Predicate<T> rowTester;

    public FilterResultSetExtractor(RowMapper<T> rowMapper) {
        this(s -> true, rowMapper, 0);
    }

    public FilterResultSetExtractor(Predicate<T> rowTester, RowMapper<T> rowMapper) {
        this(rowTester, rowMapper, 0);
    }

    public FilterResultSetExtractor(RowMapper<T> rowMapper, int rowsExpected) {
        this(s -> true, rowMapper, rowsExpected);
    }

    public FilterResultSetExtractor(Predicate<T> rowTester, RowMapper<T> rowMapper, int rowsExpected) {
        super(rowMapper, rowsExpected);
        this.rowTester = Objects.requireNonNull(rowTester, "rowTester is null.");
    }

    @Override
    protected boolean testRow(T mapRow) {
        return this.rowTester.test(mapRow);
    }

    public Predicate<T> getRowTester() {
        return this.rowTester;
    }

    public void setRowTester(Predicate<T> rowTester) {
        this.rowTester = Objects.requireNonNull(rowTester, "rowTester is null.");
    }
}

