/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.extractor;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hasor.db.jdbc.CallableStatementCallback;
import net.hasor.db.jdbc.PreparedStatementCallback;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.jdbc.extractor.RowMapperResultSetExtractor;
import net.hasor.db.jdbc.mapper.ColumnMapRowMapper;
import net.hasor.db.types.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleResultSetExtractor
implements PreparedStatementCallback<List<Object>>,
CallableStatementCallback<List<Object>> {
    private static final Logger logger = LoggerFactory.getLogger(MultipleResultSetExtractor.class);
    private final List<RowMapper<?>> rowMappers;

    public MultipleResultSetExtractor(RowMapper<?> ... rowMapper) {
        this.rowMappers = Arrays.asList(rowMapper);
    }

    @Override
    public List<Object> doInCallableStatement(CallableStatement cs) throws SQLException {
        boolean retVal = cs.execute();
        return this.doResult(retVal, cs);
    }

    @Override
    public List<Object> doInPreparedStatement(PreparedStatement ps) throws SQLException {
        boolean retVal = ps.execute();
        return this.doResult(retVal, ps);
    }

    protected List<Object> doResult(boolean retVal, Statement stmt) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("statement.execute() returned '" + retVal + "'");
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (retVal) {
            try (ResultSet resultSet = stmt.getResultSet();){
                RowMapper<?> rowMapper = this.rowMappers.isEmpty() ? this.getDefaultRowMapper() : this.rowMappers.get(0);
                resultList.add(MultipleResultSetExtractor.processResultSet(resultSet, rowMapper));
            }
        } else {
            resultList.add(stmt.getUpdateCount());
        }
        int resultIndex = 1;
        while (stmt.getMoreResults() || stmt.getUpdateCount() != -1) {
            int updateCount = stmt.getUpdateCount();
            ResultSet resultSet = stmt.getResultSet();
            Throwable throwable = null;
            try {
                if (resultSet != null) {
                    if (this.rowMappers.size() > resultIndex) {
                        resultList.add(MultipleResultSetExtractor.processResultSet(resultSet, this.rowMappers.get(resultIndex++)));
                        continue;
                    }
                    resultList.add(MultipleResultSetExtractor.processResultSet(resultSet, this.getDefaultRowMapper()));
                    continue;
                }
                resultList.add(updateCount);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (resultSet == null) continue;
                if (throwable != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                resultSet.close();
            }
        }
        return resultList;
    }

    protected RowMapper<?> getDefaultRowMapper() {
        return new ColumnMapRowMapper(TypeHandlerRegistry.DEFAULT);
    }

    protected static Object processResultSet(ResultSet rs, RowMapper<?> rowMapper) throws SQLException {
        if (rs == null) {
            return null;
        }
        return new RowMapperResultSetExtractor(rowMapper).extractData(rs);
    }
}

