/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda;

import java.sql.Connection;
import javax.sql.DataSource;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.lambda.LambdaOperations;
import net.hasor.db.lambda.query.LambdaDeleteWrapper;
import net.hasor.db.lambda.query.LambdaInsertWrapper;
import net.hasor.db.lambda.query.LambdaQueryWrapper;
import net.hasor.db.lambda.query.LambdaUpdateWrapper;
import net.hasor.db.mapping.MappingHandler;

public class LambdaTemplate
implements LambdaOperations {
    private final JdbcTemplate jdbcTemplate;

    public LambdaTemplate() {
        this.jdbcTemplate = new JdbcTemplate();
    }

    public LambdaTemplate(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public LambdaTemplate(DataSource dataSource, MappingHandler mappingHandler) {
        this.jdbcTemplate = new JdbcTemplate(dataSource, mappingHandler);
    }

    public LambdaTemplate(Connection conn) {
        this.jdbcTemplate = new JdbcTemplate(conn);
    }

    public LambdaTemplate(Connection conn, MappingHandler mappingHandler) {
        this.jdbcTemplate = new JdbcTemplate(conn, mappingHandler);
    }

    public LambdaTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public <T> LambdaOperations.LambdaQuery<T> lambdaQuery(Class<T> exampleType) {
        return new LambdaQueryWrapper<T>(exampleType, this.getJdbcTemplate());
    }

    @Override
    public <T> LambdaOperations.LambdaDelete<T> lambdaDelete(Class<T> exampleType) {
        return new LambdaDeleteWrapper<T>(exampleType, this.getJdbcTemplate());
    }

    @Override
    public <T> LambdaOperations.LambdaUpdate<T> lambdaUpdate(Class<T> exampleType) {
        return new LambdaUpdateWrapper<T>(exampleType, this.getJdbcTemplate());
    }

    @Override
    public <T> LambdaOperations.LambdaInsert<T> lambdaInsert(Class<T> exampleType) {
        return new LambdaInsertWrapper<T>(exampleType, this.getJdbcTemplate());
    }
}

