/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.page;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public interface Page {
    public int getPageSize();

    public void setPageSize(int var1);

    public int getCurrentPage();

    public void setCurrentPage(int var1);

    public int getPageNumberOffset();

    public void setPageNumberOffset(int var1);

    public int getFirstRecordPosition();

    public int getTotalPage() throws SQLException;

    public int getTotalCount() throws SQLException;

    default public void firstPage() {
        this.setCurrentPage(0);
    }

    default public void previousPage() {
        this.setCurrentPage(this.getCurrentPage() - 1);
    }

    default public void nextPage() {
        this.setCurrentPage(this.getCurrentPage() + 1);
    }

    default public void lastPage() throws SQLException {
        this.setCurrentPage(this.getTotalPage() - 1);
    }

    default public Map<String, Object> toPageInfo() throws SQLException {
        return new LinkedHashMap<String, Object>(){
            {
                this.put("enable", Page.this.getPageSize() > 0);
                this.put("pageSize", Page.this.getPageSize());
                this.put("totalCount", Page.this.getTotalCount());
                this.put("totalPage", Page.this.getTotalPage());
                this.put("currentPage", Page.this.getCurrentPage());
                this.put("recordPosition", Page.this.getFirstRecordPosition());
            }
        };
    }
}

