/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.page;

import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hasor.db.lambda.page.Page;
import net.hasor.utils.function.ESupplier;

public class PageObject
implements Page {
    private ESupplier<Integer, SQLException> totalCountSupplier = () -> 0;
    private int totalCount = 0;
    private final AtomicBoolean totalCountInited = new AtomicBoolean(false);
    private int pageSize = 0;
    private int currentPage = 0;
    private int pageNumberOffset = 0;

    public PageObject() {
        this.totalCountSupplier = () -> 0;
    }

    public PageObject(int pageSize, ESupplier<Integer, SQLException> totalCountSupplier) {
        Objects.requireNonNull(totalCountSupplier, "totalCountSupplier is null.");
        this.pageSize = pageSize;
        this.totalCountSupplier = totalCountSupplier;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize <= 0 ? 0 : pageSize;
    }

    @Override
    public int getCurrentPage() {
        if (this.pageSize > 0) {
            return this.currentPage + this.pageNumberOffset;
        }
        return this.pageNumberOffset;
    }

    @Override
    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage <= this.pageNumberOffset ? 0 : currentPage - this.pageNumberOffset;
    }

    @Override
    public int getPageNumberOffset() {
        return this.pageNumberOffset;
    }

    @Override
    public void setPageNumberOffset(int pageNumberOffset) {
        this.pageNumberOffset = Math.max(pageNumberOffset, 0);
    }

    @Override
    public int getFirstRecordPosition() {
        int pgSize = this.getPageSize();
        if (pgSize <= 0) {
            return 0;
        }
        return pgSize * this.currentPage;
    }

    @Override
    public int getTotalPage() throws SQLException {
        int pgSize = this.getPageSize();
        if (pgSize > 0) {
            int totalCount = this.getTotalCount();
            if (totalCount == 0) {
                return this.pageNumberOffset;
            }
            int result = totalCount / pgSize;
            if (totalCount % pgSize != 0) {
                ++result;
            }
            return result + this.pageNumberOffset;
        }
        int totalCount = this.getTotalCount();
        if (totalCount > 0) {
            return this.pageNumberOffset + 1;
        }
        return this.pageNumberOffset;
    }

    @Override
    public int getTotalCount() throws SQLException {
        if (this.totalCountInited.compareAndSet(false, true)) {
            this.totalCount = (Integer)this.totalCountSupplier.eGet();
        }
        return this.totalCount;
    }
}

