/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.query;

import java.sql.DatabaseMetaData;
import net.hasor.db.JdbcUtils;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.dialect.SqlDialectRegister;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.mapping.MappingRowMapper;

public abstract class AbstractExecute<T> {
    protected final String dbType;
    private SqlDialect dialect;
    private final Class<T> exampleType;
    private final MappingRowMapper<T> exampleRowMapper;
    private final JdbcTemplate jdbcTemplate;
    private boolean qualifier;

    public AbstractExecute(Class<T> exampleType, JdbcTemplate jdbcTemplate) {
        this.exampleType = exampleType;
        this.jdbcTemplate = jdbcTemplate;
        this.exampleRowMapper = jdbcTemplate.getMappingHandler().resolveMapper(exampleType);
        this.exampleRowMapper.setCaseInsensitive(jdbcTemplate.isResultsCaseInsensitive());
        String tmpDbType = "";
        try {
            tmpDbType = jdbcTemplate.execute(con -> {
                DatabaseMetaData metaData = con.getMetaData();
                return JdbcUtils.getDbType(metaData.getURL(), metaData.getDriverName());
            });
        }
        catch (Exception e) {
            tmpDbType = "";
        }
        SqlDialect tempDialect = SqlDialectRegister.findOrCreate(tmpDbType);
        this.dbType = tmpDbType;
        this.dialect = tempDialect == null ? SqlDialect.DEFAULT : tempDialect;
    }

    AbstractExecute(Class<T> exampleType, JdbcTemplate jdbcTemplate, String dbType, SqlDialect dialect) {
        this.exampleType = exampleType;
        this.jdbcTemplate = jdbcTemplate;
        this.exampleRowMapper = jdbcTemplate.getMappingHandler().resolveMapper(exampleType);
        this.exampleRowMapper.setCaseInsensitive(jdbcTemplate.isResultsCaseInsensitive());
        this.dbType = dbType;
        this.dialect = dialect == null ? SqlDialect.DEFAULT : dialect;
    }

    public final Class<T> exampleType() {
        return this.exampleType;
    }

    public final JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected final MappingRowMapper<T> getRowMapper() {
        return this.exampleRowMapper;
    }

    protected final SqlDialect dialect() {
        return this.dialect;
    }

    protected final void setDialect(SqlDialect sqlDialect) {
        this.dialect = sqlDialect;
    }

    protected void enableQualifier() {
        this.qualifier = true;
    }

    protected boolean isQualifier() {
        return this.qualifier;
    }
}

