/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.lambda.QueryCompare;
import net.hasor.db.lambda.query.AbstractQueryExecute;
import net.hasor.db.lambda.segment.MergeSqlSegment;
import net.hasor.db.lambda.segment.Segment;
import net.hasor.db.lambda.segment.SqlKeyword;
import net.hasor.db.lambda.segment.SqlLike;
import net.hasor.db.mapping.FieldInfo;
import net.hasor.db.mapping.TableInfo;
import net.hasor.utils.ArrayUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.reflect.MethodUtils;
import net.hasor.utils.reflect.SFunction;

public abstract class AbstractQueryCompare<T, R>
extends AbstractQueryExecute<T>
implements QueryCompare<T, R> {
    private static final Map<String, FieldInfo> COLUMN_CACHE = new WeakHashMap<String, FieldInfo>();
    private static final ReadWriteLock COLUMN_CACHE_LOCK = new ReentrantReadWriteLock();
    protected MergeSqlSegment queryTemplate = new MergeSqlSegment(new Segment[0]);
    protected List<Object> queryParam = new ArrayList<Object>();
    private Segment nextSegmentPrefix = null;
    private boolean lookCondition = false;

    public AbstractQueryCompare(Class<T> exampleType, JdbcTemplate jdbcTemplate) {
        super(exampleType, jdbcTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FieldInfo columnName(SFunction<T> property) {
        Method targetMethod = MethodUtils.lambdaMethodName(property);
        String cacheKey = targetMethod.toGenericString();
        Lock readLock = COLUMN_CACHE_LOCK.readLock();
        try {
            readLock.lock();
            FieldInfo fieldMeta = COLUMN_CACHE.get(cacheKey);
            if (fieldMeta != null) {
                FieldInfo fieldInfo = fieldMeta;
                return fieldInfo;
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = COLUMN_CACHE_LOCK.writeLock();
        try {
            writeLock.lock();
            FieldInfo fieldMeta = COLUMN_CACHE.get(cacheKey);
            if (fieldMeta != null) {
                FieldInfo fieldInfo = fieldMeta;
                return fieldInfo;
            }
            String methodName = targetMethod.getName();
            String attr = methodName.startsWith("get") ? methodName.substring(3) : methodName.substring(2);
            attr = StringUtils.firstCharToLowerCase((String)attr);
            FieldInfo fieldInfo = super.getRowMapper().findFieldByProperty(attr);
            COLUMN_CACHE.put(cacheKey, fieldInfo);
            FieldInfo fieldInfo2 = fieldInfo;
            return fieldInfo2;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public R or() {
        this.nextSegmentPrefix = SqlKeyword.OR;
        return this.getSelf();
    }

    @Override
    public R and() {
        this.nextSegmentPrefix = SqlKeyword.AND;
        return this.getSelf();
    }

    @Override
    public R nested(Consumer<QueryCompare<T, R>> lambda) {
        this.addCondition(SqlKeyword.LEFT);
        this.nextSegmentPrefix = SqlKeyword.EMPTY;
        lambda.accept(this);
        this.nextSegmentPrefix = SqlKeyword.EMPTY;
        this.addCondition(SqlKeyword.RIGHT);
        return this.getSelf();
    }

    @Override
    public R eq(SFunction<T> property, Object value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.EQ, this.formatValue(value));
    }

    @Override
    public R ne(SFunction<T> property, Object value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.NE, this.formatValue(value));
    }

    @Override
    public R gt(SFunction<T> property, Object value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.GT, this.formatValue(value));
    }

    @Override
    public R ge(SFunction<T> property, Object value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.GE, this.formatValue(value));
    }

    @Override
    public R lt(SFunction<T> property, Object value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.LT, this.formatValue(value));
    }

    @Override
    public R le(SFunction<T> property, Object value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.LE, this.formatValue(value));
    }

    @Override
    public R like(SFunction<T> property, Object value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.LIKE, this.formatLikeValue(SqlLike.DEFAULT, value));
    }

    @Override
    public R notLike(SFunction<T> property, Object value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(SqlLike.DEFAULT, value));
    }

    @Override
    public R likeRight(SFunction<T> property, Object value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.LIKE, this.formatLikeValue(SqlLike.RIGHT, value));
    }

    @Override
    public R notLikeRight(SFunction<T> property, Object value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(SqlLike.RIGHT, value));
    }

    @Override
    public R likeLeft(SFunction<T> property, Object value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.LIKE, this.formatLikeValue(SqlLike.LEFT, value));
    }

    @Override
    public R notLikeLeft(SFunction<T> property, Object value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(SqlLike.LEFT, value));
    }

    @Override
    public R isNull(SFunction<T> property) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.IS_NULL);
    }

    @Override
    public R isNotNull(SFunction<T> property) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.IS_NOT_NULL);
    }

    @Override
    public R in(SFunction<T> property, Collection<?> value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.IN, SqlKeyword.LEFT, this.formatValue(value.toArray()), SqlKeyword.RIGHT);
    }

    @Override
    public R notIn(SFunction<T> property, Collection<?> value) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.NOT, SqlKeyword.IN, SqlKeyword.LEFT, this.formatValue(value.toArray()), SqlKeyword.RIGHT);
    }

    @Override
    public R between(SFunction<T> property, Object value1, Object value2) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.BETWEEN, this.formatValue(value1), SqlKeyword.AND, this.formatValue(value2));
    }

    @Override
    public R notBetween(SFunction<T> property, Object value1, Object value2) {
        return this.addCondition(() -> this.conditionName(property), SqlKeyword.NOT, SqlKeyword.BETWEEN, this.formatValue(value1), SqlKeyword.AND, this.formatValue(value2));
    }

    @Override
    public R apply(String sqlString, Object ... args) {
        if (StringUtils.isBlank((String)sqlString)) {
            return this.getSelf();
        }
        this.queryTemplate.addSegment(() -> {
            if (args != null && args.length > 0) {
                for (Object arg : args) {
                    this.format(arg);
                }
            }
            return sqlString;
        });
        return this.getSelf();
    }

    protected void lockCondition() {
        this.lookCondition = true;
    }

    protected final R addCondition(Segment ... segments) {
        if (this.lookCondition) {
            throw new UnsupportedOperationException("condition is locked.");
        }
        if (this.nextSegmentPrefix == SqlKeyword.EMPTY) {
            this.nextSegmentPrefix = null;
        } else if (this.nextSegmentPrefix == null) {
            this.queryTemplate.addSegment(SqlKeyword.AND);
            this.nextSegmentPrefix = null;
        } else {
            this.queryTemplate.addSegment(this.nextSegmentPrefix);
            this.nextSegmentPrefix = null;
        }
        for (Segment segment : segments) {
            this.queryTemplate.addSegment(segment);
        }
        return this.getSelf();
    }

    protected abstract R getSelf();

    private Segment formatLikeValue(SqlLike like, Object param) {
        return () -> {
            this.format(param);
            return this.dialect().like(like, param);
        };
    }

    private Segment formatValue(Object ... params) {
        if (ArrayUtils.isEmpty((Object[])params)) {
            return () -> "";
        }
        MergeSqlSegment mergeSqlSegment = new MergeSqlSegment(new Segment[0]);
        Iterator<Object> iterator = Arrays.asList(params).iterator();
        while (iterator.hasNext()) {
            mergeSqlSegment.addSegment(this.formatSegment(iterator.next()));
            if (!iterator.hasNext()) continue;
            mergeSqlSegment.addSegment(() -> ",");
        }
        return mergeSqlSegment;
    }

    protected Segment formatSegment(Object param) {
        return () -> this.format(param);
    }

    protected String format(Object param) {
        this.queryParam.add(param);
        return "?";
    }

    protected String conditionName(SFunction<T> property) {
        TableInfo tableInfo = super.getRowMapper().getTableInfo();
        FieldInfo columnField = this.columnName(property);
        return this.dialect().columnName(this.isQualifier(), tableInfo.getCategory(), tableInfo.getTableName(), columnField.getColumnName(), columnField.getJdbcType(), columnField.getJavaType());
    }

    @Override
    public BoundSql getOriginalBoundSql() {
        return new BoundSql(){

            @Override
            public String getSqlString() {
                return AbstractQueryCompare.this.queryTemplate.noFirstSqlSegment();
            }

            @Override
            public Object[] getArgs() {
                return (Object[])AbstractQueryCompare.this.queryParam.toArray().clone();
            }
        };
    }
}

