/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.query;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.jdbc.ResultSetExtractor;
import net.hasor.db.jdbc.RowCallbackHandler;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.lambda.QueryExecute;
import net.hasor.db.lambda.page.Page;
import net.hasor.db.lambda.page.PageObject;
import net.hasor.db.lambda.query.AbstractExecute;
import net.hasor.utils.function.ESupplier;

public abstract class AbstractQueryExecute<T>
extends AbstractExecute<T>
implements QueryExecute<T> {
    private final Page pageInfo = new PageObject(0, (ESupplier<Integer, SQLException>)((ESupplier)this::queryForCount));

    public AbstractQueryExecute(Class<T> exampleType, JdbcTemplate jdbcTemplate) {
        super(exampleType, jdbcTemplate);
    }

    AbstractQueryExecute(Class<T> exampleType, JdbcTemplate jdbcTemplate, String dbType, SqlDialect dialect) {
        super(exampleType, jdbcTemplate, dbType, dialect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BoundSql getBoundSql(SqlDialect dialect) {
        SqlDialect currentSqlDialect = this.dialect();
        try {
            this.setDialect(dialect);
            int pageSize = this.pageInfo.getPageSize();
            if (pageSize > 0) {
                int recordPosition = this.pageInfo.getFirstRecordPosition();
                BoundSql boundSql = dialect.pageSql(this.getOriginalBoundSql(), recordPosition, pageSize);
                return boundSql;
            }
            BoundSql boundSql = this.getOriginalBoundSql();
            return boundSql;
        }
        finally {
            if (currentSqlDialect != dialect) {
                this.setDialect(currentSqlDialect);
            }
        }
    }

    @Override
    public final BoundSql getBoundSql() {
        return this.getBoundSql(this.dialect());
    }

    protected abstract BoundSql getOriginalBoundSql();

    public Page pageInfo() {
        return this.pageInfo;
    }

    @Override
    public <V> QueryExecute<V> wrapperType(Class<V> wrapperType) {
        final AbstractQueryExecute self = this;
        return new AbstractQueryExecute<V>(wrapperType, this.getJdbcTemplate(), this.dbType, this.dialect()){

            @Override
            protected BoundSql getOriginalBoundSql() {
                return self.getOriginalBoundSql();
            }
        };
    }

    @Override
    public <V> V query(ResultSetExtractor<V> rse) throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().query(boundSql.getSqlString(), boundSql.getArgs(), rse);
    }

    @Override
    public void query(RowCallbackHandler rch) throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        this.getJdbcTemplate().query(boundSql.getSqlString(), boundSql.getArgs(), rch);
    }

    @Override
    public <V> List<V> query(RowMapper<V> rowMapper) throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().query(boundSql.getSqlString(), boundSql.getArgs(), rowMapper);
    }

    @Override
    public List<T> queryForList() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().query(boundSql.getSqlString(), boundSql.getArgs(), this.getRowMapper());
    }

    @Override
    public T queryForObject() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().queryForObject(boundSql.getSqlString(), boundSql.getArgs(), this.getRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().queryForMap(boundSql.getSqlString(), boundSql.getArgs());
    }

    @Override
    public List<Map<String, Object>> queryForMapList() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        return this.getJdbcTemplate().queryForList(boundSql.getSqlString(), boundSql.getArgs());
    }

    @Override
    public int queryForCount() throws SQLException {
        BoundSql countSql = this.dialect().countSql(this.getOriginalBoundSql());
        return this.getJdbcTemplate().queryForInt(countSql.getSqlString(), countSql.getArgs());
    }

    @Override
    public long queryForLargeCount() throws SQLException {
        BoundSql countSql = this.dialect().countSql(this.getOriginalBoundSql());
        return this.getJdbcTemplate().queryForLong(countSql.getSqlString(), countSql.getArgs());
    }
}

