/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.query;

import java.sql.SQLException;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.lambda.DeleteExecute;
import net.hasor.db.lambda.LambdaOperations;
import net.hasor.db.lambda.query.AbstractQueryCompare;
import net.hasor.db.lambda.segment.MergeSqlSegment;
import net.hasor.db.lambda.segment.Segment;
import net.hasor.db.lambda.segment.SqlKeyword;
import net.hasor.db.mapping.TableInfo;

public class LambdaDeleteWrapper<T>
extends AbstractQueryCompare<T, LambdaOperations.LambdaDelete<T>>
implements LambdaOperations.LambdaDelete<T> {
    private boolean allowEmptyWhere = false;

    public LambdaDeleteWrapper(Class<T> exampleType, JdbcTemplate jdbcTemplate) {
        super(exampleType, jdbcTemplate);
    }

    @Override
    protected LambdaOperations.LambdaDelete<T> getSelf() {
        return this;
    }

    @Override
    public LambdaOperations.LambdaDelete<T> useQualifier() {
        this.enableQualifier();
        return this;
    }

    @Override
    public DeleteExecute<T> allowEmptyWhere() {
        this.allowEmptyWhere = true;
        return this;
    }

    @Override
    public BoundSql getOriginalBoundSql() {
        this.queryParam.clear();
        String sqlQuery = this.rebuildSql();
        Object[] args = (Object[])this.queryParam.toArray().clone();
        return new BoundSql.BoundSqlObj(sqlQuery, args);
    }

    private String rebuildSql() {
        MergeSqlSegment sqlSegment = new MergeSqlSegment(new Segment[0]);
        sqlSegment.addSegment(SqlKeyword.DELETE);
        sqlSegment.addSegment(SqlKeyword.FROM);
        sqlSegment.addSegment(this.buildTabName(this.dialect()));
        if (!this.queryTemplate.isEmpty()) {
            sqlSegment.addSegment(SqlKeyword.WHERE);
            sqlSegment.addSegment(this.queryTemplate.sub(1));
        } else if (!this.allowEmptyWhere) {
            throw new UnsupportedOperationException("The dangerous DELETE operation, You must call `allowEmptyWhere()` to enable DELETE ALL.");
        }
        return sqlSegment.getSqlSegment();
    }

    private Segment buildTabName(SqlDialect dialect) {
        TableInfo tableInfo = super.getRowMapper().getTableInfo();
        if (tableInfo == null) {
            throw new IllegalArgumentException("tableInfo not found.");
        }
        return () -> dialect.tableName(this.isQualifier(), tableInfo.getCategory(), tableInfo.getTableName());
    }

    @Override
    public int doDelete() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        String sqlString = boundSql.getSqlString();
        return this.getJdbcTemplate().executeUpdate(sqlString, boundSql.getArgs());
    }
}

