/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.lambda.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.hasor.db.dialect.BatchBoundSql;
import net.hasor.db.dialect.BoundSql;
import net.hasor.db.dialect.InsertSqlDialect;
import net.hasor.db.dialect.SqlDialect;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.lambda.InsertExecute;
import net.hasor.db.lambda.LambdaOperations;
import net.hasor.db.lambda.query.AbstractExecute;
import net.hasor.db.lambda.query.LambdaQueryWrapper;
import net.hasor.db.lambda.segment.MergeSqlSegment;
import net.hasor.db.lambda.segment.Segment;
import net.hasor.db.lambda.segment.SqlKeyword;
import net.hasor.db.mapping.FieldInfo;
import net.hasor.db.mapping.MappingRowMapper;
import net.hasor.db.mapping.TableInfo;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.StringUtils;

public class LambdaInsertWrapper<T>
extends AbstractExecute<T>
implements LambdaOperations.LambdaInsert<T> {
    private final List<FieldInfo> insertFields = this.getInsertFields();
    private final List<FieldInfo> pkFields = this.getPkFields();
    private final List<Object[]> insertValues = new ArrayList<Object[]>();
    private InsertStrategy insertStrategy = InsertStrategy.Into;
    private LambdaOperations.LambdaQuery<?> insertAsQuery;

    public LambdaInsertWrapper(Class<T> exampleType, JdbcTemplate jdbcTemplate) {
        super(exampleType, jdbcTemplate);
    }

    @Override
    public LambdaOperations.LambdaInsert<T> useQualifier() {
        this.enableQualifier();
        return this;
    }

    protected List<FieldInfo> getPkFields() {
        ArrayList<FieldInfo> pkField = new ArrayList<FieldInfo>();
        MappingRowMapper rowMapper = this.getRowMapper();
        List<String> columnNames = rowMapper.getColumnNames();
        for (String columnName : columnNames) {
            FieldInfo field = rowMapper.findWriteFieldByColumn(columnName);
            if (!field.isPrimary()) continue;
            pkField.add(field);
        }
        return pkField;
    }

    protected List<FieldInfo> getInsertFields() {
        ArrayList<FieldInfo> toInsertField = new ArrayList<FieldInfo>();
        MappingRowMapper rowMapper = this.getRowMapper();
        List<String> columnNames = rowMapper.getColumnNames();
        for (String columnName : columnNames) {
            FieldInfo field = rowMapper.findWriteFieldByColumn(columnName);
            if (!field.isInsert()) continue;
            toInsertField.add(field);
        }
        if (toInsertField.size() == 0) {
            throw new IllegalStateException("no column require INSERT.");
        }
        return toInsertField;
    }

    @Override
    public InsertExecute<T> applyMap(List<Map<String, Object>> dataMapList) {
        if (this.insertAsQuery != null) {
            throw new IllegalStateException("there is existing INSERT ... SELECT, cannot be use data");
        }
        int fieldCount = this.insertFields.size();
        for (Map<String, Object> map : dataMapList) {
            Object[] args = new Object[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                FieldInfo info = this.insertFields.get(i);
                args[i] = map.get(info.getPropertyName());
            }
            this.insertValues.add(args);
        }
        return this;
    }

    @Override
    public InsertExecute<T> applyEntity(List<T> entityList) {
        int fieldCount = this.insertFields.size();
        for (T entity : entityList) {
            Object[] args = new Object[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                FieldInfo info = this.insertFields.get(i);
                args[i] = BeanUtils.readPropertyOrField(entity, (String)info.getPropertyName());
            }
            this.insertValues.add(args);
        }
        return this;
    }

    @Override
    public InsertExecute<T> onDuplicateKeyUpdate() {
        this.insertStrategy = InsertStrategy.Replace;
        return this;
    }

    @Override
    public InsertExecute<T> onDuplicateKeyIgnore() {
        this.insertStrategy = InsertStrategy.Ignore;
        return this;
    }

    @Override
    public InsertExecute<T> onDuplicateKeyBlock() {
        this.insertStrategy = InsertStrategy.Into;
        return this;
    }

    protected Segment getTableNameAndColumn(SqlDialect dialect) {
        MappingRowMapper rowMapper = this.getRowMapper();
        TableInfo tableInfo = rowMapper.getTableInfo();
        MergeSqlSegment tableNameAndColumn = new MergeSqlSegment(new Segment[0]);
        String tableName = dialect.tableName(this.isQualifier(), tableInfo.getCategory(), tableInfo.getTableName());
        tableNameAndColumn.addSegment(() -> tableName);
        tableNameAndColumn.addSegment(SqlKeyword.LEFT);
        List columnNames = this.insertFields.stream().map(FieldInfo::getColumnName).collect(Collectors.toList());
        for (int i = 0; i < columnNames.size(); ++i) {
            if (i != 0) {
                tableNameAndColumn.addSegment(() -> ",");
            }
            String columnName = (String)columnNames.get(i);
            FieldInfo field = rowMapper.findWriteFieldByColumn(columnName);
            String selectColumn = dialect.columnName(this.isQualifier(), tableInfo.getCategory(), tableInfo.getTableName(), field.getColumnName(), field.getJdbcType(), field.getJavaType());
            tableNameAndColumn.addSegment(() -> selectColumn);
        }
        tableNameAndColumn.addSegment(SqlKeyword.RIGHT);
        return tableNameAndColumn;
    }

    @Override
    public BoundSql getBoundSql() {
        return this.getBoundSql(this.dialect());
    }

    @Override
    public BoundSql getBoundSql(SqlDialect dialect) {
        if (this.insertAsQuery != null) {
            MergeSqlSegment insertTemplate = new MergeSqlSegment(new Segment[0]);
            insertTemplate.addSegment(SqlKeyword.INSERT, SqlKeyword.INTO);
            insertTemplate.addSegment(this.getTableNameAndColumn(dialect));
            Segment[] segmentArray = new Segment[1];
            segmentArray[0] = dialect::selectAsInsertConcatStr;
            insertTemplate.addSegment(segmentArray);
            if (this.isQualifier()) {
                this.insertAsQuery.useQualifier();
            }
            BoundSql boundSql = this.insertAsQuery.getBoundSql(dialect);
            String sqlString = boundSql.getSqlString();
            insertTemplate.addSegment(() -> sqlString);
            return new BoundSql.BoundSqlObj(insertTemplate.getSqlSegment(), boundSql.getArgs());
        }
        if (this.insertValues.size() == 0) {
            throw new IllegalStateException("there is no data to insert");
        }
        boolean isInsertSqlDialect = dialect instanceof InsertSqlDialect;
        if (isInsertSqlDialect) {
            return this.dialectInsert((InsertSqlDialect)dialect);
        }
        return this.standardInsert(dialect);
    }

    @Override
    public <V> InsertExecute<T> applyQueryAsInsert(LambdaOperations.LambdaQuery<V> lambdaQuery) {
        if (!this.insertValues.isEmpty()) {
            throw new IllegalStateException("there is existing insert data, cannot be use INSERT ... SELECT");
        }
        this.insertAsQuery = lambdaQuery;
        return this;
    }

    @Override
    public <V> InsertExecute<T> applyQueryAsInsert(Class<V> exampleType, Consumer<LambdaOperations.LambdaQuery<V>> queryBuilderConsumer) {
        if (queryBuilderConsumer != null) {
            LambdaQueryWrapper<V> queryWrapper = new LambdaQueryWrapper<V>(exampleType, this.getJdbcTemplate());
            queryBuilderConsumer.accept(queryWrapper);
            return this.applyQueryAsInsert(queryWrapper);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeGetResult() throws SQLException {
        try {
            BoundSql boundSql = this.getBoundSql();
            String sqlString = boundSql.getSqlString();
            if (boundSql instanceof BatchBoundSql) {
                if (boundSql.getArgs().length > 1) {
                    int[] nArray = this.getJdbcTemplate().executeBatch(sqlString, ((BatchBoundSql)boundSql).getArgs());
                    return nArray;
                }
                int i = this.getJdbcTemplate().executeUpdate(sqlString, (Object[])boundSql.getArgs()[0]);
                int[] nArray = new int[]{i};
                return nArray;
            }
            int i = this.getJdbcTemplate().executeUpdate(sqlString, boundSql.getArgs());
            int[] nArray = new int[]{i};
            return nArray;
        }
        finally {
            this.insertValues.clear();
            this.insertAsQuery = null;
        }
    }

    protected BoundSql standardInsert(SqlDialect dialect) {
        MergeSqlSegment insertTemplate = new MergeSqlSegment(new Segment[0]);
        insertTemplate.addSegment(SqlKeyword.INSERT, SqlKeyword.INTO);
        insertTemplate.addSegment(this.getTableNameAndColumn(dialect));
        insertTemplate.addSegment(SqlKeyword.VALUES, SqlKeyword.LEFT);
        insertTemplate.addSegment(() -> StringUtils.repeat((String)",?", (int)this.insertFields.size()).substring(1));
        insertTemplate.addSegment(SqlKeyword.RIGHT);
        String sqlString = insertTemplate.getSqlSegment();
        Object[][] args = new Object[this.insertValues.size()][];
        for (int i = 0; i < this.insertValues.size(); ++i) {
            args[i] = this.insertValues.get(i);
        }
        return new BatchBoundSql.BatchBoundSqlObj(sqlString, args);
    }

    protected BoundSql dialectInsert(InsertSqlDialect dialect) {
        MappingRowMapper rowMapper = this.getRowMapper();
        String category = rowMapper.getCategory();
        String tableName = rowMapper.getTableName();
        switch (this.insertStrategy) {
            case Ignore: {
                if (!dialect.supportInsertIgnore(this.pkFields)) break;
                String sqlString = dialect.insertWithIgnore(this.isQualifier(), category, tableName, this.pkFields, this.insertFields);
                return this.buildBatchBoundSql(sqlString);
            }
            case Replace: {
                if (!dialect.supportInsertReplace(this.pkFields)) break;
                String sqlString = dialect.insertWithReplace(this.isQualifier(), category, tableName, this.pkFields, this.insertFields);
                return this.buildBatchBoundSql(sqlString);
            }
        }
        return this.standardInsert(dialect);
    }

    protected BatchBoundSql buildBatchBoundSql(String batchSql) {
        Object[][] args = new Object[this.insertValues.size()][];
        for (int i = 0; i < this.insertValues.size(); ++i) {
            args[i] = this.insertValues.get(i);
        }
        return new BatchBoundSql.BatchBoundSqlObj(batchSql, args);
    }

    protected static enum InsertStrategy {
        Ignore,
        Replace,
        Into;

    }
}

