/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.mapping;

import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.mapping.Field;
import net.hasor.db.mapping.FieldImpl;
import net.hasor.db.mapping.FieldInfo;
import net.hasor.db.mapping.FieldInfoImpl;
import net.hasor.db.mapping.MappingHandler;
import net.hasor.db.mapping.Table;
import net.hasor.db.mapping.TableImpl;
import net.hasor.db.mapping.TableInfo;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.TypeHandlerRegistry;
import net.hasor.db.types.UnknownTypeHandler;
import net.hasor.utils.BeanUtils;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.convert.ConverterUtils;
import net.hasor.utils.ref.LinkedCaseInsensitiveMap;

public class MappingRowMapper<T>
implements RowMapper<T>,
TableInfo {
    private final Class<T> mapperClass;
    private String category;
    private String tableName;
    private boolean useQualifier;
    private boolean caseInsensitive;
    private final List<String> propertyNames;
    private final Map<String, String> propertyColumnMapping;
    private final Map<String, FieldInfo> propertyFieldInfoMap;
    private final Map<String, TypeHandler<?>> propertyTypeHandlerMap;
    private final List<String> columnNames;
    private final Map<String, List<String>> columnPropertyMapping;
    private final Map<String, String> columnPropertyMappingForWrite;

    public MappingRowMapper(Class<T> mapperClass) {
        this(mapperClass, TypeHandlerRegistry.DEFAULT);
    }

    public MappingRowMapper(Class<T> mapperClass, TypeHandlerRegistry handlerRegistry) {
        this.mapperClass = mapperClass;
        this.caseInsensitive = true;
        this.propertyNames = new ArrayList<String>();
        this.propertyColumnMapping = new HashMap<String, String>();
        this.propertyFieldInfoMap = new HashMap<String, FieldInfo>();
        this.propertyTypeHandlerMap = new HashMap();
        this.columnPropertyMappingForWrite = new HashMap<String, String>();
        this.columnNames = new ArrayList<String>();
        this.columnPropertyMapping = new HashMap<String, List<String>>();
        this.initialize(mapperClass, Objects.requireNonNull(handlerRegistry, "handlerRegistry is null."));
    }

    private void initialize(Class<T> mapperClass, TypeHandlerRegistry registry) {
        Table defTable = null;
        defTable = mapperClass.isAnnotationPresent(Table.class) ? mapperClass.getAnnotation(Table.class) : new TableImpl("", mapperClass.getSimpleName());
        this.category = defTable.category().trim();
        this.tableName = StringUtils.isNotBlank((String)defTable.name()) ? defTable.name() : defTable.value();
        this.useQualifier = defTable.useQualifier();
        boolean autoConfigField = defTable.autoFiled();
        List allFields = BeanUtils.findALLFields(mapperClass);
        for (java.lang.reflect.Field field : allFields) {
            Field defField = this.defField(field, autoConfigField);
            if (defField == null) continue;
            TypeHandler<?> typeHandler = null;
            if (defField.typeHandler() == UnknownTypeHandler.class) {
                typeHandler = registry.getTypeHandler(field.getType(), defField.jdbcType());
            } else {
                try {
                    typeHandler = defField.typeHandler().newInstance();
                }
                catch (Exception e) {
                    throw ExceptionUtils.toRuntimeException((Throwable)e);
                }
            }
            this.setupField(field, defField, typeHandler);
        }
    }

    protected Field defField(java.lang.reflect.Field dtoField, boolean autoConfigField) {
        if (dtoField.isAnnotationPresent(Field.class)) {
            return dtoField.getAnnotation(Field.class);
        }
        if (autoConfigField) {
            Class<?> fieldType = dtoField.getType();
            JDBCType jdbcType = TypeHandlerRegistry.toSqlType(fieldType);
            return new FieldImpl(dtoField.getName(), jdbcType);
        }
        return null;
    }

    private void setupField(java.lang.reflect.Field property, Field defField, TypeHandler<?> toTypeHandler) {
        String propertyName = property.getName();
        String columnName = null;
        JDBCType jdbcType = defField.jdbcType();
        columnName = StringUtils.isNotBlank((String)defField.name()) ? defField.name() : defField.value();
        if (StringUtils.isBlank((String)columnName)) {
            columnName = propertyName;
        }
        if (jdbcType == JDBCType.OTHER) {
            jdbcType = TypeHandlerRegistry.toSqlType(property.getType());
        }
        String useColumnName = columnName;
        FieldInfoImpl fieldInfo = new FieldInfoImpl(useColumnName, propertyName, jdbcType, property.getType(), defField.insert(), defField.update(), false);
        this.propertyNames.add(propertyName);
        this.propertyColumnMapping.put(propertyName, useColumnName);
        this.propertyFieldInfoMap.put(propertyName, fieldInfo);
        this.propertyTypeHandlerMap.put(propertyName, toTypeHandler);
        if (!this.columnNames.contains(useColumnName)) {
            this.columnNames.add(useColumnName);
        }
        List stringList = this.columnPropertyMapping.computeIfAbsent(useColumnName, k -> new ArrayList());
        stringList.add(propertyName);
        if (fieldInfo.isInsert() || fieldInfo.isUpdate()) {
            if (this.columnPropertyMappingForWrite.containsKey(useColumnName)) {
                String differentProperty = "'" + propertyName + "','" + this.columnPropertyMappingForWrite.get(useColumnName) + "'";
                throw new IllegalStateException("mapping different property " + differentProperty + " write the same column '" + useColumnName + "'.");
            }
            this.columnPropertyMappingForWrite.put(useColumnName, propertyName);
        }
    }

    public Class<T> getMapperClass() {
        return this.mapperClass;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public TableInfo getTableInfo() {
        return this;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<String> getPropertyNames() {
        return this.propertyNames;
    }

    public FieldInfo findFieldByProperty(String propertyName) {
        return this.propertyFieldInfoMap.get(propertyName);
    }

    public List<FieldInfo> findFieldByColumn(String columnName) {
        List<String> propertyNames = this.columnPropertyMapping.get(columnName);
        if (propertyNames == null) {
            return null;
        }
        return propertyNames.stream().map(this.propertyFieldInfoMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public FieldInfo findWriteFieldByColumn(String columnName) {
        String propertyName = this.columnPropertyMappingForWrite.get(columnName);
        return this.propertyFieldInfoMap.get(propertyName);
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        try {
            T targetObject = this.mapperClass.newInstance();
            return this.tranResultSet(rs, targetObject);
        }
        catch (ReflectiveOperationException e) {
            throw new SQLException(e);
        }
    }

    private T tranResultSet(ResultSet rs, T targetObject) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        Object resultColumnMap = this.caseInsensitive ? new LinkedCaseInsensitiveMap() : new LinkedHashMap();
        for (int i = 1; i <= nrOfColumns; ++i) {
            String colName = rsmd.getColumnName(i);
            if (resultColumnMap.containsKey(colName)) continue;
            resultColumnMap.put(colName, i);
        }
        for (String columnName : this.columnNames) {
            if (!resultColumnMap.containsKey(columnName)) continue;
            int realIndex = (Integer)resultColumnMap.get(columnName);
            List<String> propertyNames = this.columnPropertyMapping.get(columnName);
            for (String propertyName : propertyNames) {
                TypeHandler<?> realHandler = this.propertyTypeHandlerMap.get(propertyName);
                Object result = realHandler.getResult(rs, realIndex);
                Class propertyType = BeanUtils.getPropertyOrFieldType(this.mapperClass, (String)propertyName);
                Object convert = ConverterUtils.convert((Class)propertyType, result);
                BeanUtils.writePropertyOrField(targetObject, (String)propertyName, (Object)convert);
            }
        }
        return targetObject;
    }

    public static <T> MappingRowMapper<T> newInstance(Class<T> mappedClass) {
        return MappingHandler.DEFAULT.resolveMapper(mappedClass);
    }

    public static <T> MappingRowMapper<T> newInstance(Class<T> mappedClass, TypeHandlerRegistry registry) {
        return new MappingHandler(registry).resolveMapper(mappedClass);
    }
}

