/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.metadata;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.sql.DataSource;
import net.hasor.db.metadata.CloseIsNothingInvocationHandler;
import net.hasor.utils.ExceptionUtils;

public class AbstractMetadataSupplier {
    protected final Supplier<Connection> connectSupplier;

    public AbstractMetadataSupplier(Connection connection) {
        Connection conn = AbstractMetadataSupplier.newProxyConnection(connection);
        this.connectSupplier = () -> conn;
    }

    public AbstractMetadataSupplier(DataSource dataSource) {
        this.connectSupplier = () -> {
            try {
                return dataSource.getConnection();
            }
            catch (SQLException e) {
                throw ExceptionUtils.toRuntimeException((Throwable)e);
            }
        };
    }

    protected static Connection newProxyConnection(Connection connection) {
        CloseIsNothingInvocationHandler handler = new CloseIsNothingInvocationHandler(connection);
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class, Closeable.class}, (InvocationHandler)handler);
    }
}

