/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.metadata;

import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.metadata.AbstractMetadataSupplier;
import net.hasor.db.metadata.SqlUtils;
import net.hasor.db.metadata.mysql.MySqlColumn;
import net.hasor.db.metadata.mysql.MySqlConstraint;
import net.hasor.db.metadata.mysql.MySqlConstraintType;
import net.hasor.db.metadata.mysql.MySqlForeignKey;
import net.hasor.db.metadata.mysql.MySqlForeignKeyRule;
import net.hasor.db.metadata.mysql.MySqlIndex;
import net.hasor.db.metadata.mysql.MySqlIndexType;
import net.hasor.db.metadata.mysql.MySqlPrimaryKey;
import net.hasor.db.metadata.mysql.MySqlSchema;
import net.hasor.db.metadata.mysql.MySqlTable;
import net.hasor.db.metadata.mysql.MySqlTableType;
import net.hasor.db.metadata.mysql.MySqlUniqueKey;
import net.hasor.db.metadata.mysql.MySqlVariable;
import net.hasor.db.metadata.mysql.MySqlVariableScope;
import net.hasor.db.metadata.mysql.driver.MysqlType;
import net.hasor.utils.StringUtils;

public class MySqlMetadataSupplier
extends AbstractMetadataSupplier {
    public MySqlMetadataSupplier(Connection connection) {
        super(connection);
    }

    public MySqlMetadataSupplier(DataSource dataSource) {
        super(dataSource);
    }

    public List<MySqlVariable> getVariables(MySqlVariableScope scope) throws SQLException {
        String queryString = null;
        switch (scope) {
            case Global: {
                queryString = "show global variables";
                break;
            }
            case Session: {
                queryString = "show session variables";
                break;
            }
            case Default: {
                queryString = "show variables";
                break;
            }
            default: {
                throw new IllegalArgumentException("arg scope error.");
            }
        }
        try (Connection conn = (Connection)this.connectSupplier.get();){
            List<Map<String, Object>> mapList = new JdbcTemplate(conn).queryForList(queryString);
            if (mapList == null) {
                List<MySqlVariable> list = Collections.emptyList();
                return list;
            }
            List<MySqlVariable> list = mapList.stream().map(mysqlVar -> {
                MySqlVariable variable = new MySqlVariable();
                variable.setName(SqlUtils.safeToString(mysqlVar.get("Variable_name")));
                variable.setValue(SqlUtils.safeToString(mysqlVar.get("Value")));
                variable.setScope(scope);
                return variable;
            }).collect(Collectors.toList());
            return list;
        }
    }

    public MySqlVariable getVariable(MySqlVariableScope scope, String varName) throws SQLException {
        if (StringUtils.isBlank((String)varName)) {
            return null;
        }
        varName = "%" + varName + "%";
        String queryString = null;
        switch (scope) {
            case Global: {
                queryString = "show global variables like ?";
                break;
            }
            case Session: {
                queryString = "show session variables like ?";
                break;
            }
            case Default: {
                queryString = "show variables like ?";
                break;
            }
            default: {
                throw new IllegalArgumentException("arg scope error.");
            }
        }
        try (Connection conn = (Connection)this.connectSupplier.get();){
            List<Map<String, Object>> mapList = new JdbcTemplate(conn).queryForList(queryString, varName);
            if (mapList == null) {
                MySqlVariable mySqlVariable = null;
                return mySqlVariable;
            }
            MySqlVariable mySqlVariable = mapList.stream().map(mysqlVar -> {
                MySqlVariable variable = new MySqlVariable();
                variable.setName(SqlUtils.safeToString(mysqlVar.get("Variable_name")));
                variable.setValue(SqlUtils.safeToString(mysqlVar.get("Value")));
                variable.setScope(scope);
                return variable;
            }).findFirst().orElse(null);
            return mySqlVariable;
        }
    }

    public List<MySqlSchema> getSchemas() throws SQLException {
        String queryString = "select SCHEMA_NAME,DEFAULT_CHARACTER_SET_NAME,DEFAULT_COLLATION_NAME from INFORMATION_SCHEMA.SCHEMATA";
        try (Connection conn = (Connection)this.connectSupplier.get();){
            List<Map<String, Object>> mapList = new JdbcTemplate(conn).queryForList(queryString);
            if (mapList == null) {
                List<MySqlSchema> list = Collections.emptyList();
                return list;
            }
            List<MySqlSchema> list = mapList.stream().map(mysqlSchema -> {
                MySqlSchema schema = new MySqlSchema();
                schema.setName(SqlUtils.safeToString(mysqlSchema.get("SCHEMA_NAME")));
                schema.setDefaultCharacterSetName(SqlUtils.safeToString(mysqlSchema.get("DEFAULT_CHARACTER_SET_NAME")));
                schema.setDefaultCollationName(SqlUtils.safeToString(mysqlSchema.get("DEFAULT_COLLATION_NAME")));
                return schema;
            }).collect(Collectors.toList());
            return list;
        }
    }

    public MySqlSchema getSchema(String schemaName) throws SQLException {
        if (StringUtils.isBlank((String)schemaName)) {
            return null;
        }
        try (Connection conn = (Connection)this.connectSupplier.get();){
            String queryString = "select SCHEMA_NAME,DEFAULT_CHARACTER_SET_NAME,DEFAULT_COLLATION_NAME from INFORMATION_SCHEMA.SCHEMATA where SCHEMA_NAME = ?";
            List<Map<String, Object>> mapList = new JdbcTemplate(conn).queryForList(queryString, schemaName);
            if (mapList == null) {
                MySqlSchema mySqlSchema = null;
                return mySqlSchema;
            }
            MySqlSchema mySqlSchema = mapList.stream().map(mysqlSchema -> {
                MySqlSchema schema = new MySqlSchema();
                schema.setName(SqlUtils.safeToString(mysqlSchema.get("SCHEMA_NAME")));
                schema.setDefaultCharacterSetName(SqlUtils.safeToString(mysqlSchema.get("DEFAULT_CHARACTER_SET_NAME")));
                schema.setDefaultCollationName(SqlUtils.safeToString(mysqlSchema.get("DEFAULT_COLLATION_NAME")));
                return schema;
            }).findFirst().orElse(null);
            return mySqlSchema;
        }
    }

    public Map<String, List<MySqlTable>> getTables(String ... schemaName) throws SQLException {
        schemaName = schemaName == null ? new String[]{} : schemaName;
        ArrayList<String> schemaList = new ArrayList<String>();
        for (String schema : schemaName) {
            if (!StringUtils.isNotBlank((String)schema)) continue;
            schemaList.add(schema);
        }
        if (schemaList.isEmpty()) {
            return Collections.emptyMap();
        }
        if (schemaList.size() > 1000) {
            throw new IndexOutOfBoundsException("Batch query schema Batch size out of 1000");
        }
        String queryString = "select TABLE_SCHEMA,TABLE_NAME,TABLE_TYPE,TABLE_COLLATION,CREATE_TIME,UPDATE_TIME from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA in " + SqlUtils.buildWhereIn(schemaList);
        try (Connection conn = (Connection)this.connectSupplier.get();){
            List<Map<String, Object>> mapList = new JdbcTemplate(conn).queryForList(queryString, schemaList.toArray());
            if (mapList == null) {
                Map<String, List<MySqlTable>> map = Collections.emptyMap();
                return map;
            }
            HashMap<String, List<MySqlTable>> resultData = new HashMap<String, List<MySqlTable>>();
            mapList.forEach(mysqlTable -> {
                String dbName = SqlUtils.safeToString(mysqlTable.get("TABLE_SCHEMA"));
                List tableList = resultData.computeIfAbsent(dbName, k -> new ArrayList());
                MySqlTable table = new MySqlTable();
                table.setTableName(SqlUtils.safeToString(mysqlTable.get("TABLE_NAME")));
                table.setTableType(MySqlTableType.valueOfCode(SqlUtils.safeToString(mysqlTable.get("TABLE_TYPE"))));
                table.setCollation(SqlUtils.safeToString(mysqlTable.get("TABLE_COLLATION")));
                table.setCreateTime(SqlUtils.safeToDate(mysqlTable.get("CREATE_TIME")));
                table.setUpdateTime(SqlUtils.safeToDate(mysqlTable.get("UPDATE_TIME")));
                tableList.add(table);
            });
            HashMap<String, List<MySqlTable>> hashMap = resultData;
            return hashMap;
        }
    }

    public Map<String, List<MySqlTable>> findTables(String schemaName, String ... tableName) throws SQLException {
        if (StringUtils.isBlank((String)schemaName)) {
            return Collections.emptyMap();
        }
        tableName = tableName == null ? new String[]{} : tableName;
        ArrayList<String> tableNameList = new ArrayList<String>();
        for (String table : tableName) {
            if (!StringUtils.isNotBlank((String)table)) continue;
            tableNameList.add(table);
        }
        if (tableNameList.isEmpty()) {
            return Collections.emptyMap();
        }
        if (tableNameList.size() > 1000) {
            throw new IndexOutOfBoundsException("Batch query table Batch size out of 1000");
        }
        String queryString = "select TABLE_SCHEMA,TABLE_NAME,TABLE_TYPE,TABLE_COLLATION,CREATE_TIME,UPDATE_TIME from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = ? and TABLE_NAME in " + SqlUtils.buildWhereIn(tableNameList);
        tableNameList.add(0, schemaName);
        try (Connection conn = (Connection)this.connectSupplier.get();){
            List<Map<String, Object>> mapList = new JdbcTemplate(conn).queryForList(queryString, tableNameList.toArray());
            if (mapList == null) {
                Map<String, List<MySqlTable>> map = Collections.emptyMap();
                return map;
            }
            HashMap<String, List<MySqlTable>> resultData = new HashMap<String, List<MySqlTable>>();
            mapList.forEach(mysqlTable -> {
                String dbName = SqlUtils.safeToString(mysqlTable.get("TABLE_SCHEMA"));
                List tableList = resultData.computeIfAbsent(dbName, k -> new ArrayList());
                MySqlTable table = new MySqlTable();
                table.setTableName(SqlUtils.safeToString(mysqlTable.get("TABLE_NAME")));
                table.setTableType(MySqlTableType.valueOfCode(SqlUtils.safeToString(mysqlTable.get("TABLE_TYPE"))));
                table.setCollation(SqlUtils.safeToString(mysqlTable.get("TABLE_COLLATION")));
                table.setCreateTime(SqlUtils.safeToDate(mysqlTable.get("CREATE_TIME")));
                table.setUpdateTime(SqlUtils.safeToDate(mysqlTable.get("UPDATE_TIME")));
                tableList.add(table);
            });
            HashMap<String, List<MySqlTable>> hashMap = resultData;
            return hashMap;
        }
    }

    public MySqlTable getTable(String schemaName, String tableName) throws SQLException {
        if (StringUtils.isBlank((String)schemaName) || StringUtils.isBlank((String)tableName)) {
            return null;
        }
        String queryString = "select TABLE_SCHEMA,TABLE_NAME,TABLE_TYPE,TABLE_COLLATION,CREATE_TIME,UPDATE_TIME from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = ? and TABLE_NAME = ?";
        try (Connection conn = (Connection)this.connectSupplier.get();){
            List<Map<String, Object>> mapList = new JdbcTemplate(conn).queryForList(queryString, schemaName, tableName);
            if (mapList == null) {
                MySqlTable mySqlTable = null;
                return mySqlTable;
            }
            MySqlTable mySqlTable = mapList.stream().map(mysqlTable -> {
                MySqlTable table = new MySqlTable();
                table.setTableName(SqlUtils.safeToString(mysqlTable.get("TABLE_NAME")));
                table.setTableType(MySqlTableType.valueOfCode(SqlUtils.safeToString(mysqlTable.get("TABLE_TYPE"))));
                table.setCollation(SqlUtils.safeToString(mysqlTable.get("TABLE_COLLATION")));
                table.setCreateTime(SqlUtils.safeToDate(mysqlTable.get("CREATE_TIME")));
                table.setUpdateTime(SqlUtils.safeToDate(mysqlTable.get("UPDATE_TIME")));
                return table;
            }).findFirst().orElse(null);
            return mySqlTable;
        }
    }

    public List<MySqlColumn> getColumns(String schemaName, String tableName) throws SQLException {
        if (StringUtils.isBlank((String)schemaName) || StringUtils.isBlank((String)tableName)) {
            return Collections.emptyList();
        }
        String queryString = "select TABLE_SCHEMA,TABLE_NAME,COLUMN_NAME,IS_NULLABLE,DATA_TYPE,CHARACTER_MAXIMUM_LENGTH,CHARACTER_OCTET_LENGTH,NUMERIC_SCALE,NUMERIC_PRECISION,DATETIME_PRECISION,CHARACTER_SET_NAME,COLLATION_NAME,COLUMN_TYPE from INFORMATION_SCHEMA.COLUMNS where TABLE_SCHEMA = ? and TABLE_NAME = ?";
        try (Connection conn = (Connection)this.connectSupplier.get();){
            List<Map<String, Object>> mapList = new JdbcTemplate(conn).queryForList(queryString, schemaName, tableName);
            if (mapList == null) {
                List<MySqlColumn> list = Collections.emptyList();
                return list;
            }
            List<MySqlColumn> list = mapList.stream().map(mysqlVar -> {
                MySqlColumn column = new MySqlColumn();
                column.setName(SqlUtils.safeToString(mysqlVar.get("COLUMN_NAME")));
                column.setNullable(SqlUtils.safeToBoolean(mysqlVar.get("IS_NULLABLE")));
                column.setDataType(SqlUtils.safeToString(mysqlVar.get("DATA_TYPE")));
                column.setColumnType(SqlUtils.safeToString(mysqlVar.get("COLUMN_TYPE")));
                column.setSqlType(SqlUtils.safeToMySqlTypes(mysqlVar.get("DATA_TYPE")));
                column.setJdbcType(MySqlMetadataSupplier.columnTypeMappingToJdbcType(column.getColumnType()));
                column.setDefaultCollationName(SqlUtils.safeToString(mysqlVar.get("COLLATION_NAME")));
                column.setDefaultCharacterSetName(SqlUtils.safeToString(mysqlVar.get("CHARACTER_SET_NAME")));
                column.setCharactersMaxLength(SqlUtils.safeToLong(mysqlVar.get("CHARACTER_MAXIMUM_LENGTH")));
                column.setBytesMaxLength(SqlUtils.safeToInteger(mysqlVar.get("CHARACTER_OCTET_LENGTH")));
                column.setDatetimePrecision(SqlUtils.safeToInteger(mysqlVar.get("DATETIME_PRECISION")));
                column.setNumericPrecision(SqlUtils.safeToInteger(mysqlVar.get("NUMERIC_PRECISION")));
                column.setNumericScale(SqlUtils.safeToInteger(mysqlVar.get("NUMERIC_SCALE")));
                return column;
            }).collect(Collectors.toList());
            return list;
        }
    }

    public List<MySqlConstraint> getConstraint(String schemaName, String tableName) throws SQLException {
        if (StringUtils.isBlank((String)schemaName) || StringUtils.isBlank((String)tableName)) {
            return Collections.emptyList();
        }
        String queryString = "select CONSTRAINT_SCHEMA,CONSTRAINT_NAME,TABLE_SCHEMA,TABLE_NAME,CONSTRAINT_TYPE from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where TABLE_SCHEMA = ? and TABLE_NAME = ?";
        try (Connection conn = (Connection)this.connectSupplier.get();){
            List<Map<String, Object>> mapList = new JdbcTemplate(conn).queryForList(queryString, schemaName, tableName);
            if (mapList == null) {
                List<MySqlConstraint> list = Collections.emptyList();
                return list;
            }
            List<MySqlConstraint> list = mapList.stream().map(entry -> {
                String constraintSchema = SqlUtils.safeToString(entry.get("CONSTRAINT_SCHEMA"));
                String constraintName = SqlUtils.safeToString(entry.get("CONSTRAINT_NAME"));
                String constraintTypeString = SqlUtils.safeToString(entry.get("CONSTRAINT_TYPE"));
                MySqlConstraint constraint = new MySqlConstraint();
                constraint.setSchema(constraintSchema);
                constraint.setName(constraintName);
                constraint.setConstraintType(MySqlConstraintType.valueOfCode(constraintTypeString));
                return constraint;
            }).collect(Collectors.toList());
            return list;
        }
    }

    public List<MySqlConstraint> getConstraint(String schemaName, String tableName, MySqlConstraintType ... cType) throws SQLException {
        List<MySqlConstraint> constraintList = this.getConstraint(schemaName, tableName);
        if (constraintList == null || constraintList.isEmpty()) {
            return constraintList;
        }
        return constraintList.stream().filter(mySqlConstraint -> {
            for (MySqlConstraintType constraintType : cType) {
                if (constraintType != mySqlConstraint.getConstraintType()) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public MySqlPrimaryKey getPrimaryKey(String schemaName, String tableName) throws SQLException {
        if (StringUtils.isBlank((String)schemaName) || StringUtils.isBlank((String)tableName)) {
            return null;
        }
        List<MySqlConstraint> constraintList = this.getConstraint(schemaName, tableName, MySqlConstraintType.PrimaryKey);
        if (constraintList == null || constraintList.isEmpty()) {
            return null;
        }
        MySqlConstraint constraintPrimaryKey = constraintList.get(0);
        String pkConstraintName = constraintPrimaryKey.getName();
        String queryString = "select COLUMN_NAME,INDEX_TYPE FROM INFORMATION_SCHEMA.STATISTICS where TABLE_SCHEMA = ? and TABLE_NAME = ? and INDEX_NAME = ? order by SEQ_IN_INDEX asc";
        try (Connection conn = (Connection)this.connectSupplier.get();){
            List<Map<String, Object>> mapList = new JdbcTemplate(conn).queryForList(queryString, schemaName, tableName, pkConstraintName);
            if (mapList == null) {
                MySqlPrimaryKey mySqlPrimaryKey = null;
                return mySqlPrimaryKey;
            }
            MySqlPrimaryKey primaryKey = new MySqlPrimaryKey();
            primaryKey.setName("PRIMARY");
            primaryKey.setConstraintType(MySqlConstraintType.PrimaryKey);
            for (Map<String, Object> ent : mapList) {
                String cName = SqlUtils.safeToString(ent.get("COLUMN_NAME"));
                String cType = SqlUtils.safeToString(ent.get("INDEX_TYPE"));
                primaryKey.getColumns().add(cName);
                primaryKey.getStorageType().put(cName, cType);
            }
            MySqlPrimaryKey mySqlPrimaryKey = primaryKey;
            return mySqlPrimaryKey;
        }
    }

    public List<MySqlUniqueKey> getUniqueKey(String schemaName, String tableName) throws SQLException {
        if (StringUtils.isBlank((String)schemaName) || StringUtils.isBlank((String)tableName)) {
            return Collections.emptyList();
        }
        List<MySqlConstraint> constraintList = this.getConstraint(schemaName, tableName, MySqlConstraintType.Unique);
        if (constraintList == null || constraintList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> queryParam = new ArrayList<String>();
        queryParam.add(schemaName);
        queryParam.add(tableName);
        queryParam.addAll(constraintList.stream().map(MySqlConstraint::getName).collect(Collectors.toList()));
        String queryString = "select INDEX_NAME,COLUMN_NAME,INDEX_TYPE FROM INFORMATION_SCHEMA.STATISTICS where TABLE_SCHEMA = ? and TABLE_NAME = ? and INDEX_NAME in " + SqlUtils.buildWhereIn(constraintList) + " order by SEQ_IN_INDEX asc";
        try (Connection conn = (Connection)this.connectSupplier.get();){
            List<Map<String, Object>> mapList = new JdbcTemplate(conn).queryForList(queryString, queryParam.toArray());
            if (mapList == null) {
                List<MySqlUniqueKey> list = Collections.emptyList();
                return list;
            }
            LinkedHashMap<String, MySqlUniqueKey> groupByName = new LinkedHashMap<String, MySqlUniqueKey>();
            for (Map<String, Object> indexColumn : mapList) {
                String indexName = SqlUtils.safeToString(indexColumn.get("INDEX_NAME"));
                String indexType = SqlUtils.safeToString(indexColumn.get("INDEX_TYPE"));
                MySqlUniqueKey uniqueKey = groupByName.computeIfAbsent(indexName, k -> {
                    MySqlUniqueKey sqlUniqueKey = new MySqlUniqueKey();
                    sqlUniqueKey.setName((String)k);
                    sqlUniqueKey.setConstraintType(MySqlConstraintType.Unique);
                    return sqlUniqueKey;
                });
                String columnName = SqlUtils.safeToString(indexColumn.get("COLUMN_NAME"));
                uniqueKey.getColumns().add(columnName);
                uniqueKey.getStorageType().put(columnName, indexType);
            }
            ArrayList arrayList = new ArrayList(groupByName.values());
            return arrayList;
        }
    }

    public List<MySqlForeignKey> getForeignKey(String schemaName, String tableName) throws SQLException {
        if (StringUtils.isBlank((String)schemaName) || StringUtils.isBlank((String)tableName)) {
            return Collections.emptyList();
        }
        List<MySqlConstraint> constraintList = this.getConstraint(schemaName, tableName, MySqlConstraintType.ForeignKey);
        if (constraintList == null || constraintList.isEmpty()) {
            return Collections.emptyList();
        }
        Set constraintSchemaList = constraintList.stream().map(MySqlConstraint::getSchema).collect(Collectors.toCollection(HashSet::new));
        String constraintSchemaWhereIn = SqlUtils.buildWhereIn(constraintSchemaList);
        Set constraintNameList = constraintList.stream().map(MySqlConstraint::getName).collect(Collectors.toCollection(HashSet::new));
        String constraintNameWhereIn = SqlUtils.buildWhereIn(constraintNameList);
        String queryFkAttrs = "select CONSTRAINT_SCHEMA,CONSTRAINT_NAME,TABLE_NAME,UPDATE_RULE,DELETE_RULE,REFERENCED_TABLE_NAME from INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS where CONSTRAINT_SCHEMA in " + constraintSchemaWhereIn + " and CONSTRAINT_NAME in " + constraintNameWhereIn + " and TABLE_NAME = ?";
        ArrayList<String> queryAttrsParam = new ArrayList<String>();
        queryAttrsParam.addAll(constraintSchemaList);
        queryAttrsParam.addAll(constraintNameList);
        queryAttrsParam.add(tableName);
        try (Connection conn = (Connection)this.connectSupplier.get();){
            LinkedHashMap<String, MySqlForeignKey> fkMap = new LinkedHashMap<String, MySqlForeignKey>();
            List<Map<String, Object>> fkAttrsMapList = new JdbcTemplate(conn).queryForList(queryFkAttrs, queryAttrsParam.toArray());
            if (fkAttrsMapList == null || fkAttrsMapList.isEmpty()) {
                List<MySqlForeignKey> list = Collections.emptyList();
                return list;
            }
            for (Map<String, Object> fkAttr : fkAttrsMapList) {
                String fkSchema = SqlUtils.safeToString(fkAttr.get("CONSTRAINT_SCHEMA"));
                String fkName = SqlUtils.safeToString(fkAttr.get("CONSTRAINT_NAME"));
                String fkKey = fkSchema + "." + fkName;
                MySqlForeignKey foreignKey = fkMap.computeIfAbsent(fkKey, k -> {
                    MySqlForeignKey sqlForeignKey = new MySqlForeignKey();
                    sqlForeignKey.setSchema(fkSchema);
                    sqlForeignKey.setName(fkName);
                    sqlForeignKey.setConstraintType(MySqlConstraintType.ForeignKey);
                    return sqlForeignKey;
                });
                foreignKey.setReferenceTable(SqlUtils.safeToString(fkAttr.get("REFERENCED_TABLE_NAME")));
                foreignKey.setDeleteRule(MySqlForeignKeyRule.valueOfCode(SqlUtils.safeToString(fkAttr.get("DELETE_RULE"))));
                foreignKey.setUpdateRule(MySqlForeignKeyRule.valueOfCode(SqlUtils.safeToString(fkAttr.get("UPDATE_RULE"))));
            }
            String queryFkColumns = "select c.CONSTRAINT_SCHEMA,c.CONSTRAINT_NAME,c.COLUMN_NAME,c.REFERENCED_TABLE_SCHEMA,c.REFERENCED_TABLE_NAME,c.REFERENCED_COLUMN_NAME,s.INDEX_TYPE from INFORMATION_SCHEMA.KEY_COLUMN_USAGE c left join INFORMATION_SCHEMA.STATISTICS s on s.TABLE_SCHEMA = c.TABLE_SCHEMA and s.TABLE_NAME = c.TABLE_NAME and s.INDEX_NAME = c.CONSTRAINT_NAME and s.COLUMN_NAME = c.COLUMN_NAME where c.CONSTRAINT_SCHEMA in " + constraintSchemaWhereIn + " and c.CONSTRAINT_NAME in " + constraintNameWhereIn + " and c.TABLE_SCHEMA = ? and c.TABLE_NAME = ? order by c.POSITION_IN_UNIQUE_CONSTRAINT asc";
            ArrayList<String> queryFkColumnsParam = new ArrayList<String>();
            queryFkColumnsParam.addAll(constraintSchemaList);
            queryFkColumnsParam.addAll(constraintNameList);
            queryFkColumnsParam.add(schemaName);
            queryFkColumnsParam.add(tableName);
            List<Map<String, Object>> queryFkColumnList = new JdbcTemplate(conn).queryForList(queryFkColumns, queryFkColumnsParam.toArray());
            if (queryFkColumnList == null || queryFkColumnList.size() < fkAttrsMapList.size()) {
                throw new IllegalArgumentException("query fk result data error.");
            }
            for (Map<String, Object> columnData : queryFkColumnList) {
                String fkSchema = SqlUtils.safeToString(columnData.get("CONSTRAINT_SCHEMA"));
                String fkName = SqlUtils.safeToString(columnData.get("CONSTRAINT_NAME"));
                String fkKey = fkSchema + "." + fkName + "";
                MySqlForeignKey foreignKey = (MySqlForeignKey)fkMap.get(fkKey);
                String columnName = SqlUtils.safeToString(columnData.get("COLUMN_NAME"));
                String columnIndexType = SqlUtils.safeToString(columnData.get("INDEX_TYPE"));
                String refColumn = SqlUtils.safeToString(columnData.get("REFERENCED_COLUMN_NAME"));
                foreignKey.getFkColumn().add(columnName);
                foreignKey.getStorageType().put(columnName, columnIndexType);
                foreignKey.setReferenceSchema(SqlUtils.safeToString(columnData.get("REFERENCED_TABLE_SCHEMA")));
                foreignKey.setReferenceTable(SqlUtils.safeToString(columnData.get("REFERENCED_TABLE_NAME")));
                foreignKey.getReferenceMapping().put(columnName, refColumn);
            }
            ArrayList arrayList = new ArrayList(fkMap.values());
            return arrayList;
        }
    }

    public List<MySqlIndex> getIndexes(String schemaName, String tableName) throws SQLException {
        if (StringUtils.isBlank((String)schemaName) || StringUtils.isBlank((String)tableName)) {
            return Collections.emptyList();
        }
        String queryString = "select TABLE_CATALOG,TABLE_SCHEMA,TABLE_NAME,INDEX_NAME,INDEX_TYPE,NON_UNIQUE,COLUMN_NAME FROM INFORMATION_SCHEMA.STATISTICS where TABLE_SCHEMA = ? and TABLE_NAME = ? order by SEQ_IN_INDEX asc";
        try (Connection conn = (Connection)this.connectSupplier.get();){
            List<Map<String, Object>> mapList = new JdbcTemplate(conn).queryForList(queryString, schemaName, tableName);
            if (mapList == null) {
                List<MySqlIndex> list = Collections.emptyList();
                return list;
            }
            List<MySqlConstraint> constraints = this.getConstraint(schemaName, tableName);
            Map<String, MySqlConstraint> constraintMap = constraints.stream().collect(Collectors.toMap(MySqlConstraint::getName, constraint -> constraint));
            LinkedHashMap<String, MySqlIndex> groupByName = new LinkedHashMap<String, MySqlIndex>();
            for (Map<String, Object> indexColumn : mapList) {
                String indexName = SqlUtils.safeToString(indexColumn.get("INDEX_NAME"));
                MySqlIndex indexMap = groupByName.computeIfAbsent(indexName, k -> {
                    MySqlIndexType indexType = null;
                    if (constraintMap.containsKey(indexName)) {
                        switch (((MySqlConstraint)constraintMap.get(indexName)).getConstraintType()) {
                            case PrimaryKey: {
                                indexType = MySqlIndexType.Primary;
                                break;
                            }
                            case Unique: {
                                indexType = MySqlIndexType.Unique;
                                break;
                            }
                            case ForeignKey: {
                                indexType = MySqlIndexType.Foreign;
                            }
                        }
                    } else {
                        indexType = MySqlIndexType.Normal;
                    }
                    MySqlIndex mySqlIndex = new MySqlIndex();
                    mySqlIndex.setName((String)k);
                    mySqlIndex.setIndexEnum(indexType);
                    return mySqlIndex;
                });
                String columnName = SqlUtils.safeToString(indexColumn.get("COLUMN_NAME"));
                String indexType = SqlUtils.safeToString(indexColumn.get("INDEX_TYPE"));
                indexMap.getColumns().add(columnName);
                indexMap.getStorageType().put(columnName, indexType);
            }
            ArrayList arrayList = new ArrayList(groupByName.values());
            return arrayList;
        }
    }

    public List<MySqlIndex> getIndexes(String schemaName, String tableName, MySqlIndexType ... indexTypes) throws SQLException {
        if (StringUtils.isBlank((String)schemaName) || StringUtils.isBlank((String)tableName)) {
            return Collections.emptyList();
        }
        if (indexTypes == null || indexTypes.length == 0) {
            return Collections.emptyList();
        }
        List<MySqlIndex> indexList = this.getIndexes(schemaName, tableName);
        if (indexList == null || indexList.isEmpty()) {
            return Collections.emptyList();
        }
        return indexList.stream().filter(indexItem -> {
            MySqlIndexType indexTypeForItem = indexItem.getIndexEnum();
            for (MySqlIndexType matchType : indexTypes) {
                if (indexTypeForItem != matchType) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public MySqlIndex getIndexes(String schemaName, String tableName, String indexName) throws SQLException {
        if (StringUtils.isBlank((String)schemaName) || StringUtils.isBlank((String)tableName) || StringUtils.isBlank((String)indexName)) {
            return null;
        }
        List<MySqlIndex> indexList = this.getIndexes(schemaName, tableName);
        if (indexList == null || indexList.isEmpty()) {
            return null;
        }
        return indexList.stream().filter(indexItem -> StringUtils.equals((String)indexItem.getName(), (String)indexName)).findFirst().orElse(null);
    }

    protected static JDBCType columnTypeMappingToJdbcType(String columnType) {
        MysqlType mysqlType = MysqlType.getByName(columnType);
        return JDBCType.valueOf(mysqlType.getJdbcType());
    }
}

