/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.metadata;

import java.util.Collection;
import java.util.Date;
import net.hasor.db.metadata.mysql.MySqlTypes;
import net.hasor.utils.StringUtils;
import net.hasor.utils.convert.ConverterUtils;

class SqlUtils {
    SqlUtils() {
    }

    protected static String safeToString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    protected static Integer safeToInteger(Object obj) {
        return obj == null ? null : (Integer)ConverterUtils.convert(Integer.class, (Object)obj);
    }

    protected static Long safeToLong(Object obj) {
        return obj == null ? null : (Long)ConverterUtils.convert(Long.class, (Object)obj);
    }

    protected static Boolean safeToBoolean(Object obj) {
        return obj == null ? null : (Boolean)ConverterUtils.convert(Boolean.class, (Object)obj);
    }

    protected static Date safeToDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Number) {
            return new Date(((Number)obj).longValue());
        }
        throw new ClassCastException(obj.getClass() + " Type cannot be converted to Date");
    }

    protected static String buildWhereIn(Collection<?> paramMap) {
        StringBuilder whereIn = new StringBuilder();
        whereIn.append("(");
        whereIn.append(StringUtils.repeat((String)"?,", (int)paramMap.size()));
        whereIn.deleteCharAt(whereIn.length() - 1);
        whereIn.append(")");
        return whereIn.toString();
    }

    protected static MySqlTypes safeToMySqlTypes(Object obj) {
        String dat = obj == null ? null : obj.toString();
        for (MySqlTypes type : MySqlTypes.values()) {
            if (!type.getCodeKey().equalsIgnoreCase(dat)) continue;
            return type;
        }
        return null;
    }
}

