/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction;

import java.sql.Connection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import net.hasor.db.datasource.ConnectionHolder;
import net.hasor.db.datasource.DataSourceManager;
import net.hasor.db.transaction.TransactionManager;
import net.hasor.db.transaction.TransactionTemplate;
import net.hasor.db.transaction.support.JdbcTransactionManager;

public class TranManager
extends DataSourceManager {
    private static final ThreadLocal<Map<DataSource, JdbcTransactionManager>> managerMap = ThreadLocal.withInitial(ConcurrentHashMap::new);
    private static final ThreadLocal<Map<DataSource, ConnectionHolder>> currentMap = ThreadLocal.withInitial(ConcurrentHashMap::new);

    public static ConnectionHolder currentConnectionHolder(DataSource dataSource) {
        Objects.requireNonNull(dataSource);
        Map<DataSource, ConnectionHolder> localMap = currentMap.get();
        ConnectionHolder holder = localMap.get(dataSource);
        if (holder == null) {
            holder = localMap.putIfAbsent(dataSource, TranManager.newConnectionHolder(dataSource));
            holder = localMap.get(dataSource);
        }
        return holder;
    }

    public static Connection currentConnection(DataSource dataSource) {
        ConnectionHolder holder = TranManager.currentConnectionHolder(dataSource);
        return TranManager.newProxyConnection(holder);
    }

    protected static void currentConnection(DataSource dataSource, ConnectionHolder holder) {
        Map<DataSource, ConnectionHolder> localMap = currentMap.get();
        if (holder == null) {
            localMap.remove(dataSource);
        } else {
            localMap.put(dataSource, holder);
        }
    }

    private static synchronized JdbcTransactionManager getTransactionManager(DataSource dataSource) {
        Objects.requireNonNull(dataSource);
        Map<DataSource, JdbcTransactionManager> localMap = managerMap.get();
        JdbcTransactionManager manager = localMap.get(dataSource);
        if (manager == null) {
            manager = new JdbcTransactionManager(dataSource);
            localMap.put(dataSource, manager);
        }
        return manager;
    }

    public static synchronized TransactionManager getManager(DataSource dataSource) {
        return TranManager.getTransactionManager(dataSource);
    }

    public static synchronized TransactionTemplate getTemplate(DataSource dataSource) {
        JdbcTransactionManager manager = TranManager.getTransactionManager(dataSource);
        return manager.getTransactionTemplate();
    }
}

