/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction.support;

import java.sql.SQLException;
import java.sql.Savepoint;
import net.hasor.db.datasource.SavepointManager;
import net.hasor.db.transaction.Isolation;
import net.hasor.db.transaction.Propagation;
import net.hasor.db.transaction.TransactionStatus;
import net.hasor.db.transaction.support.TransactionObject;

public class JdbcTransactionStatus
implements TransactionStatus {
    private Savepoint savepoint = null;
    private TransactionObject tranConn = null;
    private TransactionObject suspendConn = null;
    private Propagation behavior = null;
    private Isolation level = null;
    private boolean completed = false;
    private boolean rollbackOnly = false;
    private boolean newConnection = false;
    private boolean readOnly = false;

    public JdbcTransactionStatus(Propagation behavior, Isolation level) {
        this.behavior = behavior;
        this.level = level;
    }

    private SavepointManager getSavepointManager() {
        return this.tranConn.getSavepointManager();
    }

    public void markHeldSavepoint() throws SQLException {
        if (this.hasSavepoint()) {
            throw new SQLException("TransactionStatus has Savepoint");
        }
        if (!this.getSavepointManager().supportSavepoint()) {
            throw new SQLException("SavepointManager does not support Savepoint.");
        }
        this.savepoint = this.getSavepointManager().createSavepoint();
    }

    public void releaseHeldSavepoint() throws SQLException {
        if (!this.hasSavepoint()) {
            throw new SQLException("TransactionStatus has not Savepoint");
        }
        if (!this.getSavepointManager().supportSavepoint()) {
            throw new SQLException("SavepointManager does not support Savepoint.");
        }
        this.getSavepointManager().releaseSavepoint(this.savepoint);
    }

    public void rollbackToHeldSavepoint() throws SQLException {
        if (!this.hasSavepoint()) {
            throw new SQLException("TransactionStatus has not Savepoint");
        }
        if (!this.getSavepointManager().supportSavepoint()) {
            throw new SQLException("SavepointManager does not support Savepoint.");
        }
        this.getSavepointManager().rollbackToSavepoint(this.savepoint);
    }

    void setCompleted() {
        this.completed = true;
    }

    void markNewConnection() {
        this.newConnection = true;
    }

    TransactionObject getTranConn() {
        return this.tranConn;
    }

    void setTranConn(TransactionObject tranConn) {
        this.tranConn = tranConn;
    }

    TransactionObject getSuspendConn() {
        return this.suspendConn;
    }

    void setSuspendConn(TransactionObject suspendConn) {
        this.suspendConn = suspendConn;
    }

    @Override
    public Propagation getTransactionBehavior() {
        return this.behavior;
    }

    @Override
    public Isolation getIsolationLevel() {
        return this.level;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isNewConnection() {
        return this.newConnection;
    }

    @Override
    public boolean isSuspend() {
        return this.suspendConn != null;
    }

    @Override
    public boolean hasSavepoint() {
        return this.savepoint != null;
    }

    @Override
    public void setRollbackOnly() throws SQLException {
        if (this.isCompleted()) {
            throw new SQLException("Transaction is already completed.");
        }
        this.rollbackOnly = true;
    }

    @Override
    public void setReadOnly() throws SQLException {
        if (this.isCompleted()) {
            throw new SQLException("Transaction is already completed.");
        }
        this.readOnly = true;
    }
}

