/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.hasor.db.types.MappedCross;
import net.hasor.db.types.MappedJavaTypes;
import net.hasor.db.types.MappedJdbcTypes;
import net.hasor.db.types.TypeHandler;
import net.hasor.db.types.UnknownTypeHandler;
import net.hasor.db.types.handler.ArrayTypeHandler;
import net.hasor.db.types.handler.BigDecimalTypeHandler;
import net.hasor.db.types.handler.BigIntegerTypeHandler;
import net.hasor.db.types.handler.BlobBytesForWrapTypeHandler;
import net.hasor.db.types.handler.BlobBytesTypeHandler;
import net.hasor.db.types.handler.BlobInputStreamTypeHandler;
import net.hasor.db.types.handler.BooleanTypeHandler;
import net.hasor.db.types.handler.ByteTypeHandler;
import net.hasor.db.types.handler.BytesForWrapTypeHandler;
import net.hasor.db.types.handler.BytesInputStreamTypeHandler;
import net.hasor.db.types.handler.BytesTypeHandler;
import net.hasor.db.types.handler.CharacterTypeHandler;
import net.hasor.db.types.handler.ClobReaderTypeHandler;
import net.hasor.db.types.handler.ClobTypeHandler;
import net.hasor.db.types.handler.DateOnlyTypeHandler;
import net.hasor.db.types.handler.DateTypeHandler;
import net.hasor.db.types.handler.DoubleTypeHandler;
import net.hasor.db.types.handler.EnumTypeHandler;
import net.hasor.db.types.handler.FloatTypeHandler;
import net.hasor.db.types.handler.InstantTypeHandler;
import net.hasor.db.types.handler.IntegerTypeHandler;
import net.hasor.db.types.handler.JapaneseDateTypeHandler;
import net.hasor.db.types.handler.LocalDateTimeTypeHandler;
import net.hasor.db.types.handler.LocalDateTypeHandler;
import net.hasor.db.types.handler.LocalTimeTypeHandler;
import net.hasor.db.types.handler.LongTypeHandler;
import net.hasor.db.types.handler.MonthDayOfNumberTypeHandler;
import net.hasor.db.types.handler.MonthDayOfStringTypeHandler;
import net.hasor.db.types.handler.MonthDayOfTimeTypeHandler;
import net.hasor.db.types.handler.MonthOfNumberTypeHandler;
import net.hasor.db.types.handler.MonthOfStringTypeHandler;
import net.hasor.db.types.handler.MonthOfTimeTypeHandler;
import net.hasor.db.types.handler.NCharacterTypeHandler;
import net.hasor.db.types.handler.NClobReaderTypeHandler;
import net.hasor.db.types.handler.NClobTypeHandler;
import net.hasor.db.types.handler.NStringReaderTypeHandler;
import net.hasor.db.types.handler.NStringTypeHandler;
import net.hasor.db.types.handler.NumberTypeHandler;
import net.hasor.db.types.handler.ObjectTypeHandler;
import net.hasor.db.types.handler.OffsetDateTimeForSqlTypeHandler;
import net.hasor.db.types.handler.OffsetDateTimeForUTCTypeHandler;
import net.hasor.db.types.handler.OffsetTimeForSqlTypeHandler;
import net.hasor.db.types.handler.OffsetTimeForUTCTypeHandler;
import net.hasor.db.types.handler.ShortTypeHandler;
import net.hasor.db.types.handler.SqlDateTypeHandler;
import net.hasor.db.types.handler.SqlTimeTypeHandler;
import net.hasor.db.types.handler.SqlTimestampTypeHandler;
import net.hasor.db.types.handler.SqlXmlForInputStreamTypeHandler;
import net.hasor.db.types.handler.SqlXmlForReaderTypeHandler;
import net.hasor.db.types.handler.SqlXmlTypeHandler;
import net.hasor.db.types.handler.StringReaderTypeHandler;
import net.hasor.db.types.handler.StringTypeHandler;
import net.hasor.db.types.handler.TimeOnlyTypeHandler;
import net.hasor.db.types.handler.YearMonthOfNumberTypeHandler;
import net.hasor.db.types.handler.YearMonthOfStringTypeHandler;
import net.hasor.db.types.handler.YearMonthOfTimeTypeHandler;
import net.hasor.db.types.handler.YearOfNumberTypeHandler;
import net.hasor.db.types.handler.YearOfStringTypeHandler;
import net.hasor.db.types.handler.YearOfTimeTypeHandler;
import net.hasor.db.types.handler.ZonedDateTimeTypeHandler;
import net.hasor.utils.ExceptionUtils;
import net.hasor.utils.reflect.TypeReference;

public final class TypeHandlerRegistry {
    private static final Map<Type, TypeHandler<?>> cachedSingleHandlers = new ConcurrentHashMap();
    private static final Map<String, JDBCType> javaTypeToJdbcTypeMap = new ConcurrentHashMap<String, JDBCType>();
    private static final Map<JDBCType, Class<?>> jdbcTypeToJavaTypeMap = new ConcurrentHashMap();
    public static final TypeHandlerRegistry DEFAULT = new TypeHandlerRegistry();
    private final UnknownTypeHandler defaultTypeHandler = new UnknownTypeHandler(this);
    private final Map<String, TypeHandler<?>> javaTypeHandlerMap = new ConcurrentHashMap();
    private final Map<JDBCType, TypeHandler<?>> jdbcTypeHandlerMap = new ConcurrentHashMap();
    private final Map<String, Map<JDBCType, TypeHandler<?>>> typeHandlerMap = new ConcurrentHashMap();

    public TypeHandlerRegistry() {
        this.register(Boolean.class, this.createSingleTypeHandler(BooleanTypeHandler.class));
        this.register(Boolean.TYPE, this.createSingleTypeHandler(BooleanTypeHandler.class));
        this.register(Byte.class, this.createSingleTypeHandler(ByteTypeHandler.class));
        this.register(Byte.TYPE, this.createSingleTypeHandler(ByteTypeHandler.class));
        this.register(Short.class, this.createSingleTypeHandler(ShortTypeHandler.class));
        this.register(Short.TYPE, this.createSingleTypeHandler(ShortTypeHandler.class));
        this.register(Integer.class, this.createSingleTypeHandler(IntegerTypeHandler.class));
        this.register(Integer.TYPE, this.createSingleTypeHandler(IntegerTypeHandler.class));
        this.register(Long.class, this.createSingleTypeHandler(LongTypeHandler.class));
        this.register(Long.TYPE, this.createSingleTypeHandler(LongTypeHandler.class));
        this.register(Float.class, this.createSingleTypeHandler(FloatTypeHandler.class));
        this.register(Float.TYPE, this.createSingleTypeHandler(FloatTypeHandler.class));
        this.register(Double.class, this.createSingleTypeHandler(DoubleTypeHandler.class));
        this.register(Double.TYPE, this.createSingleTypeHandler(DoubleTypeHandler.class));
        this.register(Character.class, this.createSingleTypeHandler(CharacterTypeHandler.class));
        this.register(Character.TYPE, this.createSingleTypeHandler(CharacterTypeHandler.class));
        this.register(Date.class, this.createSingleTypeHandler(DateTypeHandler.class));
        this.register(java.sql.Date.class, this.createSingleTypeHandler(SqlDateTypeHandler.class));
        this.register(Timestamp.class, this.createSingleTypeHandler(SqlTimestampTypeHandler.class));
        this.register(Time.class, this.createSingleTypeHandler(SqlTimeTypeHandler.class));
        this.register(Instant.class, this.createSingleTypeHandler(InstantTypeHandler.class));
        this.register(JapaneseDate.class, this.createSingleTypeHandler(JapaneseDateTypeHandler.class));
        this.register(Year.class, this.createSingleTypeHandler(YearOfTimeTypeHandler.class));
        this.register(Month.class, this.createSingleTypeHandler(MonthOfTimeTypeHandler.class));
        this.register(YearMonth.class, this.createSingleTypeHandler(YearMonthOfTimeTypeHandler.class));
        this.register(MonthDay.class, this.createSingleTypeHandler(MonthDayOfTimeTypeHandler.class));
        this.register(LocalDate.class, this.createSingleTypeHandler(LocalDateTypeHandler.class));
        this.register(LocalTime.class, this.createSingleTypeHandler(LocalTimeTypeHandler.class));
        this.register(LocalDateTime.class, this.createSingleTypeHandler(LocalDateTimeTypeHandler.class));
        this.register(ZonedDateTime.class, this.createSingleTypeHandler(ZonedDateTimeTypeHandler.class));
        this.register(OffsetDateTime.class, this.createSingleTypeHandler(OffsetDateTimeForUTCTypeHandler.class));
        this.register(OffsetTime.class, this.createSingleTypeHandler(OffsetTimeForUTCTypeHandler.class));
        this.register(String.class, this.createSingleTypeHandler(StringTypeHandler.class));
        this.register(BigInteger.class, this.createSingleTypeHandler(BigIntegerTypeHandler.class));
        this.register(BigDecimal.class, this.createSingleTypeHandler(BigDecimalTypeHandler.class));
        this.register(Reader.class, this.createSingleTypeHandler(StringReaderTypeHandler.class));
        this.register(InputStream.class, this.createSingleTypeHandler(BytesInputStreamTypeHandler.class));
        this.register(Byte[].class, this.createSingleTypeHandler(BytesForWrapTypeHandler.class));
        this.register(byte[].class, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.register(Object[].class, this.createSingleTypeHandler(ArrayTypeHandler.class));
        this.register(Object.class, this.createSingleTypeHandler(UnknownTypeHandler.class));
        this.register(Number.class, this.createSingleTypeHandler(NumberTypeHandler.class));
        this.register(Clob.class, this.createSingleTypeHandler(ClobTypeHandler.class));
        this.register(NClob.class, this.createSingleTypeHandler(NClobTypeHandler.class));
        this.register(Blob.class, this.createSingleTypeHandler(BlobBytesTypeHandler.class));
        this.register(JDBCType.BIT, this.createSingleTypeHandler(BooleanTypeHandler.class));
        this.register(JDBCType.BOOLEAN, this.createSingleTypeHandler(BooleanTypeHandler.class));
        this.register(JDBCType.TINYINT, this.createSingleTypeHandler(ByteTypeHandler.class));
        this.register(JDBCType.SMALLINT, this.createSingleTypeHandler(ShortTypeHandler.class));
        this.register(JDBCType.INTEGER, this.createSingleTypeHandler(IntegerTypeHandler.class));
        this.register(JDBCType.BIGINT, this.createSingleTypeHandler(LongTypeHandler.class));
        this.register(JDBCType.FLOAT, this.createSingleTypeHandler(FloatTypeHandler.class));
        this.register(JDBCType.DOUBLE, this.createSingleTypeHandler(DoubleTypeHandler.class));
        this.register(JDBCType.REAL, this.createSingleTypeHandler(BigDecimalTypeHandler.class));
        this.register(JDBCType.NUMERIC, this.createSingleTypeHandler(BigDecimalTypeHandler.class));
        this.register(JDBCType.DECIMAL, this.createSingleTypeHandler(BigDecimalTypeHandler.class));
        this.register(JDBCType.CHAR, this.createSingleTypeHandler(CharacterTypeHandler.class));
        this.register(JDBCType.NCHAR, this.createSingleTypeHandler(NCharacterTypeHandler.class));
        this.register(JDBCType.CLOB, this.createSingleTypeHandler(ClobTypeHandler.class));
        this.register(JDBCType.VARCHAR, this.createSingleTypeHandler(StringTypeHandler.class));
        this.register(JDBCType.LONGVARCHAR, this.createSingleTypeHandler(StringTypeHandler.class));
        this.register(JDBCType.NCLOB, this.createSingleTypeHandler(NClobTypeHandler.class));
        this.register(JDBCType.NVARCHAR, this.createSingleTypeHandler(NStringTypeHandler.class));
        this.register(JDBCType.LONGNVARCHAR, this.createSingleTypeHandler(NStringTypeHandler.class));
        this.register(JDBCType.TIMESTAMP, this.createSingleTypeHandler(DateTypeHandler.class));
        this.register(JDBCType.DATE, this.createSingleTypeHandler(DateOnlyTypeHandler.class));
        this.register(JDBCType.TIME, this.createSingleTypeHandler(TimeOnlyTypeHandler.class));
        this.register(JDBCType.TIME_WITH_TIMEZONE, this.createSingleTypeHandler(OffsetTimeForSqlTypeHandler.class));
        this.register(JDBCType.TIMESTAMP_WITH_TIMEZONE, this.createSingleTypeHandler(OffsetDateTimeForSqlTypeHandler.class));
        this.register(JDBCType.SQLXML, this.createSingleTypeHandler(SqlXmlTypeHandler.class));
        this.register(JDBCType.BINARY, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.register(JDBCType.VARBINARY, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.register(JDBCType.BLOB, this.createSingleTypeHandler(BlobBytesTypeHandler.class));
        this.register(JDBCType.LONGVARBINARY, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.register(JDBCType.JAVA_OBJECT, this.createSingleTypeHandler(ObjectTypeHandler.class));
        this.register(JDBCType.ARRAY, this.createSingleTypeHandler(ArrayTypeHandler.class));
        this.register(JDBCType.OTHER, this.createSingleTypeHandler(UnknownTypeHandler.class));
        this.registerCrossChars(MonthDay.class, this.createSingleTypeHandler(MonthDayOfStringTypeHandler.class));
        this.registerCrossNChars(MonthDay.class, this.createSingleTypeHandler(MonthDayOfStringTypeHandler.class));
        this.registerCrossNumber(MonthDay.class, this.createSingleTypeHandler(MonthDayOfNumberTypeHandler.class));
        this.registerCrossChars(YearMonth.class, this.createSingleTypeHandler(YearMonthOfStringTypeHandler.class));
        this.registerCrossNChars(YearMonth.class, this.createSingleTypeHandler(YearMonthOfStringTypeHandler.class));
        this.registerCrossNumber(YearMonth.class, this.createSingleTypeHandler(YearMonthOfNumberTypeHandler.class));
        this.registerCrossChars(Year.class, this.createSingleTypeHandler(YearOfStringTypeHandler.class));
        this.registerCrossNChars(Year.class, this.createSingleTypeHandler(YearOfStringTypeHandler.class));
        this.registerCrossNumber(Year.class, this.createSingleTypeHandler(YearOfNumberTypeHandler.class));
        this.registerCrossChars(Month.class, this.createSingleTypeHandler(MonthOfStringTypeHandler.class));
        this.registerCrossNChars(Month.class, this.createSingleTypeHandler(MonthOfStringTypeHandler.class));
        this.registerCrossNumber(Month.class, this.createSingleTypeHandler(MonthOfNumberTypeHandler.class));
        this.registerCrossChars(String.class, this.createSingleTypeHandler(StringTypeHandler.class));
        this.registerCrossNChars(String.class, this.createSingleTypeHandler(NStringTypeHandler.class));
        this.registerCross(JDBCType.CLOB, String.class, this.createSingleTypeHandler(ClobTypeHandler.class));
        this.registerCross(JDBCType.NCLOB, String.class, this.createSingleTypeHandler(NClobTypeHandler.class));
        this.registerCrossChars(Reader.class, this.createSingleTypeHandler(StringReaderTypeHandler.class));
        this.registerCrossNChars(Reader.class, this.createSingleTypeHandler(NStringReaderTypeHandler.class));
        this.registerCross(JDBCType.CLOB, Reader.class, this.createSingleTypeHandler(ClobReaderTypeHandler.class));
        this.registerCross(JDBCType.NCLOB, Reader.class, this.createSingleTypeHandler(NClobReaderTypeHandler.class));
        this.registerCross(JDBCType.SQLXML, String.class, this.createSingleTypeHandler(SqlXmlTypeHandler.class));
        this.registerCross(JDBCType.SQLXML, Reader.class, this.createSingleTypeHandler(SqlXmlForReaderTypeHandler.class));
        this.registerCross(JDBCType.SQLXML, InputStream.class, this.createSingleTypeHandler(SqlXmlForInputStreamTypeHandler.class));
        this.registerCross(JDBCType.BINARY, byte[].class, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.registerCross(JDBCType.BINARY, Byte[].class, this.createSingleTypeHandler(BytesForWrapTypeHandler.class));
        this.registerCross(JDBCType.VARBINARY, byte[].class, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.registerCross(JDBCType.VARBINARY, Byte[].class, this.createSingleTypeHandler(BytesForWrapTypeHandler.class));
        this.registerCross(JDBCType.BLOB, byte[].class, this.createSingleTypeHandler(BlobBytesTypeHandler.class));
        this.registerCross(JDBCType.BLOB, Byte[].class, this.createSingleTypeHandler(BlobBytesForWrapTypeHandler.class));
        this.registerCross(JDBCType.LONGVARBINARY, byte[].class, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.registerCross(JDBCType.LONGVARBINARY, Byte[].class, this.createSingleTypeHandler(BytesForWrapTypeHandler.class));
        this.registerCross(JDBCType.BINARY, InputStream.class, this.createSingleTypeHandler(BytesInputStreamTypeHandler.class));
        this.registerCross(JDBCType.VARBINARY, InputStream.class, this.createSingleTypeHandler(BytesInputStreamTypeHandler.class));
        this.registerCross(JDBCType.BLOB, InputStream.class, this.createSingleTypeHandler(BlobInputStreamTypeHandler.class));
        this.registerCross(JDBCType.LONGVARBINARY, InputStream.class, this.createSingleTypeHandler(BytesInputStreamTypeHandler.class));
        this.registerCross(JDBCType.ARRAY, Object.class, this.createSingleTypeHandler(ArrayTypeHandler.class));
    }

    private TypeHandler<?> createSingleTypeHandler(Class<? extends TypeHandler<?>> typeHandler) {
        cachedSingleHandlers.computeIfAbsent(typeHandler, type -> {
            try {
                if (typeHandler == UnknownTypeHandler.class) {
                    return this.defaultTypeHandler;
                }
                return (TypeHandler)typeHandler.newInstance();
            }
            catch (Exception e) {
                throw ExceptionUtils.toRuntimeException((Throwable)e);
            }
        });
        return cachedSingleHandlers.get(typeHandler);
    }

    public void register(JDBCType jdbcType, TypeHandler<?> typeHandler) {
        this.jdbcTypeHandlerMap.put(jdbcType, typeHandler);
    }

    public void register(Class<?> javaType, TypeHandler<?> typeHandler) {
        this.javaTypeHandlerMap.put(javaType.getName(), typeHandler);
    }

    public void registerCross(JDBCType jdbcType, Class<?> javaType, TypeHandler<?> typeHandler) {
        Map typeClassMap = this.typeHandlerMap.computeIfAbsent(javaType.getName(), k -> new ConcurrentHashMap());
        typeClassMap.put(jdbcType, typeHandler);
    }

    private void registerCrossChars(Class<?> jdbcType, TypeHandler<?> typeHandler) {
        this.registerCross(JDBCType.CHAR, jdbcType, typeHandler);
        this.registerCross(JDBCType.VARCHAR, jdbcType, typeHandler);
        this.registerCross(JDBCType.LONGVARCHAR, jdbcType, typeHandler);
    }

    private void registerCrossNChars(Class<?> jdbcType, TypeHandler<?> typeHandler) {
        this.registerCross(JDBCType.NCHAR, jdbcType, typeHandler);
        this.registerCross(JDBCType.NVARCHAR, jdbcType, typeHandler);
        this.registerCross(JDBCType.LONGNVARCHAR, jdbcType, typeHandler);
    }

    private void registerCrossNumber(Class<?> jdbcType, TypeHandler<?> typeHandler) {
        this.registerCross(JDBCType.TINYINT, jdbcType, typeHandler);
        this.registerCross(JDBCType.SMALLINT, jdbcType, typeHandler);
        this.registerCross(JDBCType.INTEGER, jdbcType, typeHandler);
        this.registerCross(JDBCType.BIGINT, jdbcType, typeHandler);
        this.registerCross(JDBCType.FLOAT, jdbcType, typeHandler);
        this.registerCross(JDBCType.DOUBLE, jdbcType, typeHandler);
        this.registerCross(JDBCType.REAL, jdbcType, typeHandler);
        this.registerCross(JDBCType.NUMERIC, jdbcType, typeHandler);
        this.registerCross(JDBCType.DECIMAL, jdbcType, typeHandler);
    }

    public void register(TypeHandler<?> typeHandler) {
        MappedCross[] mappedCrosses;
        MappedJdbcTypes mappedJdbcTypes;
        Class<?> handlerClass = typeHandler.getClass();
        MappedJavaTypes mappedTypes = handlerClass.getAnnotation(MappedJavaTypes.class);
        if (mappedTypes != null) {
            for (Class<?> handledType : mappedTypes.value()) {
                this.register(handledType, typeHandler);
            }
        }
        if ((mappedJdbcTypes = handlerClass.getAnnotation(MappedJdbcTypes.class)) != null) {
            for (JDBCType jdbcType : mappedJdbcTypes.value()) {
                if (typeHandler instanceof TypeReference) {
                    this.registerCross(jdbcType, ((TypeReference)typeHandler).getRawType(), typeHandler);
                    continue;
                }
                this.register(jdbcType, typeHandler);
            }
        }
        for (MappedCross cross : mappedCrosses = (MappedCross[])handlerClass.getAnnotationsByType(MappedCross.class)) {
            MappedJdbcTypes jdbcTypes = cross.jdbcType();
            MappedJavaTypes javaTypes = cross.javaTypes();
            for (Class<?> javaType : javaTypes.value()) {
                for (JDBCType jdbcType : jdbcTypes.value()) {
                    this.registerCross(jdbcType, javaType, typeHandler);
                }
            }
        }
    }

    public Collection<TypeHandler<?>> getTypeHandlers() {
        return Collections.unmodifiableCollection(this.javaTypeHandlerMap.values());
    }

    public static JDBCType toSqlType(Class<?> javaType) {
        JDBCType jdbcType = javaTypeToJdbcTypeMap.get(javaType.getName());
        if (jdbcType != null) {
            return jdbcType;
        }
        return JDBCType.OTHER;
    }

    public static Class<?> toJavaType(JDBCType jdbcType) {
        return jdbcTypeToJavaTypeMap.get(jdbcType);
    }

    public boolean hasTypeHandler(Class<?> typeClass) {
        Objects.requireNonNull(typeClass, "typeClass is null.");
        return this.javaTypeHandlerMap.containsKey(typeClass.getName());
    }

    public boolean hasTypeHandler(JDBCType jdbcType) {
        Objects.requireNonNull(jdbcType, "jdbcType is null.");
        return this.jdbcTypeHandlerMap.containsKey(jdbcType);
    }

    public boolean hasTypeHandler(Class<?> typeClass, JDBCType jdbcType) {
        Objects.requireNonNull(typeClass, "typeClass is null.");
        Objects.requireNonNull(jdbcType, "jdbcType is null.");
        Map<JDBCType, TypeHandler<?>> jdbcHandlerMap = this.typeHandlerMap.get(typeClass.getName());
        if (jdbcHandlerMap != null) {
            return jdbcHandlerMap.containsKey(jdbcType);
        }
        return false;
    }

    public TypeHandler<?> getTypeHandler(Class<?> typeClass) {
        Objects.requireNonNull(typeClass, "typeClass is null.");
        UnknownTypeHandler typeHandler = this.javaTypeHandlerMap.get(typeClass.getName());
        return typeHandler != null ? typeHandler : this.defaultTypeHandler;
    }

    public TypeHandler<?> getTypeHandler(JDBCType jdbcType) {
        Objects.requireNonNull(jdbcType, "jdbcType is null.");
        UnknownTypeHandler typeHandler = this.jdbcTypeHandlerMap.get(jdbcType);
        return typeHandler != null ? typeHandler : this.defaultTypeHandler;
    }

    public TypeHandler<?> getTypeHandler(Class<?> typeClass, JDBCType jdbcType) {
        TypeHandler<Object> typeHandler;
        TypeHandler<?> typeHandler2;
        Map<JDBCType, TypeHandler<?>> handlerMap;
        if (typeClass == null && jdbcType == null) {
            return this.defaultTypeHandler;
        }
        if (typeClass != null && jdbcType != null && (handlerMap = this.typeHandlerMap.get(typeClass.getName())) != null && (typeHandler2 = handlerMap.get(jdbcType)) != null) {
            return typeHandler2;
        }
        if (typeClass != null) {
            typeHandler = this.javaTypeHandlerMap.get(typeClass.getName());
            if (typeHandler != null) {
                return typeHandler;
            }
            if (Enum.class.isAssignableFrom(typeClass) && (typeHandler = this.javaTypeHandlerMap.get((typeClass = typeClass.isAnonymousClass() ? typeClass.getSuperclass() : typeClass).getName())) == null) {
                EnumTypeHandler enumOfStringTypeHandler = new EnumTypeHandler(typeClass);
                this.javaTypeHandlerMap.put(typeClass.getName(), enumOfStringTypeHandler);
                return enumOfStringTypeHandler;
            }
            JDBCType sqlType = TypeHandlerRegistry.toSqlType(typeClass);
            typeHandler = this.getTypeHandler(sqlType);
            if (typeHandler != null) {
                return typeHandler;
            }
        }
        return (typeHandler = this.getTypeHandler(jdbcType)) == null ? this.defaultTypeHandler : typeHandler;
    }

    public UnknownTypeHandler getDefaultTypeHandler() {
        return this.defaultTypeHandler;
    }

    public void setParameterValue(PreparedStatement ps, int parameterPosition, Object value) throws SQLException {
        if (value == null) {
            ps.setObject(parameterPosition, null);
        } else {
            Class<?> valueClass = value.getClass();
            TypeHandler<?> typeHandler = this.getTypeHandler(valueClass);
            typeHandler.setParameter(ps, parameterPosition, value, TypeHandlerRegistry.toSqlType(valueClass));
        }
    }

    static {
        javaTypeToJdbcTypeMap.put(Boolean.class.getName(), JDBCType.BIT);
        javaTypeToJdbcTypeMap.put(Boolean.TYPE.getName(), JDBCType.BIT);
        javaTypeToJdbcTypeMap.put(Byte.class.getName(), JDBCType.TINYINT);
        javaTypeToJdbcTypeMap.put(Byte.TYPE.getName(), JDBCType.TINYINT);
        javaTypeToJdbcTypeMap.put(Short.class.getName(), JDBCType.SMALLINT);
        javaTypeToJdbcTypeMap.put(Short.TYPE.getName(), JDBCType.SMALLINT);
        javaTypeToJdbcTypeMap.put(Integer.class.getName(), JDBCType.INTEGER);
        javaTypeToJdbcTypeMap.put(Integer.TYPE.getName(), JDBCType.INTEGER);
        javaTypeToJdbcTypeMap.put(Long.class.getName(), JDBCType.BIGINT);
        javaTypeToJdbcTypeMap.put(Long.TYPE.getName(), JDBCType.BIGINT);
        javaTypeToJdbcTypeMap.put(Float.class.getName(), JDBCType.FLOAT);
        javaTypeToJdbcTypeMap.put(Float.TYPE.getName(), JDBCType.FLOAT);
        javaTypeToJdbcTypeMap.put(Double.class.getName(), JDBCType.DOUBLE);
        javaTypeToJdbcTypeMap.put(Double.TYPE.getName(), JDBCType.DOUBLE);
        javaTypeToJdbcTypeMap.put(Character.class.getName(), JDBCType.CHAR);
        javaTypeToJdbcTypeMap.put(Character.TYPE.getName(), JDBCType.CHAR);
        javaTypeToJdbcTypeMap.put(Date.class.getName(), JDBCType.TIMESTAMP);
        javaTypeToJdbcTypeMap.put(java.sql.Date.class.getName(), JDBCType.DATE);
        javaTypeToJdbcTypeMap.put(Timestamp.class.getName(), JDBCType.TIMESTAMP);
        javaTypeToJdbcTypeMap.put(Time.class.getName(), JDBCType.TIME);
        javaTypeToJdbcTypeMap.put(Instant.class.getName(), JDBCType.TIMESTAMP);
        javaTypeToJdbcTypeMap.put(LocalDateTime.class.getName(), JDBCType.TIMESTAMP);
        javaTypeToJdbcTypeMap.put(LocalDate.class.getName(), JDBCType.DATE);
        javaTypeToJdbcTypeMap.put(LocalTime.class.getName(), JDBCType.TIME);
        javaTypeToJdbcTypeMap.put(ZonedDateTime.class.getName(), JDBCType.TIMESTAMP);
        javaTypeToJdbcTypeMap.put(JapaneseDate.class.getName(), JDBCType.TIMESTAMP);
        javaTypeToJdbcTypeMap.put(YearMonth.class.getName(), JDBCType.VARCHAR);
        javaTypeToJdbcTypeMap.put(Year.class.getName(), JDBCType.SMALLINT);
        javaTypeToJdbcTypeMap.put(Month.class.getName(), JDBCType.SMALLINT);
        javaTypeToJdbcTypeMap.put(OffsetDateTime.class.getName(), JDBCType.TIMESTAMP);
        javaTypeToJdbcTypeMap.put(OffsetTime.class.getName(), JDBCType.TIMESTAMP);
        javaTypeToJdbcTypeMap.put(String.class.getName(), JDBCType.VARCHAR);
        javaTypeToJdbcTypeMap.put(BigInteger.class.getName(), JDBCType.BIGINT);
        javaTypeToJdbcTypeMap.put(BigDecimal.class.getName(), JDBCType.DECIMAL);
        javaTypeToJdbcTypeMap.put(Reader.class.getName(), JDBCType.CLOB);
        javaTypeToJdbcTypeMap.put(InputStream.class.getName(), JDBCType.BLOB);
        javaTypeToJdbcTypeMap.put(URL.class.getName(), JDBCType.DATALINK);
        javaTypeToJdbcTypeMap.put(Byte[].class.getName(), JDBCType.VARBINARY);
        javaTypeToJdbcTypeMap.put(byte[].class.getName(), JDBCType.VARBINARY);
        javaTypeToJdbcTypeMap.put(Object[].class.getName(), JDBCType.ARRAY);
        javaTypeToJdbcTypeMap.put(Object.class.getName(), JDBCType.JAVA_OBJECT);
        javaTypeToJdbcTypeMap.put("oracle.jdbc.OracleBlob", JDBCType.VARBINARY);
        javaTypeToJdbcTypeMap.put("oracle.jdbc.OracleClob", JDBCType.CLOB);
        javaTypeToJdbcTypeMap.put("oracle.jdbc.OracleNClob", JDBCType.NCLOB);
        javaTypeToJdbcTypeMap.put("oracle.sql.DATE", JDBCType.DATE);
        javaTypeToJdbcTypeMap.put("oracle.sql.TIMESTAMP", JDBCType.TIMESTAMP);
        javaTypeToJdbcTypeMap.put("oracle.sql.TIMESTAMPTZ", JDBCType.TIMESTAMP);
        javaTypeToJdbcTypeMap.put("oracle.sql.TIMESTAMPLTZ", JDBCType.TIMESTAMP);
    }
}

