/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.Calendar;
import java.util.concurrent.ConcurrentHashMap;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class ArrayTypeHandler
extends AbstractTypeHandler<Object> {
    private static final ConcurrentHashMap<Class<?>, JDBCType> STANDARD_MAPPING = new ConcurrentHashMap();

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JDBCType jdbcType) throws SQLException {
        if (parameter instanceof Array) {
            ps.setArray(i, (Array)parameter);
        } else {
            if (!parameter.getClass().isArray()) {
                throw new SQLException("ArrayType Handler requires SQL array or java array parameter and does not support type " + parameter.getClass());
            }
            Class<?> componentType = parameter.getClass().getComponentType();
            String arrayTypeName = this.resolveTypeName(componentType);
            Array array = ps.getConnection().createArrayOf(arrayTypeName, (Object[])parameter);
            ps.setArray(i, array);
            array.free();
        }
    }

    protected String resolveTypeName(Class<?> type) {
        return STANDARD_MAPPING.getOrDefault(type, JDBCType.JAVA_OBJECT).getName();
    }

    @Override
    public Object getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.extractArray(rs.getArray(columnName));
    }

    @Override
    public Object getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.extractArray(rs.getArray(columnIndex));
    }

    @Override
    public Object getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.extractArray(cs.getArray(columnIndex));
    }

    protected Object extractArray(Array array) throws SQLException {
        if (array == null) {
            return null;
        }
        Object result = array.getArray();
        array.free();
        return result;
    }

    static {
        STANDARD_MAPPING.put(Boolean.TYPE, JDBCType.BOOLEAN);
        STANDARD_MAPPING.put(Boolean.class, JDBCType.BOOLEAN);
        STANDARD_MAPPING.put(Byte.TYPE, JDBCType.TINYINT);
        STANDARD_MAPPING.put(Byte.class, JDBCType.TINYINT);
        STANDARD_MAPPING.put(Short.TYPE, JDBCType.SMALLINT);
        STANDARD_MAPPING.put(Short.class, JDBCType.SMALLINT);
        STANDARD_MAPPING.put(Integer.TYPE, JDBCType.INTEGER);
        STANDARD_MAPPING.put(Integer.class, JDBCType.INTEGER);
        STANDARD_MAPPING.put(Long.TYPE, JDBCType.BIGINT);
        STANDARD_MAPPING.put(Long.class, JDBCType.BIGINT);
        STANDARD_MAPPING.put(Float.TYPE, JDBCType.FLOAT);
        STANDARD_MAPPING.put(Float.class, JDBCType.FLOAT);
        STANDARD_MAPPING.put(Double.TYPE, JDBCType.DOUBLE);
        STANDARD_MAPPING.put(Double.class, JDBCType.DOUBLE);
        STANDARD_MAPPING.put(Calendar.class, JDBCType.CHAR);
        STANDARD_MAPPING.put(Character.TYPE, JDBCType.CHAR);
        STANDARD_MAPPING.put(java.util.Date.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(Date.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(Timestamp.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(Time.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(Instant.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(LocalDateTime.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(LocalDate.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(LocalTime.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(ZonedDateTime.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(JapaneseDate.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(YearMonth.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(Year.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(Month.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(OffsetDateTime.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(OffsetTime.class, JDBCType.TIMESTAMP);
        STANDARD_MAPPING.put(String.class, JDBCType.VARCHAR);
        STANDARD_MAPPING.put(BigInteger.class, JDBCType.BIGINT);
        STANDARD_MAPPING.put(BigDecimal.class, JDBCType.NUMERIC);
        STANDARD_MAPPING.put(Byte[].class, JDBCType.VARBINARY);
        STANDARD_MAPPING.put(byte[].class, JDBCType.VARBINARY);
    }
}

