/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.io.ByteArrayInputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class BlobBytesForWrapTypeHandler
extends AbstractTypeHandler<Byte[]> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Byte[] parameter, JDBCType jdbcType) throws SQLException {
        ps.setBlob(i, new ByteArrayInputStream(this.convertToPrimitiveArray(parameter)));
    }

    @Override
    public Byte[] getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Blob blob = rs.getBlob(columnName);
        return this.getBytes(blob);
    }

    @Override
    public Byte[] getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Blob blob = rs.getBlob(columnIndex);
        return this.getBytes(blob);
    }

    @Override
    public Byte[] getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Blob blob = cs.getBlob(columnIndex);
        return this.getBytes(blob);
    }

    private Byte[] getBytes(Blob blob) throws SQLException {
        Byte[] returnValue = null;
        if (blob != null) {
            returnValue = this.convertToObjectArray(blob.getBytes(1L, (int)blob.length()));
        }
        return returnValue;
    }

    protected byte[] convertToPrimitiveArray(Byte[] objects) {
        byte[] bytes = new byte[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            bytes[i] = objects[i];
        }
        return bytes;
    }

    protected Byte[] convertToObjectArray(byte[] bytes) {
        Byte[] objects = new Byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            objects[i] = bytes[i];
        }
        return objects;
    }
}

