/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.MonthDay;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class MonthDayOfNumberTypeHandler
extends AbstractTypeHandler<MonthDay> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, MonthDay monthDay, JDBCType jdbcType) throws SQLException {
        String monthValue = String.valueOf(monthDay.getMonthValue());
        String dayValue = String.valueOf(monthDay.getDayOfMonth());
        if (monthValue.length() == 1) {
            monthValue = "0" + monthValue;
        }
        if (dayValue.length() == 1) {
            dayValue = "0" + dayValue;
        }
        ps.setInt(i, Integer.parseInt(monthValue + dayValue));
    }

    @Override
    public MonthDay getNullableResult(ResultSet rs, String columnName) throws SQLException {
        int monthDay = rs.getInt(columnName);
        return monthDay == 0 && rs.wasNull() ? null : this.parseMonthDay(monthDay);
    }

    @Override
    public MonthDay getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        int monthDay = rs.getInt(columnIndex);
        return monthDay == 0 && rs.wasNull() ? null : this.parseMonthDay(monthDay);
    }

    @Override
    public MonthDay getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        int monthDay = cs.getInt(columnIndex);
        return monthDay == 0 && cs.wasNull() ? null : this.parseMonthDay(monthDay);
    }

    protected MonthDay parseMonthDay(int monthDay) throws SQLException {
        String mdStr = String.valueOf(monthDay);
        if (mdStr.length() == 3) {
            mdStr = "0" + mdStr;
        }
        if (mdStr.length() != 4) {
            throw new SQLException("JDBC requires that the monthDay value must be 4 Numbers");
        }
        int year = Integer.parseInt(mdStr.substring(0, 2));
        int month = Integer.parseInt(mdStr.substring(2));
        return MonthDay.of(year, month);
    }
}

