/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class MonthDayOfTimeTypeHandler
extends AbstractTypeHandler<MonthDay> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, MonthDay parameter, JDBCType jdbcType) throws SQLException {
        LocalDateTime dateTime = LocalDateTime.MIN.withYear(0).withMonth(parameter.getMonthValue()).withDayOfMonth(parameter.getDayOfMonth());
        ps.setTimestamp(i, Timestamp.valueOf(dateTime));
    }

    @Override
    public MonthDay getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnName);
        return this.toMonthDay(timestamp);
    }

    @Override
    public MonthDay getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnIndex);
        return this.toMonthDay(timestamp);
    }

    @Override
    public MonthDay getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Timestamp timestamp = cs.getTimestamp(columnIndex);
        return this.toMonthDay(timestamp);
    }

    protected MonthDay toMonthDay(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        LocalDate localDate = timestamp.toLocalDateTime().toLocalDate();
        return MonthDay.of(localDate.getMonth(), localDate.getDayOfMonth());
    }
}

