/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.types.handler;

import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.hasor.db.types.handler.AbstractTypeHandler;

public class NClobReaderTypeHandler
extends AbstractTypeHandler<Reader> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Reader parameter, JDBCType jdbcType) throws SQLException {
        ps.setNClob(i, parameter);
    }

    @Override
    public Reader getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.toReader(rs.getNClob(columnName));
    }

    @Override
    public Reader getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.toReader(rs.getNClob(columnIndex));
    }

    @Override
    public Reader getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.toReader(cs.getNClob(columnIndex));
    }

    protected Reader toReader(NClob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        return clob.getCharacterStream();
    }
}

