/*
 * Copyright 2002-2010 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.hasor.jdbc;
import java.util.List;
import java.util.Map;
import net.hasor.jdbc.exceptions.DataAccessException;
/**
 * ýӿһЩ JDBC 
 * @version : 2013-10-9
 * @author Thomas Risberg
 * @author Juergen Hoeller
 * @author (zyc@hasor.net)
 */
public interface JdbcOperations {
    /**ͨصִһJDBCݷʲ */
    public <T> T execute(ConnectionCallback<T> action) throws DataAccessException;
    /**ͨصִһJDBCݷʲ */
    public <T> T execute(StatementCallback<T> action) throws DataAccessException;
    /**ִ JDBC洢̡ݷʲ
     * <p>CallableStatementCreator ӿڻ CallableStatementCallback ӿ ҪԴ洢̵Ĵá*/
    public <T> T execute(CallableStatementCreator csc, CallableStatementCallback<T> action) throws DataAccessException;
    /**ִ JDBC洢̡ݷʲSQL ᱻ PreparedStatement ͨصӿ CallableStatementCallback ִС*/
    public <T> T execute(String callString, CallableStatementCallback<T> action) throws DataAccessException;
    /**ִһ JDBC  JDBC òʹ PreparedStatement ӿִС*/
    public <T> T execute(PreparedStatementCreator psc, PreparedStatementCallback<T> action) throws DataAccessException;
    /**ִһ̬ SQL 䡣SQL ᱻ PreparedStatement ͨصӿ PreparedStatementCallback ִС*/
    public <T> T execute(String sql, PreparedStatementCallback<T> action) throws DataAccessException;
    /**ִһ JDBC  JDBC òʹ PreparedStatement ӿִС*/
    public <T> T execute(String sql, SqlParameterSource paramSource, PreparedStatementCallback<T> action) throws DataAccessException;
    /**ִһ̬ SQL 䡣SQL ᱻ PreparedStatement ͨصӿ PreparedStatementCallback ִС*/
    public <T> T execute(String sql, Map<String, ?> paramMap, PreparedStatementCallback<T> action) throws DataAccessException;
    //
    //
    //
    /**ִһ SQL䣬ͨһ DDL . */
    public void execute(String sql) throws DataAccessException;
    //
    //
    //
    /**ִһ̬ѯ SQL 䡣SQL ᱻ PreparedStatement ͨصӿ PreparedStatementCallback ִС
     * صĽʹ ResultSetExtractor ת*/
    public <T> T query(PreparedStatementCreator psc, ResultSetExtractor<T> rse) throws DataAccessException;
    /**ִһ̬ SQL 䡣ͨ ResultSetExtractor ת*/
    public <T> T query(String sql, ResultSetExtractor<T> rse) throws DataAccessException;
    /**ִһ̬ѯ SQL 䡣SQL ᱻ PreparedStatement ͨصӿ PreparedStatementSetter Ϊ̬ SQL ԡصĽʹ ResultSetExtractor ת*/
    public <T> T query(String sql, PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲҽ SQL ѯʹ ResultSetExtractor ת*/
    public <T> T query(String sql, ResultSetExtractor<T> rse, Object... args) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲҽ SQL ѯʹ ResultSetExtractor ת*/
    public <T> T query(String sql, Object[] arg, ResultSetExtractor<T> rses) throws DataAccessException;
    /**ִһ̬ѯ SQL 䣬ʹѯʹ PreparedStatement ӿڲSQL ͨ argTypes صĽʹ ResultSetExtractor ת*/
    public <T> T query(String sql, Object[] args, int[] argTypes, ResultSetExtractor<T> rse) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲҽ SQL ѯʹ ResultSetExtractor ת*/
    public <T> T query(String sql, SqlParameterSource paramSource, ResultSetExtractor<T> rse) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲҽ SQL ѯʹ ResultSetExtractor ת*/
    public <T> T query(String sql, Map<String, ?> paramMap, ResultSetExtractor<T> rse) throws DataAccessException;
    //
    //
    //
    /**
     * Query using a prepared statement, reading the ResultSet on a per-row basis with a RowCallbackHandler.
     * <p>A PreparedStatementCreator can either be implemented directly or configured through a PreparedStatementCreatorFactory.
     * @param psc object that can create a PreparedStatement given a Connection
     * @param rch object that will extract results, one row at a time
     */
    public void query(PreparedStatementCreator psc, RowCallbackHandler rch) throws DataAccessException;
    /**ִһ̬ SQL 䡣ͨ RowCallbackHandler */
    public void query(String sql, RowCallbackHandler rch) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲҽдʹ RowCallbackHandler ӿڴ*/
    public void query(String sql, PreparedStatementSetter pss, RowCallbackHandler rch) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲҽдʹ RowCallbackHandler ӿڴ*/
    public void query(String sql, RowCallbackHandler rch, Object... args) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲҽдʹ RowCallbackHandler ӿڴ*/
    public void query(String sql, Object[] args, RowCallbackHandler rch) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲҽдʹ RowCallbackHandler ӿڴ*/
    public void query(String sql, Object[] args, int[] argTypes, RowCallbackHandler rch) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲҽдʹ RowCallbackHandler ӿڴ*/
    public void query(String sql, SqlParameterSource paramSource, RowCallbackHandler rch) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲҽдʹ RowCallbackHandler ӿڴ*/
    public void query(String sql, Map<String, ?> paramMap, RowCallbackHandler rch) throws DataAccessException;
    //
    //
    //
    /**
     * Query using a prepared statement, mapping each row to a Java object via a RowMapper.
     * <p>A PreparedStatementCreator can either be implemented directly or
     * configured through a PreparedStatementCreatorFactory.
     * @param psc object that can create a PreparedStatement given a Connection
     * @param rowMapper object that will map one object per row
     * @return the result List, containing mapped objects
     */
    public <T> List<T> query(PreparedStatementCreator psc, RowMapper<T> rowMapper) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯһ Listÿһнͨ RowMapper ӳ䡣*/
    public <T> List<T> query(String sql, PreparedStatementSetter pss, RowMapper<T> rowMapper) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯһ Listÿһнͨ RowMapper ӳ䡣*/
    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object... args) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯһ Listÿһнͨ RowMapper ӳ䡣*/
    public <T> List<T> query(String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯһ Listÿһнͨ RowMapper ӳ䡣*/
    public <T> List<T> query(String sql, Object[] args, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException;
    /**ִһ̬ SQL 䣬ʹ RowMapper */
    public <T> List<T> query(String sql, RowMapper<T> rowMapper) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯһ Listÿһнͨ RowMapper ӳ䡣*/
    public <T> List<T> query(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯһ Listÿһнͨ RowMapper ӳ䡣*/
    public <T> List<T> query(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws DataAccessException;
    //
    //
    //
    /**ִһ̬ SQL 䣬ӳ䵽һб(һĿΪÿһ)Ķбÿһ¼<code>elementType</code>ָͶ*/
    public <T> List<T> queryForList(String sql, Class<T> elementType) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯת elementType ʾ͡
     * @throws DataAccessException if the query fails
     */
    public <T> List<T> queryForList(String sql, Class<T> elementType, Object... args) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯת elementType ʾ͡
     * @throws DataAccessException if the query fails
     */
    public <T> List<T> queryForList(String sql, Object[] args, Class<T> elementType) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯת elementType ʾ͡
     * @throws DataAccessException if the query fails
     * @see java.sql.Types*/
    public <T> List<T> queryForList(String sql, Object[] args, int[] argTypes, Class<T> elementType) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯת elementType ʾ͡
     * @throws DataAccessException if the query fails
     */
    public <T> List<T> queryForList(String sql, SqlParameterSource paramSource, Class<T> elementType) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯת elementType ʾ͡
     * @throws DataAccessException if the query fails
     */
    public <T> List<T> queryForList(String sql, Map<String, ?> paramMap, Class<T> elementType) throws DataAccessException;
    //
    //
    //
    /**ִһ̬ SQL 䣬ʹ RowMapper 
     * ԤƸ÷ֻᴦһݣѯڶݽȡһ¼Ϊ
     * @return ڼ¼ʱ<code>null</code>
     */
    public <T> T queryForObject(String sql, RowMapper<T> rowMapper) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯͨ RowMapper ӳתء
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     */
    public <T> T queryForObject(String sql, RowMapper<T> rowMapper, Object... args) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯͨ RowMapper ӳתء
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     */
    public <T> T queryForObject(String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯͨ RowMapper ӳתء
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     */
    public <T> T queryForObject(String sql, Object[] args, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ѯʹ SqlParameterSource װ
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     */
    public <T> T queryForObject(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ѯʹ Map װ
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     */
    public <T> T queryForObject(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws DataAccessException;
    /**ִһ̬ SQL 䣬ת<code>requiredType</code>ָͶ
     * ԤƸ÷ֻᴦһݣѯڶݽȡһ¼Ϊ
     * @return ڼ¼ʱ<code>null</code>
     */
    public <T> T queryForObject(String sql, Class<T> requiredType) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯͨ requiredType ʾͷװ
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     */
    public <T> T queryForObject(String sql, Class<T> requiredType, Object... args) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯͨ requiredType ʾͷװ
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     */
    public <T> T queryForObject(String sql, Object[] args, Class<T> requiredType) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯͨ requiredType ʾͷװ
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     * @see java.sql.Types*/
    public <T> T queryForObject(String sql, Object[] args, int[] argTypes, Class<T> requiredType) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ѯʹ SqlParameterSource װѯʹ requiredType ʾͷء
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     */
    public <T> T queryForObject(String sql, SqlParameterSource paramSource, Class<T> requiredType) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ѯʹ Map װѯʹ requiredType ʾͷء
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     */
    public <T> T queryForObject(String sql, Map<String, ?> paramMap, Class<T> requiredType) throws DataAccessException;
    //
    //
    //
    /**ִһ̬ SQL 䣬ת<code>Map</code>
     * ԤƸ÷ֻᴦһݣѯڶݽȡһ¼Ϊ
     * @return ڼ¼ʱ<code>null</code>
     */
    public Map<String, Object> queryForMap(String sql) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯʹ Map װ
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     */
    public Map<String, Object> queryForMap(String sql, Object... args) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯʹ Map װ
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     * @see java.sql.Types*/
    public Map<String, Object> queryForMap(String sql, Object[] args, int[] argTypes) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯʹ Map װ
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     */
    public Map<String, Object> queryForMap(String sql, SqlParameterSource paramSource) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯʹ Map װ
     * <p>ԤƸ÷ֻᴦһݣѯڶݽȡõһΪ
     * @throws DataAccessException if the query fails
     */
    public Map<String, Object> queryForMap(String sql, Map<String, ?> paramMap) throws DataAccessException;
    //
    //
    //
    /**ִһ̬ SQL 䣬ȡ long ݡ
     * ԤƸ÷ֻᴦһݣѯڶݻ߶н쳣
     * @return the long value, or 0 in case of SQL NULL
     */
    public long queryForLong(String sql) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯת long ͡
     * Ҫ֤ѯĽֻһһУִл쳣
     * @throws DataAccessException if the query fails
     */
    public long queryForLong(String sql, Object... args) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯת long ͡
     * Ҫ֤ѯĽֻһһУִл쳣
     * @throws DataAccessException if the query fails
     * @see java.sql.Types*/
    public long queryForLong(String sql, Object[] args, int[] argTypes) throws DataAccessException;
    /**
     * ѯһ SQL 䣬sql ͨ SqlParameterSource װѯת long ͡
     * Ҫ֤ѯĽֻһһУִл쳣
     * @throws DataAccessException if the query fails
     */
    public long queryForLong(String sql, SqlParameterSource paramSource) throws DataAccessException;
    /**
     * ѯһ SQL 䣬sql ͨ Map װѯת long ͡
     * Ҫ֤ѯĽֻһһУִл쳣
     * @throws DataAccessException if the query fails
     */
    public long queryForLong(String sql, Map<String, ?> paramMap) throws DataAccessException;
    //
    //
    //
    /**ִһ̬ SQL 䣬ȡ int ݡ
     * ԤƸ÷ֻᴦһݣѯڶݻ߶н쳣
     * @return the int value, or 0 in case of SQL NULL
     */
    public int queryForInt(String sql) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯת int ͡
     * Ҫ֤ѯĽֻһһУִл쳣
     * @throws DataAccessException if the query fails
     */
    public int queryForInt(String sql, Object... args) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯת int ͡
     * Ҫ֤ѯĽֻһһУִл쳣
     * @throws DataAccessException if the query fails
     * @see java.sql.Types*/
    public int queryForInt(String sql, Object[] args, int[] argTypes) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯת int ͡
     * Ҫ֤ѯĽֻһһУִл쳣
     * @throws DataAccessException if the query fails
     */
    public int queryForInt(String sql, SqlParameterSource paramSource) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯת int ͡
     * Ҫ֤ѯĽֻһһУִл쳣
     * @throws DataAccessException if the query fails
     */
    public int queryForInt(String sql, Map<String, ?> paramMap) throws DataAccessException;
    //
    //
    //
    /**ִһ̬ SQL 䣬ӳ䵽һб(һĿΪÿһ)Ķ
     * бÿһ¼<code>Map</code>Ͷ*/
    public List<Map<String, Object>> queryForList(String sql) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯ¼ʹ Map 棬װ List С*/
    public List<Map<String, Object>> queryForList(String sql, Object... args) throws DataAccessException;
    /**
     * ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯת Map ͡
     * @throws DataAccessException if the query fails
     * @see java.sql.Types*/
    public List<Map<String, Object>> queryForList(String sql, Object[] args, int[] argTypes) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯ¼ʹ Map 棬װ List С*/
    public List<Map<String, Object>> queryForList(String sql, SqlParameterSource paramSource) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯ¼ʹ Map 棬װ List С*/
    public List<Map<String, Object>> queryForList(String sql, Map<String, ?> paramMap) throws DataAccessException;
    //
    //
    //
    /**ִһ̬ SQL 䣬ѯʹ SqlRowSet ӿڷװ*/
    public SqlRowSet queryForRowSet(String sql) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯʹ SqlRowSet ӿڷװ
     * @see java.sql.Types*/
    public SqlRowSet queryForRowSet(String sql, Object... args) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯʹ SqlRowSet ӿڷװ
     * @see java.sql.Types*/
    public SqlRowSet queryForRowSet(String sql, Object[] args, int[] argTypes) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯʹ SqlRowSet ӿڷװ
     * @see java.sql.Types*/
    public SqlRowSet queryForRowSet(String sql, SqlParameterSource paramSource) throws DataAccessException;
    /**ѯһ SQL 䣬ʹѯʹ PreparedStatement ӿڲѯʹ SqlRowSet ӿڷװ
     * @see java.sql.Types*/
    public SqlRowSet queryForRowSet(String sql, Map<String, ?> paramMap) throws DataAccessException;
    //
    //
    //
    /**ִһ䣨insertupdatedeleteѯʹ PreparedStatement ӿڲ*/
    public int update(PreparedStatementCreator psc) throws DataAccessException;
    /**ִһ insert  updatedelete 䣬ֵڱʾӰ*/
    public int update(String sql) throws DataAccessException;
    /**ִһ䣨insertupdatedeleteѯʹ PreparedStatement ӿڲ*/
    public int update(String sql, PreparedStatementSetter pss) throws DataAccessException;
    /**ִһ䣨insertupdatedeleteѯʹ PreparedStatement ӿڲ*/
    public int update(String sql, Object... args) throws DataAccessException;
    /**ִһ䣨insertupdatedeleteѯʹ PreparedStatement ӿڲ*/
    public int update(String sql, Object[] args, int[] argTypes) throws DataAccessException;
    /**ִһ䣨insertupdatedeleteѯʹ PreparedStatement ӿڲ*/
    public int update(String sql, SqlParameterSource paramSource) throws DataAccessException;
    /**ִһ䣨insertupdatedeleteѯʹ PreparedStatement ӿڲ*/
    public int update(String sql, Map<String, ?> paramMap) throws DataAccessException;
    //
    //
    //
    /**ִ insert  updatedelete 䣬ֵڱʾӰ*/
    public int[] batchUpdate(String[] sql) throws DataAccessException;
    /**ִ SQL 䣬һеSQL ʹ BatchPreparedStatementSetter ӿá*/
    public int[] batchUpdate(String sql, BatchPreparedStatementSetter pss) throws DataAccessException;
    /**ִ SQL 䣬һеSQL ʹ BatchPreparedStatementSetter ӿá*/
    public int[] batchUpdate(String sql, Map<String, ?>[] batchValues) throws DataAccessException;
    /**ִ SQL 䣬һеSQL ʹ BatchPreparedStatementSetter ӿá*/
    public int[] batchUpdate(String sql, SqlParameterSource[] batchArgs) throws DataAccessException;
    //-------------------------------------------------------------------------
    // Methods dealing with prepared statements
    //-------------------------------------------------------------------------
    //    /**  Ϊmap */
    //    public int[] insertBatchMap(String tableName, List<Map<String, Object>> list);
    //    /**  Ϊmap   Map<String, Object>[] batch */
    //    public int[] insertBatchMap(String tableName, Map<String, Object>[] batch);
    //    /** ͨmapʽ */
    //    public int insertMap(String tableName, Map<String, Object> map);
}