/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.hasor.jdbc.core.value;
import java.sql.PreparedStatement;
import java.sql.SQLException;
/**
 * Simple interface for complex types to be set as statement parameters.
 *
 * <p>Implementations perform the actual work of setting the actual values. They must
 * implement the callback method <code>setValue</code> which can throw SQLExceptions
 * that will be caught and translated by the calling code. This callback method has
 * access to the underlying Connection via the given PreparedStatement object, if that
 * should be needed to create any database-specific objects.
 *
 * @author Juergen Hoeller
 * @since 2.5.6
 */
public interface SqlValue {
    /**
     * Set the value on the given PreparedStatement.
     * @param ps the PreparedStatement to work on
     * @param paramIndex the index of the parameter for which we need to set the value
     * @throws SQLException if a SQLException is encountered while setting parameter values
     */
    public void setValue(PreparedStatement ps, int paramIndex) throws SQLException;
    /**Clean up resources held by this value object.*/
    public void cleanup();
}