///*
// * Copyright 2008-2009 the original (zyc@hasor.net).
// *
// * Licensed under the Apache License, Version 2.0 (the "License");
// * you may not use this file except in compliance with the License.
// * You may obtain a copy of the License at
// *
// *      http://www.apache.org/licenses/LICENSE-2.0
// *
// * Unless required by applicable law or agreed to in writing, software
// * distributed under the License is distributed on an "AS IS" BASIS,
// * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// * See the License for the specific language governing permissions and
// * limitations under the License.
// */
//package net.hasor.plugins.transaction.core;
//import static net.hasor.plugins.transaction.TransactionBehavior.PROPAGATION_MANDATORY;
//import static net.hasor.plugins.transaction.TransactionBehavior.PROPAGATION_NESTED;
//import static net.hasor.plugins.transaction.TransactionBehavior.PROPAGATION_NEVER;
//import static net.hasor.plugins.transaction.TransactionBehavior.PROPAGATION_NOT_SUPPORTED;
//import static net.hasor.plugins.transaction.TransactionBehavior.PROPAGATION_REQUIRED;
//import static net.hasor.plugins.transaction.TransactionBehavior.RROPAGATION_REQUIRES_NEW;
//import java.sql.SQLException;
//import java.util.LinkedList;
//import net.hasor.core.Hasor;
//import net.hasor.jdbc.exceptions.IllegalTransactionStateException;
//import net.hasor.jdbc.exceptions.TransactionDataAccessException;
//import net.hasor.jdbc.exceptions.TransactionSuspensionNotSupportedException;
//import net.hasor.plugins.transaction.TransactionBehavior;
//import net.hasor.plugins.transaction.TransactionLevel;
//import net.hasor.plugins.transaction.TransactionManager;
//import net.hasor.plugins.transaction.TransactionStatus;
///**
// * ĳһԴ
// * 
// * <p><b><i>ջ</i></b>
// * <p>ʹòͬĴԷµбȷãcommit,rollback
// * ֮ǰᰴȺ˳ѹġջСһ񱻴commit,rollbackŻᱻջе
// * <p>(A)ջô(A)commit,rollbackʱȴ(A)Ժ
// * 
// * @version : 2013-10-30
// * @author (zyc@hasor.net)
// */
//public abstract class AbstractPlatformTransactionManager implements TransactionManager {
//    private int                           defaultTimeout = -1;
//    private LinkedList<TransactionStatus> tStatusStack   = new LinkedList<TransactionStatus>();
//    //
//    public boolean hasTransaction() {
//        return !tStatusStack.isEmpty();
//    }
//    public boolean isTopTransaction(TransactionStatus status) {
//        if (tStatusStack.isEmpty())
//            return false;
//        return this.tStatusStack.peek() == status;
//    }
//    //
//    //
//    //
//    /***/
//    public final TransactionStatus getTransaction(TransactionBehavior behavior) throws TransactionDataAccessException {
//        Hasor.assertIsNotNull(behavior);
//        return getTransaction(behavior, TransactionLevel.ISOLATION_DEFAULT);
//    };
//    public final TransactionStatus getTransaction(TransactionBehavior behavior, TransactionLevel level) throws TransactionDataAccessException {
//        Hasor.assertIsNotNull(behavior);
//        Hasor.assertIsNotNull(level);
//        Object transaction = doGetTransaction();//ȡĿǰ
//        AbstractTransactionStatus defStatus = null;//TODO new AbstractTransactionStatus(behavior, level, transaction);
//        /*-------------------------------------------------------------
//        |                      Ѿ
//        |
//        | PROPAGATION_REQUIRED     񣨲
//        | RROPAGATION_REQUIRES_NEW 񣨹ǰ񣬿
//        | PROPAGATION_NESTED       Ƕñ㣩
//        | PROPAGATION_SUPPORTS     滷
//        | PROPAGATION_NOT_SUPPORTEDʽǰ
//        | PROPAGATION_NEVER        ų쳣
//        | PROPAGATION_MANDATORY    ǿҪ񣨲
//        ===============================================================*/
//        if (this.isExistingTransaction(transaction) == true) {
//            /*RROPAGATION_REQUIRES_NEW*/
//            if (behavior == RROPAGATION_REQUIRES_NEW) {
//                this.suspend(transaction, defStatus);/*ǰ*/
//                this.processBegin(transaction, defStatus);/*һµ*/
//            }
//            /*PROPAGATION_NESTEDǶ*/
//            if (behavior == PROPAGATION_NESTED) {
//                defStatus.markHeldSavepoint();/*ñ*/
//            }
//            /*PROPAGATION_NOT_SUPPORTEDʽ*/
//            if (behavior == PROPAGATION_NOT_SUPPORTED) {
//                this.suspend(transaction, defStatus);/*ǰ*/
//            }
//            /*PROPAGATION_NEVERų*/
//            if (behavior == PROPAGATION_NEVER)
//                throw new IllegalTransactionStateException("Existing transaction found for transaction marked with propagation 'never'");
//            return defStatus;
//        }
//        /*-------------------------------------------------------------
//        |                      
//        |
//        | PROPAGATION_REQUIRED     񣨿
//        | RROPAGATION_REQUIRES_NEW 񣨿
//        | PROPAGATION_NESTED       Ƕ񣨿
//        | PROPAGATION_SUPPORTS     滷
//        | PROPAGATION_NOT_SUPPORTEDʽ
//        | PROPAGATION_NEVER        ų񣨲
//        | PROPAGATION_MANDATORY    ǿҪ쳣
//        ===============================================================*/
//        /*PROPAGATION_REQUIRED*/
//        if (behavior == PROPAGATION_REQUIRED ||
//        /*RROPAGATION_REQUIRES_NEW*/
//        behavior == RROPAGATION_REQUIRES_NEW ||
//        /*PROPAGATION_NESTEDǶ*/
//        behavior == PROPAGATION_NESTED) {
//            this.processBegin(transaction, defStatus);/**/
//        }
//        /*PROPAGATION_MANDATORYǿҪ*/
//        if (behavior == PROPAGATION_MANDATORY)
//            throw new IllegalTransactionStateException("No existing transaction found for transaction marked with propagation 'mandatory'");
//        return defStatus;
//    }
//    /**ʹһµӿһµΪǰȷڵø÷ʱǰ*/
//    private void processBegin(Object transaction, AbstractTransactionStatus defStatus) {
//        try {
//            doBegin(transaction, defStatus);
//            this.tStatusStack.push(defStatus);/*ջ*/
//        } catch (SQLException ex) {
//            throw new TransactionDataAccessException("SQL Exception :", ex);
//        }
//    }
//    /**жϵǰǷѾС÷񴫲ԵĴʽ*/
//    protected abstract boolean isExistingTransaction(Object transaction);
//    /**ڵǰϿһȫµ*/
//    protected abstract void doBegin(Object transaction, AbstractTransactionStatus defStatus) throws SQLException;
//    //
//    //
//    //
//    /**ݽ*/
//    public final void commit(TransactionStatus status) throws TransactionDataAccessException {
//        Object transaction = doGetTransaction();//ȡײάĵǰ
//        AbstractTransactionStatus defStatus = (AbstractTransactionStatus) status;
//        /*ϣҪ*/
//        if (defStatus.isCompleted())
//            throw new IllegalTransactionStateException("Transaction is already completed - do not call commit or rollback more than once per transaction");
//        /*ع*/
//        if (defStatus.isRollbackOnly()) {
//            if (Hasor.isDebugLogger())
//                Hasor.logDebug("Transactional code has requested rollback");
//            rollBack(defStatus);
//            return;
//        }
//        /*-------------------------------------------------------------
//        | 1.ۺִʽݽὫ isCompleted Ϊ true
//        | 2.״̬аһδı㡣ݽ㣬ǵݽ
//        | 3. isNew ֻΪ true ʱݽ
//        ===============================================================*/
//        try {
//            prepareCommit(defStatus);
//            /*㣬ڵݽʱֻ*/
//            if (defStatus.hasSavepoint())
//                defStatus.releaseHeldSavepoint();
//            else if (defStatus.isNewConnection())
//                doCommit(transaction, defStatus);
//            //
//        } catch (SQLException ex) {
//            rollBack(defStatus);/*ݽʧܣع*/
//            throw new TransactionDataAccessException("SQL Exception :", ex);
//        } finally {
//            cleanupAfterCompletion(defStatus);
//        }
//    }
//    /**ݽǰԤ*/
//    private void prepareCommit(AbstractTransactionStatus defStatus) {
//        /*ԤڹջĳһλУҪ񲢷Դڸ*/
//        if (this.tStatusStack.contains(defStatus) == false)
//            throw new IllegalTransactionStateException("This transaction is not derived from this Manager.");
//        /*-------------------------------------------------------------
//        | Ԥ񲢷λջеջ
//        |--------------------------\
//        | T5  ^   <-- pop-up       | ٶԤΪ T4ô
//        | T4  ^   <-- pop-up       | T5 ᱻȵݽȻ T4
//        | T3  .   <-- defStatus    | Ԥ
//        | T2                       |
//        | T1                       |
//        |--------------------------/
//        |
//        ===============================================================*/
//        //
//        TransactionStatus inStackStatus = null;
//        while ((inStackStatus = this.tStatusStack.peek()) != defStatus)
//            this.commit(inStackStatus);
//    }
//    /**ǰײݿӵݽ*/
//    protected abstract void doCommit(Object transaction, AbstractTransactionStatus defStatus) throws SQLException;
//    //
//    //
//    //
//    /**ع*/
//    public final void rollBack(TransactionStatus status) throws TransactionDataAccessException {
//        Object transaction = doGetTransaction();//ȡĿǰ
//        AbstractTransactionStatus defStatus = (AbstractTransactionStatus) status;
//        /*ϣҪ*/
//        if (defStatus.isCompleted())
//            throw new IllegalTransactionStateException("Transaction is already completed - do not call commit or rollback more than once per transaction");
//        /*-------------------------------------------------------------
//        | 1.ۺִʽݽὫ isCompleted Ϊ true
//        | 2.״̬аһδı㡣ع㣬ǻع
//        | 3. isNew ֻΪ true ʱع
//        ===============================================================*/
//        try {
//            prepareRollback(defStatus);
//            /*㣬ڵݽʱֻ*/
//            if (defStatus.hasSavepoint())
//                defStatus.rollbackToHeldSavepoint();
//            else if (defStatus.isNewConnection())
//                doRollback(transaction, defStatus);
//            //
//        } catch (SQLException ex) {
//            throw new TransactionDataAccessException("SQL Exception :", ex);
//        } finally {
//            cleanupAfterCompletion(defStatus);
//        }
//    }
//    /**عǰԤ*/
//    private void prepareRollback(AbstractTransactionStatus defStatus) {
//        /*ԤڹջĳһλУҪ񲢷Դڸ*/
//        if (this.tStatusStack.contains(defStatus) == false)
//            throw new IllegalTransactionStateException("This transaction is not derived from this Manager.");
//        /*-------------------------------------------------------------
//        | Ԥ񲢷λջеջ
//        |--------------------------\
//        | T5  ^   <-- pop-up       | ٶԤΪ T4ô
//        | T4  ^   <-- pop-up       | T5 ᱻȻعȻ T4
//        | T3  .   <-- defStatus    | Ԥ
//        | T2                       |
//        | T1                       |
//        |--------------------------/
//        |
//        ===============================================================*/
//        //
//        TransactionStatus inStackStatus = null;
//        while ((inStackStatus = this.tStatusStack.peek()) != defStatus)
//            this.rollBack(inStackStatus);
//    }
//    /**ǰײݿӵع*/
//    protected abstract void doRollback(Object transaction, AbstractTransactionStatus defStatus) throws SQLException;
//    //
//    //
//    //
//    private static class SuspendedTransactionHolder {
//        public Object transaction = null; /*ĵײ*/
//    }
//    /**ǰ*/
//    protected final void suspend(Object transaction, AbstractTransactionStatus defStatus) {
//        try {
//            /*ǷΪջ*/
//            prepareCheckStack(defStatus);
//            /* SuspendedTransactionHolder ڱ浱ǰײݿԼ*/
//            doSuspend(transaction, defStatus);
//            SuspendedTransactionHolder suspendedHolder = new SuspendedTransactionHolder();
//            suspendedHolder.transaction = transaction;/*ڵײ㣩*/
//            defStatus.setSuspendHolder(suspendedHolder);
//            //
//        } catch (SQLException ex) {
//            throw new TransactionDataAccessException("SQL Exception :", ex);
//        }
//    }
//    /**Ҫд÷transaction񣬲ͬʱյײ㵱ǰݿӣ*/
//    protected void doSuspend(Object transaction, AbstractTransactionStatus defStatus) throws SQLException {
//        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + getClass().getName() + "] does not support transaction suspension");
//    }
//    /**ָ񣬻ָʱǵǰƴǰ֮ڻָ*/
//    protected final void resume(Object transaction, AbstractTransactionStatus defStatus) {
//        if (defStatus.isCompleted() == false)
//            throw new IllegalTransactionStateException("the Transaction has not completed.");
//        try {
//            /*ǷΪջ*/
//            prepareCheckStack(defStatus);
//            SuspendedTransactionHolder suspendedHolder = (SuspendedTransactionHolder) defStatus.getSuspendedTransactionHolder();
//            doResume(suspendedHolder.transaction, defStatus);
//        } catch (SQLException ex) {
//            throw new TransactionDataAccessException("SQL Exception :", ex);
//        }
//    }
//    /**ָ񣬻ָԭ񣨵һʹù״ָ̬ǰݿӡ*/
//    protected void doResume(Object resumeTransaction, AbstractTransactionStatus defStatus) throws SQLException {
//        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + getClass().getName() + "] does not support transaction suspension");
//    }
//    //
//    //
//    //
//    /**ڴ״̬Ƿλջ׳쳣*/
//    private void prepareCheckStack(AbstractTransactionStatus defStatus) {
//        if (!this.isTopTransaction(defStatus))
//            throw new IllegalTransactionStateException("the Transaction Status is not top in stack.");
//    }
//    /**commit,rollback֮ͬʱҲָͲջ*/
//    private void cleanupAfterCompletion(AbstractTransactionStatus defStatus) {
//        /*λջ*/
//        prepareCheckStack(defStatus);
//        /**/
//        defStatus.setCompleted();
//        /*ָ*/
//        if (defStatus.getSuspendedTransactionHolder() != null) {
//            if (Hasor.isDebugLogger())
//                Hasor.logDebug("Resuming suspended transaction after completion of inner transaction");
//            resume(defStatus.getSuspendedTransactionHolder(), defStatus);
//        }
//    }
//    /**ȡǰдڵ*/
//    protected abstract Object doGetTransaction();
//}