/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.hasor.jdbc.PreparedStatementSetter;
import net.hasor.jdbc.core.ParameterDisposer;
import net.hasor.jdbc.core.util.StatementSetterUtils;
import net.hasor.jdbc.parameter.SqlVarParameter;

class ArgPreparedStatementSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final Object[] args;

    public ArgPreparedStatementSetter(Object[] args) {
        this.args = args;
    }

    @Override
    public void setValues(PreparedStatement ps) throws SQLException {
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                Object arg = this.args[i];
                this.doSetValue(ps, i + 1, arg);
            }
        }
    }

    protected void doSetValue(PreparedStatement ps, int parameterPosition, Object argValue) throws SQLException {
        if (argValue instanceof SqlVarParameter) {
            SqlVarParameter paramValue = (SqlVarParameter)argValue;
            StatementSetterUtils.setParameterValue(ps, parameterPosition, paramValue, paramValue.getValue());
        } else {
            StatementSetterUtils.setParameterValue(ps, parameterPosition, Integer.MIN_VALUE, argValue);
        }
    }

    @Override
    public void cleanupParameters() {
        StatementSetterUtils.cleanupParameters(this.args);
    }
}

