/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.hasor.core.Hasor;
import net.hasor.jdbc.BatchPreparedStatementSetter;
import net.hasor.jdbc.CallableStatementCallback;
import net.hasor.jdbc.CallableStatementCreator;
import net.hasor.jdbc.ConnectionCallback;
import net.hasor.jdbc.JdbcOperations;
import net.hasor.jdbc.PreparedStatementCallback;
import net.hasor.jdbc.PreparedStatementCreator;
import net.hasor.jdbc.PreparedStatementSetter;
import net.hasor.jdbc.ResultSetExtractor;
import net.hasor.jdbc.RowCallbackHandler;
import net.hasor.jdbc.RowMapper;
import net.hasor.jdbc.SqlParameterSource;
import net.hasor.jdbc.SqlRowSet;
import net.hasor.jdbc.StatementCallback;
import net.hasor.jdbc.core.ArgPreparedStatementSetter;
import net.hasor.jdbc.core.ArgTypePreparedStatementSetter;
import net.hasor.jdbc.core.InterruptibleBatchPreparedStatementSetter;
import net.hasor.jdbc.core.JdbcAccessor;
import net.hasor.jdbc.core.LinkedCaseInsensitiveMap;
import net.hasor.jdbc.core.ParameterDisposer;
import net.hasor.jdbc.core.RowMapperResultSetExtractor;
import net.hasor.jdbc.core.SqlProvider;
import net.hasor.jdbc.core.SqlRowSetResultSetExtractor;
import net.hasor.jdbc.core.mapper.BeanPropertyRowMapper;
import net.hasor.jdbc.core.mapper.ColumnMapRowMapper;
import net.hasor.jdbc.core.mapper.SingleColumnRowMapper;
import net.hasor.jdbc.core.source.MapSqlParameterSource;
import net.hasor.jdbc.core.util.JdbcUtils;
import net.hasor.jdbc.core.util.NamedBatchUpdateUtils;
import net.hasor.jdbc.core.util.NamedParameterUtils;
import net.hasor.jdbc.core.util.ParsedSql;
import net.hasor.jdbc.core.util.PreparedStatementCreatorFactory;
import net.hasor.jdbc.datasource.ConnectionProxy;
import net.hasor.jdbc.datasource.DataSourceUtils;
import net.hasor.jdbc.exceptions.DataAccessException;
import net.hasor.jdbc.exceptions.InvalidDataAccessException;
import net.hasor.jdbc.exceptions.SQLWarningException;
import org.more.util.ArrayUtils;
import org.more.util.IOUtils;
import org.more.util.ResourcesUtils;

public class JdbcTemplate
extends JdbcAccessor
implements JdbcOperations {
    public static final int DEFAULT_CACHE_LIMIT = 256;
    private boolean ignoreWarnings = true;
    private int fetchSize = 0;
    private int maxRows = 0;
    private int queryTimeout = 0;
    private boolean resultsCaseInsensitive = false;
    private volatile int cacheLimit = 256;
    private Map<String, ParsedSql> parsedSqlCache = new LinkedHashMap<String, ParsedSql>(256, 0.75f, true){
        private static final long serialVersionUID = -4651854332831321954L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ParsedSql> eldest) {
            return this.size() > JdbcTemplate.this.getCacheLimit();
        }
    };

    public JdbcTemplate() {
    }

    public JdbcTemplate(DataSource dataSource) {
        this();
        this.setDataSource(dataSource);
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public boolean isResultsCaseInsensitive() {
        return this.resultsCaseInsensitive;
    }

    public void setResultsCaseInsensitive(boolean resultsCaseInsensitive) {
        this.resultsCaseInsensitive = resultsCaseInsensitive;
    }

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    public void loadSQL(String sqlResource) throws IOException {
        InputStream inStream = ResourcesUtils.getResourceAsStream((String)sqlResource);
        if (inStream == null) {
            throw new IOException("can't find :" + sqlResource);
        }
        StringWriter outWriter = new StringWriter();
        IOUtils.copy((InputStream)inStream, (Writer)outWriter);
        this.execute(outWriter.toString());
    }

    public void loadSQL(Reader sqlReader) throws IOException {
        StringWriter outWriter = new StringWriter();
        IOUtils.copy((Reader)sqlReader, (Writer)outWriter);
        this.execute(outWriter.toString());
    }

    @Override
    public <T> T execute(ConnectionCallback<T> action) throws DataAccessException {
        Hasor.assertIsNotNull(action, (String)"Callback object must not be null");
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        con = this.newProxyConnection(con);
        try {
            T t = action.doInConnection(con);
            return t;
        }
        catch (SQLException ex) {
            throw new DataAccessException("ConnectionCallback SQL :" + JdbcTemplate.getSql(action), ex);
        }
        finally {
            DataSourceUtils.releaseConnection(con, this.getDataSource());
        }
    }

    @Override
    public <T> T execute(StatementCallback<T> action) throws DataAccessException {
        Hasor.assertIsNotNull(action, (String)"Callback object must not be null");
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        con = this.newProxyConnection(con);
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            this.applyStatementSettings(stmt);
            T result = action.doInStatement(stmt);
            this.handleWarnings(stmt);
            T t = result;
            return t;
        }
        catch (SQLException ex) {
            throw new DataAccessException("StatementCallback SQL :" + JdbcTemplate.getSql(action), ex);
        }
        finally {
            JdbcUtils.closeStatement(stmt);
            DataSourceUtils.releaseConnection(con, this.getDataSource());
            stmt = null;
            con = null;
        }
    }

    @Override
    public <T> T execute(PreparedStatementCreator psc, PreparedStatementCallback<T> action) throws DataAccessException {
        Hasor.assertIsNotNull((Object)psc, (String)"PreparedStatementCreator must not be null");
        Hasor.assertIsNotNull(action, (String)"Callback object must not be null");
        if (Hasor.isDebugLogger()) {
            String sql = JdbcTemplate.getSql(psc);
            Hasor.logDebug((String)("Executing prepared SQL statement " + (sql != null ? " [" + sql + "]" : "")), (Object[])new Object[0]);
        }
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        con = this.newProxyConnection(con);
        PreparedStatement ps = null;
        try {
            ps = psc.createPreparedStatement(con);
            this.applyStatementSettings(ps);
            T result = action.doInPreparedStatement(ps);
            this.handleWarnings(ps);
            T t = result;
            return t;
        }
        catch (SQLException ex) {
            throw new DataAccessException("PreparedStatementCallback SQL :" + JdbcTemplate.getSql(psc), ex);
        }
        finally {
            if (psc instanceof ParameterDisposer) {
                ((ParameterDisposer)((Object)psc)).cleanupParameters();
            }
            JdbcUtils.closeStatement(ps);
            DataSourceUtils.releaseConnection(con, this.getDataSource());
            ps = null;
            con = null;
        }
    }

    @Override
    public <T> T execute(CallableStatementCreator csc, CallableStatementCallback<T> action) throws DataAccessException {
        Hasor.assertIsNotNull((Object)csc, (String)"CallableStatementCreator must not be null");
        Hasor.assertIsNotNull(action, (String)"Callback object must not be null");
        if (Hasor.isDebugLogger()) {
            String sql = JdbcTemplate.getSql(csc);
            Hasor.logDebug((String)("Calling stored procedure" + (sql != null ? " [" + sql + "]" : "")), (Object[])new Object[0]);
        }
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        con = this.newProxyConnection(con);
        CallableStatement cs = null;
        try {
            cs = csc.createCallableStatement(con);
            this.applyStatementSettings(cs);
            T result = action.doInCallableStatement(cs);
            this.handleWarnings(cs);
            T t = result;
            return t;
        }
        catch (SQLException ex) {
            throw new DataAccessException("CallableStatementCallback SQL :" + JdbcTemplate.getSql(action), ex);
        }
        finally {
            if (csc instanceof ParameterDisposer) {
                ((ParameterDisposer)((Object)csc)).cleanupParameters();
            }
            JdbcUtils.closeStatement(cs);
            DataSourceUtils.releaseConnection(con, this.getDataSource());
        }
    }

    @Override
    public <T> T execute(String sql, PreparedStatementCallback<T> action) throws DataAccessException {
        return this.execute(new SimplePreparedStatementCreator(sql), action);
    }

    @Override
    public <T> T execute(String callString, CallableStatementCallback<T> action) throws DataAccessException {
        return this.execute(new SimpleCallableStatementCreator(callString), action);
    }

    @Override
    public <T> T execute(String sql, SqlParameterSource paramSource, PreparedStatementCallback<T> action) throws DataAccessException {
        return this.execute(this.getPreparedStatementCreator(sql, paramSource), action);
    }

    @Override
    public <T> T execute(String sql, Map<String, ?> paramMap, PreparedStatementCallback<T> action) throws DataAccessException {
        return this.execute(sql, new MapSqlParameterSource(paramMap), action);
    }

    @Override
    public void execute(final String sql) throws DataAccessException {
        Hasor.logDebug((String)"Executing SQL statement [%s].", (Object[])new Object[]{sql});
        class ExecuteStatementCallback
        implements StatementCallback<Object>,
        SqlProvider {
            ExecuteStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement stmt) throws SQLException {
                stmt.execute(sql);
                return null;
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        this.execute(new ExecuteStatementCallback());
    }

    public <T> T query(PreparedStatementCreator psc, final PreparedStatementSetter pss, final ResultSetExtractor<T> rse) throws DataAccessException {
        Hasor.assertIsNotNull(rse, (String)"ResultSetExtractor must not be null");
        Hasor.logDebug((String)"Executing prepared SQL query", (Object[])new Object[0]);
        return this.execute(psc, new PreparedStatementCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInPreparedStatement(PreparedStatement ps) throws SQLException {
                ResultSet rs = null;
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    rs = ps.executeQuery();
                    Object t = rse.extractData(rs);
                    return t;
                }
                finally {
                    rs.close();
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                }
            }
        });
    }

    @Override
    public <T> T query(PreparedStatementCreator psc, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(psc, null, rse);
    }

    @Override
    public <T> T query(final String sql, final ResultSetExtractor<T> rse) throws DataAccessException {
        Hasor.assertIsNotNull((Object)sql, (String)"SQL must not be null");
        Hasor.assertIsNotNull(rse, (String)"ResultSetExtractor must not be null");
        Hasor.logDebug((String)"Executing SQL query [%s].", (Object[])new Object[]{sql});
        class QueryStatementCallback
        implements StatementCallback<T>,
        SqlProvider {
            QueryStatementCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInStatement(Statement stmt) throws SQLException {
                Object t;
                ResultSet rs = null;
                try {
                    rs = stmt.executeQuery(sql);
                    t = rse.extractData(rs);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(rs);
                    rs = null;
                    throw throwable;
                }
                JdbcUtils.closeResultSet(rs);
                rs = null;
                return t;
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        return this.execute(new QueryStatementCallback());
    }

    @Override
    public <T> T query(String sql, PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(new SimplePreparedStatementCreator(sql), pss, rse);
    }

    @Override
    public <T> T query(String sql, ResultSetExtractor<T> rse, Object ... args) throws DataAccessException {
        return this.query(sql, this.newArgPreparedStatementSetter(args), rse);
    }

    @Override
    public <T> T query(String sql, Object[] args, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(sql, this.newArgPreparedStatementSetter(args), rse);
    }

    @Override
    public <T> T query(String sql, Object[] args, int[] argTypes, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(sql, this.newArgTypePreparedStatementSetter(args, argTypes), rse);
    }

    @Override
    public <T> T query(String sql, SqlParameterSource paramSource, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(this.getPreparedStatementCreator(sql, paramSource), rse);
    }

    @Override
    public <T> T query(String sql, Map<String, ?> paramMap, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rse);
    }

    @Override
    public void query(PreparedStatementCreator psc, RowCallbackHandler rch) throws DataAccessException {
        this.query(psc, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql, PreparedStatementSetter pss, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql, pss, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql, RowCallbackHandler rch, Object ... args) throws DataAccessException {
        this.query(sql, this.newArgPreparedStatementSetter(args), rch);
    }

    @Override
    public void query(String sql, Object[] args, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql, this.newArgPreparedStatementSetter(args), rch);
    }

    @Override
    public void query(String sql, Object[] args, int[] argTypes, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql, this.newArgTypePreparedStatementSetter(args, argTypes), rch);
    }

    @Override
    public void query(String sql, SqlParameterSource paramSource, RowCallbackHandler rch) throws DataAccessException {
        this.query(this.getPreparedStatementCreator(sql, paramSource), rch);
    }

    @Override
    public void query(String sql, Map<String, ?> paramMap, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rch);
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator psc, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(psc, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, PreparedStatementSetter pss, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(sql, pss, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return (List)this.query(sql, args, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(sql, args, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, Object[] args, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(sql, args, argTypes, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(sql, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(this.getPreparedStatementCreator(sql, paramSource), rowMapper);
    }

    @Override
    public <T> List<T> query(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rowMapper);
    }

    @Override
    public <T> List<T> queryForList(String sql, Class<T> elementType) throws DataAccessException {
        return this.query(sql, this.getBeanPropertyRowMapper(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, Class<T> elementType, Object ... args) throws DataAccessException {
        return this.query(sql, args, this.getBeanPropertyRowMapper(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, Object[] args, Class<T> elementType) throws DataAccessException {
        return this.query(sql, args, this.getBeanPropertyRowMapper(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, Object[] args, int[] argTypes, Class<T> elementType) throws DataAccessException {
        return this.query(sql, args, argTypes, this.getBeanPropertyRowMapper(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, SqlParameterSource paramSource, Class<T> elementType) throws DataAccessException {
        return this.query(sql, paramSource, this.getBeanPropertyRowMapper(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, Map<String, ?> paramMap, Class<T> elementType) throws DataAccessException {
        return this.queryForList(sql, new MapSqlParameterSource(paramMap), elementType);
    }

    @Override
    public <T> T queryForObject(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        List<T> results = this.query(sql, rowMapper);
        return JdbcTemplate.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        List results = (List)this.query(sql, args, new RowMapperResultSetExtractor<T>(rowMapper, 1));
        return JdbcTemplate.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        List results = (List)this.query(sql, args, new RowMapperResultSetExtractor<T>(rowMapper, 1));
        return JdbcTemplate.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql, Object[] args, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException {
        List results = (List)this.query(sql, args, argTypes, new RowMapperResultSetExtractor<T>(rowMapper, 1));
        return JdbcTemplate.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws DataAccessException {
        List<T> results = this.query(this.getPreparedStatementCreator(sql, paramSource), rowMapper);
        return JdbcTemplate.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws DataAccessException {
        return this.queryForObject(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rowMapper);
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return this.queryForObject(sql, args, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, Object[] args, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql, args, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, Object[] args, int[] argTypes, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql, args, argTypes, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, SqlParameterSource paramSource, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql, paramSource, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, Map<String, ?> paramMap, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql, paramMap, this.getBeanPropertyRowMapper(requiredType));
    }

    @Override
    public long queryForLong(String sql) throws DataAccessException {
        Number number = this.queryForObject(sql, this.getSingleColumnRowMapper(Long.class));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, Object ... args) throws DataAccessException {
        Number number = this.queryForObject(sql, args, this.getSingleColumnRowMapper(Long.class));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        Number number = this.queryForObject(sql, args, argTypes, this.getSingleColumnRowMapper(Long.class));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, SqlParameterSource paramSource) throws DataAccessException {
        Number number = this.queryForObject(sql, paramSource, this.getSingleColumnRowMapper(Number.class));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, Map<String, ?> paramMap) throws DataAccessException {
        return this.queryForLong(sql, new MapSqlParameterSource(paramMap));
    }

    @Override
    public int queryForInt(String sql) throws DataAccessException {
        Number number = this.queryForObject(sql, this.getSingleColumnRowMapper(Integer.class));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, Object ... args) throws DataAccessException {
        Number number = this.queryForObject(sql, args, this.getSingleColumnRowMapper(Integer.class));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        Number number = this.queryForObject(sql, args, argTypes, this.getSingleColumnRowMapper(Integer.class));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, SqlParameterSource paramSource) throws DataAccessException {
        Number number = this.queryForObject(sql, paramSource, this.getSingleColumnRowMapper(Number.class));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, Map<String, ?> paramMap) throws DataAccessException {
        return this.queryForInt(sql, new MapSqlParameterSource(paramMap));
    }

    @Override
    public Map<String, Object> queryForMap(String sql) throws DataAccessException {
        return this.queryForObject(sql, this.getColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object ... args) throws DataAccessException {
        return this.queryForObject(sql, args, this.getColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return this.queryForObject(sql, args, argTypes, this.getColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return this.queryForObject(sql, paramSource, this.getColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Map<String, ?> paramMap) throws DataAccessException {
        return this.queryForObject(sql, paramMap, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql) throws DataAccessException {
        return this.query(sql, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object ... args) throws DataAccessException {
        return this.query(sql, args, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return this.query(sql, args, argTypes, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return this.query(sql, paramSource, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Map<String, ?> paramMap) throws DataAccessException {
        return this.queryForList(sql, new MapSqlParameterSource(paramMap));
    }

    @Override
    public SqlRowSet queryForRowSet(String sql) throws DataAccessException {
        return this.query(sql, new SqlRowSetResultSetExtractor());
    }

    @Override
    public SqlRowSet queryForRowSet(String sql, Object ... args) throws DataAccessException {
        return this.query(sql, args, new SqlRowSetResultSetExtractor());
    }

    @Override
    public SqlRowSet queryForRowSet(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return this.query(sql, args, argTypes, new SqlRowSetResultSetExtractor());
    }

    @Override
    public SqlRowSet queryForRowSet(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return this.query(this.getPreparedStatementCreator(sql, paramSource), new SqlRowSetResultSetExtractor());
    }

    @Override
    public SqlRowSet queryForRowSet(String sql, Map<String, ?> paramMap) throws DataAccessException {
        return this.queryForRowSet(sql, new MapSqlParameterSource(paramMap));
    }

    public int update(PreparedStatementCreator psc, final PreparedStatementSetter pss) throws DataAccessException {
        Hasor.logDebug((String)"Executing prepared SQL update", (Object[])new Object[0]);
        return this.execute(psc, new PreparedStatementCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException {
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    int rows = ps.executeUpdate();
                    Hasor.logDebug((String)("SQL update affected " + rows + " rows"), (Object[])new Object[0]);
                    Integer n = rows;
                    return n;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                }
            }
        });
    }

    @Override
    public int update(PreparedStatementCreator psc) throws DataAccessException {
        return this.update(psc, (PreparedStatementSetter)null);
    }

    @Override
    public int update(final String sql) throws DataAccessException {
        Hasor.assertIsNotNull((Object)sql, (String)"SQL must not be null");
        Hasor.logDebug((String)"Executing SQL update [%s]", (Object[])new Object[]{sql});
        class UpdateStatementCallback
        implements StatementCallback<Integer>,
        SqlProvider {
            UpdateStatementCallback() {
            }

            @Override
            public Integer doInStatement(Statement stmt) throws SQLException {
                int rows = stmt.executeUpdate(sql);
                Hasor.logDebug((String)"SQL update affected %s rows.", (Object[])new Object[]{rows});
                return rows;
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        return this.execute(new UpdateStatementCallback());
    }

    @Override
    public int update(String sql, PreparedStatementSetter pss) throws DataAccessException {
        return this.update(new SimplePreparedStatementCreator(sql), pss);
    }

    @Override
    public int update(String sql, Object ... args) throws DataAccessException {
        return this.update(sql, this.newArgPreparedStatementSetter(args));
    }

    @Override
    public int update(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return this.update(sql, this.newArgTypePreparedStatementSetter(args, argTypes));
    }

    @Override
    public int update(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return this.update(this.getPreparedStatementCreator(sql, paramSource));
    }

    @Override
    public int update(String sql, Map<String, ?> paramMap) throws DataAccessException {
        return this.update(sql, new MapSqlParameterSource(paramMap));
    }

    @Override
    public int[] batchUpdate(final String[] sql) throws DataAccessException {
        if (ArrayUtils.isEmpty((Object[])sql)) {
            throw new NullPointerException(sql + "SQL array must not be empty");
        }
        Hasor.logDebug((String)"Executing SQL batch update of %s statements", (Object[])new Object[]{sql.length});
        class BatchUpdateStatementCallback
        implements StatementCallback<int[]>,
        SqlProvider {
            private String currSql;

            BatchUpdateStatementCallback() {
            }

            @Override
            public int[] doInStatement(Statement stmt) throws SQLException, DataAccessException {
                DatabaseMetaData dbmd = stmt.getConnection().getMetaData();
                int[] rowsAffected = new int[sql.length];
                if (dbmd.supportsBatchUpdates()) {
                    String[] arr$ = sql;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String sqlStmt;
                        this.currSql = sqlStmt = arr$[i$];
                        stmt.addBatch(sqlStmt);
                    }
                    rowsAffected = stmt.executeBatch();
                } else {
                    for (int i = 0; i < sql.length; ++i) {
                        this.currSql = sql[i];
                        if (stmt.execute(sql[i])) {
                            throw new InvalidDataAccessException("Invalid batch SQL statement: " + sql[i]);
                        }
                        rowsAffected[i] = stmt.getUpdateCount();
                    }
                }
                return rowsAffected;
            }

            @Override
            public String getSql() {
                return this.currSql;
            }
        }
        return this.execute(new BatchUpdateStatementCallback());
    }

    @Override
    public int[] batchUpdate(String sql, final BatchPreparedStatementSetter pss) throws DataAccessException {
        Hasor.logDebug((String)"Executing SQL batch update [%s].", (Object[])new Object[]{sql});
        return this.execute(sql, new PreparedStatementCallback<int[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] doInPreparedStatement(PreparedStatement ps) throws SQLException {
                try {
                    int batchSize = pss.getBatchSize();
                    InterruptibleBatchPreparedStatementSetter ipss = pss instanceof InterruptibleBatchPreparedStatementSetter ? (InterruptibleBatchPreparedStatementSetter)pss : null;
                    DatabaseMetaData dbMetaData = ps.getConnection().getMetaData();
                    if (dbMetaData.supportsBatchUpdates()) {
                        for (int i = 0; i < batchSize; ++i) {
                            pss.setValues(ps, i);
                            if (ipss != null && ipss.isBatchExhausted(i)) break;
                            ps.addBatch();
                        }
                        int[] i = ps.executeBatch();
                        return i;
                    }
                    ArrayList<Integer> rowsAffected = new ArrayList<Integer>();
                    for (int i = 0; i < batchSize; ++i) {
                        pss.setValues(ps, i);
                        if (ipss != null && ipss.isBatchExhausted(i)) break;
                        rowsAffected.add(ps.executeUpdate());
                    }
                    int[] rowsAffectedArray = new int[rowsAffected.size()];
                    for (int i = 0; i < rowsAffectedArray.length; ++i) {
                        rowsAffectedArray[i] = (Integer)rowsAffected.get(i);
                    }
                    int[] nArray = rowsAffectedArray;
                    return nArray;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                }
            }
        });
    }

    @Override
    public int[] batchUpdate(String sql, Map<String, ?>[] batchValues) {
        SqlParameterSource[] batchArgs = new SqlParameterSource[batchValues.length];
        int i = 0;
        for (Map<String, ?> values : batchValues) {
            batchArgs[i] = new MapSqlParameterSource(values);
            ++i;
        }
        return this.batchUpdate(sql, batchArgs);
    }

    @Override
    public int[] batchUpdate(String sql, SqlParameterSource[] batchArgs) {
        ParsedSql parsedSql = this.getParsedSql(sql);
        return NamedBatchUpdateUtils.executeBatchUpdateWithNamedParameters(parsedSql, batchArgs, this);
    }

    protected RowMapper<Map<String, Object>> getColumnMapRowMapper() {
        return new ColumnMapRowMapper(){

            @Override
            protected Map<String, Object> createColumnMap(int columnCount) {
                return JdbcTemplate.this.createResultsMap();
            }
        };
    }

    protected <T> RowMapper<T> getBeanPropertyRowMapper(Class<T> requiredType) {
        Hasor.assertIsNotNull((Object)(requiredType != null ? 1 : 0), (String)"requiredType is null.");
        if (Map.class.isAssignableFrom(requiredType)) {
            return this.getColumnMapRowMapper();
        }
        if (requiredType.isPrimitive() || Number.class.isAssignableFrom(requiredType) || String.class.isAssignableFrom(requiredType)) {
            return this.getSingleColumnRowMapper(requiredType);
        }
        return new BeanPropertyRowMapper<T>(requiredType){

            @Override
            public boolean isCaseInsensitive() {
                return JdbcTemplate.this.isResultsCaseInsensitive();
            }
        };
    }

    protected <T> RowMapper<T> getSingleColumnRowMapper(Class<T> requiredType) {
        return new SingleColumnRowMapper<T>(requiredType);
    }

    protected Map<String, Object> createResultsMap() {
        if (!this.isResultsCaseInsensitive()) {
            return new LinkedCaseInsensitiveMap<Object>();
        }
        return new LinkedHashMap<String, Object>();
    }

    protected PreparedStatementSetter newArgPreparedStatementSetter(Object[] args) {
        return new ArgPreparedStatementSetter(args);
    }

    protected PreparedStatementSetter newArgTypePreparedStatementSetter(Object[] args, int[] argTypes) {
        return new ArgTypePreparedStatementSetter(args, argTypes);
    }

    protected void applyStatementSettings(Statement stmt) throws SQLException {
        int timeout;
        int maxRows;
        int fetchSize = this.getFetchSize();
        if (fetchSize > 0) {
            stmt.setFetchSize(fetchSize);
        }
        if ((maxRows = this.getMaxRows()) > 0) {
            stmt.setMaxRows(maxRows);
        }
        if ((timeout = this.getQueryTimeout()) > 0) {
            stmt.setQueryTimeout(timeout);
        }
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource paramSource) {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(parsedSql, paramSource);
        Object[] params = NamedParameterUtils.buildValueArray(parsedSql, paramSource, null);
        int[] paramTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, paramSource);
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sqlToUse, paramTypes);
        return pscf.newPreparedStatementCreator(params);
    }

    private void handleWarnings(Statement stmt) throws SQLException {
        if (this.isIgnoreWarnings()) {
            if (Hasor.isDebugLogger()) {
                for (SQLWarning warningToLog = stmt.getWarnings(); warningToLog != null; warningToLog = warningToLog.getNextWarning()) {
                    Hasor.logDebug((String)"SQLWarning ignored: SQL state '%s', error code '%s', message [%s].", (Object[])new Object[]{warningToLog.getSQLState(), warningToLog.getErrorCode(), warningToLog.getMessage()});
                }
            }
        } else {
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                throw new SQLWarningException("Warning not ignored", warning);
            }
        }
    }

    private static String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParsedSql getParsedSql(String sql) {
        if (this.getCacheLimit() <= 0) {
            return NamedParameterUtils.parseSqlStatement(sql);
        }
        Map<String, ParsedSql> map = this.parsedSqlCache;
        synchronized (map) {
            ParsedSql parsedSql = this.parsedSqlCache.get(sql);
            if (parsedSql == null) {
                parsedSql = NamedParameterUtils.parseSqlStatement(sql);
                this.parsedSqlCache.put(sql, parsedSql);
            }
            return parsedSql;
        }
    }

    private static <T> T requiredSingleResult(Collection<T> results) throws InvalidDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            throw new InvalidDataAccessException("Empty Result");
        }
        if (results.size() > 1) {
            throw new InvalidDataAccessException("Incorrect column count: expected 1, actual " + size);
        }
        return results.iterator().next();
    }

    private Connection newProxyConnection(Connection conn) {
        Hasor.assertIsNotNull((Object)conn, (String)"Connection is null.");
        CloseSuppressingInvocationHandler handler = new CloseSuppressingInvocationHandler(conn);
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)handler);
    }

    private static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor<Object> {
        private final RowCallbackHandler rch;

        public RowCallbackHandlerResultSetExtractor(RowCallbackHandler rch) {
            this.rch = rch;
        }

        @Override
        public Object extractData(ResultSet rs) throws SQLException {
            while (rs.next()) {
                this.rch.processRow(rs);
            }
            return null;
        }
    }

    private static class SimpleCallableStatementCreator
    implements CallableStatementCreator,
    SqlProvider {
        private final String callString;

        public SimpleCallableStatementCreator(String callString) {
            Hasor.assertIsNotNull((Object)callString, (String)"Call string must not be null");
            this.callString = callString;
        }

        @Override
        public CallableStatement createCallableStatement(Connection con) throws SQLException {
            return con.prepareCall(this.callString);
        }

        @Override
        public String getSql() {
            return this.callString;
        }
    }

    private static class SimplePreparedStatementCreator
    implements PreparedStatementCreator,
    SqlProvider {
        private final String sql;

        public SimplePreparedStatementCreator(String sql) {
            Hasor.assertIsNotNull((Object)sql, (String)"SQL must not be null");
            this.sql = sql;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            return con.prepareStatement(this.sql);
        }

        @Override
        public String getSql() {
            return this.sql;
        }
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getTargetConnection")) {
                return this.target;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Statement) {
                    JdbcTemplate.this.applyStatementSettings((Statement)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

