/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.core.mapper;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hasor.core.Hasor;
import net.hasor.jdbc.RowMapper;
import net.hasor.jdbc.core.util.JdbcUtils;
import org.more.UnhandledException;
import org.more.util.BeanUtils;

public class BeanPropertyRowMapper<T>
implements RowMapper<T> {
    private Class<T> requiredType;
    private boolean caseInsensitive = false;
    private Map<String, String> columnMapping = new HashMap<String, String>();

    public BeanPropertyRowMapper() {
    }

    public BeanPropertyRowMapper(Class<T> requiredType) {
        Hasor.assertIsNotNull(requiredType, (String)"requiredType is null.");
        this.requiredType = requiredType;
        this.loadMapping();
    }

    public void setRequiredType(Class<T> requiredType) {
        Hasor.assertIsNotNull(requiredType, (String)"requiredType is null.");
        this.requiredType = requiredType;
        this.loadMapping();
    }

    private void loadMapping() {
        this.columnMapping.clear();
        List prop = BeanUtils.getPropertysAndFields(this.requiredType);
        for (String pName : prop) {
            this.columnMapping.put(pName.toUpperCase(), pName);
        }
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        try {
            T targetObject = this.requiredType.newInstance();
            return this.tranResultSet(rs, targetObject);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UnhandledException((Throwable)e);
        }
    }

    private T tranResultSet(ResultSet rs, T targetObject) throws SQLException, IOException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        for (int i = 1; i < nrOfColumns; ++i) {
            Class paramType;
            String colName = rsmd.getColumnName(i);
            if (!this.caseInsensitive) {
                colName = this.columnMapping.get(colName.toUpperCase());
            }
            if ((paramType = BeanUtils.getPropertyOrFieldType(this.requiredType, (String)colName)) == null) continue;
            Object colValue = this.getColumnValue(rs, i, paramType);
            BeanUtils.writePropertyOrField(targetObject, (String)colName, (Object)colValue);
        }
        return targetObject;
    }

    protected Object getColumnValue(ResultSet rs, int index, Class requiredType) throws SQLException {
        if (requiredType != null) {
            return JdbcUtils.getResultSetValue(rs, index, requiredType);
        }
        return this.getColumnValue(rs, index);
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue(rs, index);
    }

    public static <T> BeanPropertyRowMapper<T> newInstance(Class<T> mappedClass) {
        BeanPropertyRowMapper<T> newInstance = new BeanPropertyRowMapper<T>();
        newInstance.setRequiredType(mappedClass);
        return newInstance;
    }
}

