/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.core.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.hasor.jdbc.RowMapper;
import net.hasor.jdbc.core.util.JdbcUtils;
import net.hasor.jdbc.core.util.NumberUtils;
import net.hasor.jdbc.exceptions.InvalidDataAccessException;
import net.hasor.jdbc.exceptions.TypeMismatchDataAccessException;

public class SingleColumnRowMapper<T>
implements RowMapper<T> {
    private Class<T> requiredType;

    public SingleColumnRowMapper() {
    }

    public SingleColumnRowMapper(Class<T> requiredType) {
        this.requiredType = requiredType;
    }

    public void setRequiredType(Class<T> requiredType) {
        this.requiredType = requiredType;
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        if (nrOfColumns != 1) {
            throw new InvalidDataAccessException("Incorrect column count: expected 1, actual " + nrOfColumns);
        }
        Object result = this.getColumnValue(rs, 1, this.requiredType);
        if (result != null && this.requiredType != null && !this.requiredType.isInstance(result)) {
            try {
                return (T)this.convertValueToRequiredType(result, this.requiredType);
            }
            catch (IllegalArgumentException ex) {
                throw new TypeMismatchDataAccessException("Type mismatch affecting row number " + rowNum + " and column type '" + rsmd.getColumnTypeName(1) + "': " + ex.getMessage());
            }
        }
        return (T)result;
    }

    protected Object getColumnValue(ResultSet rs, int index, Class requiredType) throws SQLException {
        if (requiredType != null) {
            return JdbcUtils.getResultSetValue(rs, index, requiredType);
        }
        return this.getColumnValue(rs, index);
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue(rs, index);
    }

    protected Object convertValueToRequiredType(Object value, Class requiredType) {
        if (String.class.equals((Object)requiredType)) {
            return value.toString();
        }
        if (Number.class.isAssignableFrom(requiredType)) {
            if (value instanceof Number) {
                return NumberUtils.convertNumberToTargetClass((Number)value, requiredType);
            }
            return NumberUtils.parseNumber(value.toString(), requiredType);
        }
        throw new IllegalArgumentException("Value [" + value + "] is of type [" + value.getClass().getName() + "] and cannot be converted to required type [" + requiredType.getName() + "]");
    }
}

