/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.core.rowset;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import net.hasor.jdbc.SqlRowSet;
import net.hasor.jdbc.SqlRowSetMetaData;
import net.hasor.jdbc.core.rowset.ResultSetWrappingSqlRowSetMetaData;
import net.hasor.jdbc.exceptions.InvalidDataAccessException;

public class ResultSetWrappingSqlRowSet
implements SqlRowSet {
    private static final long serialVersionUID = -4688694393146734764L;
    private final ResultSet resultSet;
    private final SqlRowSetMetaData rowSetMetaData;

    public ResultSetWrappingSqlRowSet(ResultSet resultSet) throws InvalidDataAccessException {
        this.resultSet = resultSet;
        try {
            this.rowSetMetaData = new ResultSetWrappingSqlRowSetMetaData(resultSet.getMetaData());
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    public final ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public final SqlRowSetMetaData getMetaData() {
        return this.rowSetMetaData;
    }

    @Override
    public int findColumn(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.findColumn(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getBigDecimal(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getBigDecimal(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getBoolean(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getBoolean(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public byte getByte(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getByte(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public byte getByte(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getByte(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws InvalidDataAccessException {
        try {
            return this.resultSet.getDate(columnIndex, cal);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Date getDate(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getDate(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws InvalidDataAccessException {
        try {
            return this.resultSet.getDate(columnName, cal);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Date getDate(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getDate(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getDouble(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public double getDouble(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getDouble(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getFloat(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public float getFloat(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getFloat(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public int getInt(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getInt(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public int getInt(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getInt(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public long getLong(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getLong(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public long getLong(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getLong(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Object getObject(int i, Map map) throws InvalidDataAccessException {
        try {
            return this.resultSet.getObject(i, map);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getObject(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Object getObject(String columnName, Map map) throws InvalidDataAccessException {
        try {
            return this.resultSet.getObject(columnName, map);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Object getObject(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getObject(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public short getShort(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getShort(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public short getShort(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getShort(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public String getString(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getString(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public String getString(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getString(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws InvalidDataAccessException {
        try {
            return this.resultSet.getTime(columnIndex, cal);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getTime(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws InvalidDataAccessException {
        try {
            return this.resultSet.getTime(columnName, cal);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Time getTime(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getTime(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws InvalidDataAccessException {
        try {
            return this.resultSet.getTimestamp(columnIndex, cal);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws InvalidDataAccessException {
        try {
            return this.resultSet.getTimestamp(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws InvalidDataAccessException {
        try {
            return this.resultSet.getTimestamp(columnName, cal);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws InvalidDataAccessException {
        try {
            return this.resultSet.getTimestamp(columnName);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean absolute(int row) throws InvalidDataAccessException {
        try {
            return this.resultSet.absolute(row);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public void afterLast() throws InvalidDataAccessException {
        try {
            this.resultSet.afterLast();
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public void beforeFirst() throws InvalidDataAccessException {
        try {
            this.resultSet.beforeFirst();
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean first() throws InvalidDataAccessException {
        try {
            return this.resultSet.first();
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public int getRow() throws InvalidDataAccessException {
        try {
            return this.resultSet.getRow();
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean isAfterLast() throws InvalidDataAccessException {
        try {
            return this.resultSet.isAfterLast();
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean isBeforeFirst() throws InvalidDataAccessException {
        try {
            return this.resultSet.isBeforeFirst();
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean isFirst() throws InvalidDataAccessException {
        try {
            return this.resultSet.isFirst();
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean isLast() throws InvalidDataAccessException {
        try {
            return this.resultSet.isLast();
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean last() throws InvalidDataAccessException {
        try {
            return this.resultSet.last();
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean next() throws InvalidDataAccessException {
        try {
            return this.resultSet.next();
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean previous() throws InvalidDataAccessException {
        try {
            return this.resultSet.previous();
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean relative(int rows) throws InvalidDataAccessException {
        try {
            return this.resultSet.relative(rows);
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }

    @Override
    public boolean wasNull() throws InvalidDataAccessException {
        try {
            return this.resultSet.wasNull();
        }
        catch (SQLException se) {
            throw new InvalidDataAccessException(se);
        }
    }
}

