/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.core.util;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import net.hasor.core.Hasor;

public class JdbcUtils {
    public static final int TYPE_UNKNOWN = Integer.MIN_VALUE;

    public static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }

    public static Object getResultSetValue(ResultSet rs, int index, Class requiredType) throws SQLException {
        if (requiredType == null) {
            return JdbcUtils.getResultSetValue(rs, index);
        }
        Object value = null;
        boolean wasNullCheck = false;
        if (String.class.equals((Object)requiredType)) {
            value = rs.getString(index);
        } else if (Boolean.TYPE.equals(requiredType) || Boolean.class.equals((Object)requiredType)) {
            value = rs.getBoolean(index);
            wasNullCheck = true;
        } else if (Byte.TYPE.equals(requiredType) || Byte.class.equals((Object)requiredType)) {
            value = rs.getByte(index);
            wasNullCheck = true;
        } else if (Short.TYPE.equals(requiredType) || Short.class.equals((Object)requiredType)) {
            value = rs.getShort(index);
            wasNullCheck = true;
        } else if (Integer.TYPE.equals(requiredType) || Integer.class.equals((Object)requiredType)) {
            value = rs.getInt(index);
            wasNullCheck = true;
        } else if (Long.TYPE.equals(requiredType) || Long.class.equals((Object)requiredType)) {
            value = rs.getLong(index);
            wasNullCheck = true;
        } else if (Float.TYPE.equals(requiredType) || Float.class.equals((Object)requiredType)) {
            value = Float.valueOf(rs.getFloat(index));
            wasNullCheck = true;
        } else if (Double.TYPE.equals(requiredType) || Double.class.equals((Object)requiredType) || Number.class.equals((Object)requiredType)) {
            value = rs.getDouble(index);
            wasNullCheck = true;
        } else {
            value = byte[].class.equals((Object)requiredType) ? (Object)rs.getBytes(index) : (Date.class.equals((Object)requiredType) ? rs.getDate(index) : (Time.class.equals((Object)requiredType) ? rs.getTime(index) : (Timestamp.class.equals((Object)requiredType) || java.util.Date.class.equals((Object)requiredType) ? rs.getTimestamp(index) : (BigDecimal.class.equals((Object)requiredType) ? rs.getBigDecimal(index) : (Blob.class.equals((Object)requiredType) ? rs.getBlob(index) : (Clob.class.equals((Object)requiredType) ? rs.getClob(index) : JdbcUtils.getResultSetValue(rs, index)))))));
        }
        if (wasNullCheck && value != null && rs.wasNull()) {
            value = null;
        }
        return value;
    }

    public static Object getResultSetValue(ResultSet rs, int index) throws SQLException {
        Object obj = rs.getObject(index);
        String className = null;
        if (obj != null) {
            className = obj.getClass().getName();
        }
        if (obj instanceof Blob) {
            obj = rs.getBytes(index);
        } else if (obj instanceof Clob) {
            obj = rs.getString(index);
        } else if (className != null && ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className))) {
            obj = rs.getTimestamp(index);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getMetaData().getColumnClassName(index);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
        } else if (obj != null && obj instanceof Date && "java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index))) {
            obj = rs.getTimestamp(index);
        }
        return obj;
    }

    public static void closeConnection(Connection con) {
        if (con == null) {
            return;
        }
        try {
            con.close();
        }
        catch (SQLException ex) {
            Hasor.logTrace((String)"Could not close JDBC Connection", (Object[])new Object[]{ex});
        }
        catch (Throwable ex) {
            Hasor.logTrace((String)"Unexpected exception on closing JDBC Connection", (Object[])new Object[]{ex});
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                Hasor.logTrace((String)"Could not close JDBC Statement", (Object[])new Object[]{ex});
            }
            catch (Throwable ex) {
                Hasor.logTrace((String)"Unexpected exception on closing JDBC Statement", (Object[])new Object[]{ex});
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Hasor.logTrace((String)"Could not close JDBC ResultSet", (Object[])new Object[]{ex});
            }
            catch (Throwable ex) {
                Hasor.logTrace((String)"Unexpected exception on closing JDBC ResultSet", (Object[])new Object[]{ex});
            }
        }
    }
}

