/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.core.util;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import net.hasor.jdbc.BatchPreparedStatementSetter;
import net.hasor.jdbc.JdbcOperations;
import net.hasor.jdbc.SqlParameterSource;
import net.hasor.jdbc.core.util.NamedParameterUtils;
import net.hasor.jdbc.core.util.ParsedSql;
import net.hasor.jdbc.core.util.StatementSetterUtils;
import net.hasor.jdbc.parameter.SqlVarParameter;

public class NamedBatchUpdateUtils {
    public static int[] executeBatchUpdate(String sql, final List<Object[]> batchValues, final int[] columnTypes, JdbcOperations jdbcOperations) {
        return jdbcOperations.batchUpdate(sql, new BatchPreparedStatementSetter(){

            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Object[] values = (Object[])batchValues.get(i);
                NamedBatchUpdateUtils.setStatementParameters(values, ps, columnTypes);
            }

            @Override
            public int getBatchSize() {
                return batchValues.size();
            }
        });
    }

    protected static void setStatementParameters(Object[] values, PreparedStatement ps, int[] columnTypes) throws SQLException {
        int colIndex = 0;
        for (Object value : values) {
            ++colIndex;
            if (value instanceof SqlVarParameter) {
                SqlVarParameter paramValue = (SqlVarParameter)value;
                StatementSetterUtils.setParameterValue(ps, colIndex, paramValue, paramValue.getValue());
                continue;
            }
            int colType = columnTypes == null || columnTypes.length < colIndex ? Integer.MIN_VALUE : columnTypes[colIndex - 1];
            StatementSetterUtils.setParameterValue(ps, colIndex, colType, value);
        }
    }

    public static int[] executeBatchUpdateWithNamedParameters(final ParsedSql parsedSql, final SqlParameterSource[] batchArgs, JdbcOperations jdbcOperations) {
        if (batchArgs.length <= 0) {
            return new int[]{0};
        }
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(parsedSql, batchArgs[0]);
        return jdbcOperations.batchUpdate(sqlToUse, new BatchPreparedStatementSetter(){

            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Object[] values = NamedParameterUtils.buildValueArray(parsedSql, batchArgs[i], null);
                int[] columnTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, batchArgs[i]);
                NamedBatchUpdateUtils.setStatementParameters(values, ps, columnTypes);
            }

            @Override
            public int getBatchSize() {
                return batchArgs.length;
            }
        });
    }
}

