/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.core.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.hasor.core.Hasor;
import net.hasor.jdbc.PreparedStatementCreator;
import net.hasor.jdbc.PreparedStatementSetter;
import net.hasor.jdbc.core.ParameterDisposer;
import net.hasor.jdbc.core.SqlProvider;
import net.hasor.jdbc.core.util.StatementSetterUtils;
import net.hasor.jdbc.exceptions.InvalidDataAccessException;
import net.hasor.jdbc.parameter.SqlParameter;
import net.hasor.jdbc.parameter.SqlVarParameter;

public class PreparedStatementCreatorFactory {
    private final String sql;
    private final List<SqlParameter> declaredParameters;
    private int resultSetType = 1003;
    private boolean updatableResults = false;
    private boolean returnGeneratedKeys = false;
    private String[] generatedKeysColumnNames = null;

    public PreparedStatementCreatorFactory(String sql) {
        this.sql = sql;
        this.declaredParameters = new LinkedList<SqlParameter>();
    }

    public PreparedStatementCreatorFactory(String sql, int[] types) {
        this.sql = sql;
        this.declaredParameters = SqlParameter.sqlTypesToAnonymousParameterList(types);
    }

    public PreparedStatementCreatorFactory(String sql, List<SqlParameter> declaredParameters) {
        this.sql = sql;
        this.declaredParameters = declaredParameters;
    }

    public void addParameter(SqlParameter param) {
        this.declaredParameters.add(param);
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setUpdatableResults(boolean updatableResults) {
        this.updatableResults = updatableResults;
    }

    public void setReturnGeneratedKeys(boolean returnGeneratedKeys) {
        this.returnGeneratedKeys = returnGeneratedKeys;
    }

    public void setGeneratedKeysColumnNames(String[] names) {
        this.generatedKeysColumnNames = names;
    }

    public PreparedStatementSetter newPreparedStatementSetter(List params) {
        return new PreparedStatementCreatorImpl(params != null ? params : Collections.emptyList());
    }

    public PreparedStatementSetter newPreparedStatementSetter(Object[] params) {
        return new PreparedStatementCreatorImpl(params != null ? Arrays.asList(params) : Collections.emptyList());
    }

    public PreparedStatementCreator newPreparedStatementCreator(List<?> params) {
        return new PreparedStatementCreatorImpl(params != null ? params : Collections.emptyList());
    }

    public PreparedStatementCreator newPreparedStatementCreator(Object[] params) {
        return new PreparedStatementCreatorImpl(params != null ? Arrays.asList(params) : Collections.emptyList());
    }

    public PreparedStatementCreator newPreparedStatementCreator(String sqlToUse, Object[] params) {
        return new PreparedStatementCreatorImpl(sqlToUse, params != null ? Arrays.asList(params) : Collections.emptyList());
    }

    private class PreparedStatementCreatorImpl
    implements PreparedStatementCreator,
    PreparedStatementSetter,
    SqlProvider,
    ParameterDisposer {
        private final String actualSql;
        private final List parameters;

        public PreparedStatementCreatorImpl(List<?> parameters) {
            this(preparedStatementCreatorFactory.sql, parameters);
        }

        public PreparedStatementCreatorImpl(String actualSql, List parameters) {
            this.actualSql = actualSql;
            Hasor.assertIsNotNull((Object)parameters, (String)"Parameters List must not be null");
            this.parameters = parameters;
            if (this.parameters.size() != PreparedStatementCreatorFactory.this.declaredParameters.size()) {
                HashSet<String> names = new HashSet<String>();
                for (int i = 0; i < parameters.size(); ++i) {
                    Object param = parameters.get(i);
                    if (param instanceof SqlVarParameter) {
                        names.add(((SqlVarParameter)param).getName());
                        continue;
                    }
                    names.add("Parameter #" + i);
                }
                if (names.size() != PreparedStatementCreatorFactory.this.declaredParameters.size()) {
                    throw new InvalidDataAccessException("SQL [" + PreparedStatementCreatorFactory.this.sql + "]: given " + names.size() + " parameters but expected " + PreparedStatementCreatorFactory.this.declaredParameters.size());
                }
            }
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            PreparedStatement ps = null;
            if (PreparedStatementCreatorFactory.this.generatedKeysColumnNames != null || PreparedStatementCreatorFactory.this.returnGeneratedKeys) {
                try {
                    if (PreparedStatementCreatorFactory.this.generatedKeysColumnNames != null) {
                        ps = con.prepareStatement(this.actualSql, PreparedStatementCreatorFactory.this.generatedKeysColumnNames);
                    }
                    ps = con.prepareStatement(this.actualSql, 1);
                }
                catch (AbstractMethodError ex) {
                    throw new InvalidDataAccessException("The JDBC driver is not compliant to JDBC 3.0 and thus does not support retrieval of auto-generated keys", ex);
                }
            } else {
                ps = PreparedStatementCreatorFactory.this.resultSetType == 1003 && !PreparedStatementCreatorFactory.this.updatableResults ? con.prepareStatement(this.actualSql) : con.prepareStatement(this.actualSql, PreparedStatementCreatorFactory.this.resultSetType, PreparedStatementCreatorFactory.this.updatableResults ? 1008 : 1007);
            }
            this.setValues(ps);
            return ps;
        }

        @Override
        public void setValues(PreparedStatement ps) throws SQLException {
            int sqlColIndx = 1;
            for (int i = 0; i < this.parameters.size(); ++i) {
                Object in = this.parameters.get(i);
                SqlParameter declaredParameter = null;
                if (in instanceof SqlVarParameter) {
                    SqlVarParameter paramValue = (SqlVarParameter)in;
                    in = paramValue.getValue();
                    declaredParameter = paramValue;
                } else {
                    if (PreparedStatementCreatorFactory.this.declaredParameters.size() <= i) {
                        throw new InvalidDataAccessException("SQL [" + PreparedStatementCreatorFactory.this.sql + "]: unable to access parameter number " + (i + 1) + " given only " + PreparedStatementCreatorFactory.this.declaredParameters.size() + " parameters");
                    }
                    declaredParameter = (SqlParameter)PreparedStatementCreatorFactory.this.declaredParameters.get(i);
                }
                if (in instanceof Collection && declaredParameter.getSqlType() != 2003) {
                    Collection entries = (Collection)in;
                    for (Object entry : entries) {
                        if (entry instanceof Object[]) {
                            Object[] valueArray;
                            for (Object argValue : valueArray = (Object[])entry) {
                                StatementSetterUtils.setParameterValue(ps, sqlColIndx++, declaredParameter, argValue);
                            }
                            continue;
                        }
                        StatementSetterUtils.setParameterValue(ps, sqlColIndx++, declaredParameter, entry);
                    }
                    continue;
                }
                StatementSetterUtils.setParameterValue(ps, sqlColIndx++, declaredParameter, in);
            }
        }

        @Override
        public String getSql() {
            return PreparedStatementCreatorFactory.this.sql;
        }

        @Override
        public void cleanupParameters() {
            StatementSetterUtils.cleanupParameters(this.parameters);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("PreparedStatementCreatorFactory.PreparedStatementCreatorImpl: sql=[");
            sb.append(PreparedStatementCreatorFactory.this.sql).append("]; parameters=").append(this.parameters);
            return sb.toString();
        }
    }
}

