/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.jdbc.core.util;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.hasor.core.Hasor;
import net.hasor.jdbc.core.value.DisposableSqlTypeValue;
import net.hasor.jdbc.core.value.SqlTypeValue;
import net.hasor.jdbc.core.value.SqlValue;
import net.hasor.jdbc.parameter.SqlParameter;
import net.hasor.jdbc.parameter.SqlVarParameter;

public class StatementSetterUtils {
    private static Map<Class<?>, Integer> javaTypeToSqlTypeMap = new HashMap(32);

    public static int javaTypeToSqlParameterType(Class<?> javaType) {
        Integer sqlType = javaTypeToSqlTypeMap.get(javaType);
        if (sqlType != null) {
            return sqlType;
        }
        if (Number.class.isAssignableFrom(javaType)) {
            return 2;
        }
        if (StatementSetterUtils.isStringValue(javaType)) {
            return 12;
        }
        if (StatementSetterUtils.isDateValue(javaType) || Calendar.class.isAssignableFrom(javaType)) {
            return 93;
        }
        return Integer.MIN_VALUE;
    }

    public static void setParameterValue(PreparedStatement ps, int parameterPosition, SqlParameter paramValue, Object inValue) throws SQLException {
        StatementSetterUtils.setParameterValue(ps, parameterPosition, paramValue.getSqlType(), paramValue.getScale(), inValue);
    }

    public static void setParameterValue(PreparedStatement ps, int parameterPosition, int sqlType, Object inValue) throws SQLException {
        StatementSetterUtils.setParameterValue(ps, parameterPosition, sqlType, null, inValue);
    }

    private static void setParameterValue(PreparedStatement ps, int parameterPosition, int sqlType, Integer scale, Object inValue) throws SQLException {
        int sqlTypeToUse = sqlType;
        Integer scaleToUse = scale;
        Object inValueToUse = inValue;
        if (inValue instanceof SqlParameter) {
            sqlTypeToUse = ((SqlParameter)inValue).getSqlType();
            scaleToUse = ((SqlParameter)inValue).getScale();
        }
        if (inValue instanceof SqlVarParameter) {
            inValueToUse = ((SqlVarParameter)inValue).getValue();
        }
        if (inValueToUse == null) {
            StatementSetterUtils.setNull(ps, parameterPosition, sqlTypeToUse);
        } else {
            StatementSetterUtils.setValue(ps, parameterPosition, sqlTypeToUse, scaleToUse, inValueToUse);
        }
    }

    private static void setValue(PreparedStatement ps, int paramIndex, int sqlType, Integer scale, Object inValue) throws SQLException {
        if (inValue instanceof SqlTypeValue) {
            ((SqlTypeValue)inValue).setTypeValue(ps, paramIndex, sqlType);
        } else if (inValue instanceof SqlValue) {
            ((SqlValue)inValue).setValue(ps, paramIndex);
        } else if (sqlType == 12 || sqlType == -1 || sqlType == 2005 && StatementSetterUtils.isStringValue(inValue.getClass())) {
            ps.setString(paramIndex, inValue.toString());
        } else if (sqlType == 3 || sqlType == 2) {
            if (inValue instanceof BigDecimal) {
                ps.setBigDecimal(paramIndex, (BigDecimal)inValue);
            } else if (scale != null) {
                ps.setObject(paramIndex, inValue, sqlType, (int)scale);
            } else {
                ps.setObject(paramIndex, inValue, sqlType);
            }
        } else if (sqlType == 91) {
            if (inValue instanceof java.util.Date) {
                if (inValue instanceof Date) {
                    ps.setDate(paramIndex, (Date)inValue);
                } else {
                    ps.setDate(paramIndex, new Date(((java.util.Date)inValue).getTime()));
                }
            } else if (inValue instanceof Calendar) {
                Calendar cal = (Calendar)inValue;
                ps.setDate(paramIndex, new Date(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValue, 91);
            }
        } else if (sqlType == 92) {
            if (inValue instanceof java.util.Date) {
                if (inValue instanceof Time) {
                    ps.setTime(paramIndex, (Time)inValue);
                } else {
                    ps.setTime(paramIndex, new Time(((java.util.Date)inValue).getTime()));
                }
            } else if (inValue instanceof Calendar) {
                Calendar cal = (Calendar)inValue;
                ps.setTime(paramIndex, new Time(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValue, 92);
            }
        } else if (sqlType == 93) {
            if (inValue instanceof java.util.Date) {
                if (inValue instanceof Timestamp) {
                    ps.setTimestamp(paramIndex, (Timestamp)inValue);
                } else {
                    ps.setTimestamp(paramIndex, new Timestamp(((java.util.Date)inValue).getTime()));
                }
            } else if (inValue instanceof Calendar) {
                Calendar cal = (Calendar)inValue;
                ps.setTimestamp(paramIndex, new Timestamp(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValue, 93);
            }
        } else if (sqlType == Integer.MIN_VALUE) {
            if (StatementSetterUtils.isStringValue(inValue.getClass())) {
                ps.setString(paramIndex, inValue.toString());
            } else if (StatementSetterUtils.isDateValue(inValue.getClass())) {
                ps.setTimestamp(paramIndex, new Timestamp(((java.util.Date)inValue).getTime()));
            } else if (inValue instanceof Calendar) {
                Calendar cal = (Calendar)inValue;
                ps.setTimestamp(paramIndex, new Timestamp(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValue);
            }
        } else {
            ps.setObject(paramIndex, inValue, sqlType);
        }
    }

    private static void setNull(PreparedStatement ps, int paramIndex, int sqlType) throws SQLException {
        if (sqlType == Integer.MIN_VALUE) {
            boolean useSetObject = false;
            sqlType = 0;
            try {
                DatabaseMetaData dbmd = ps.getConnection().getMetaData();
                String databaseProductName = dbmd.getDatabaseProductName();
                String jdbcDriverName = dbmd.getDriverName();
                if (databaseProductName.startsWith("Informix") || jdbcDriverName.startsWith("Microsoft SQL Server")) {
                    useSetObject = true;
                } else if (databaseProductName.startsWith("DB2") || jdbcDriverName.startsWith("jConnect") || jdbcDriverName.startsWith("SQLServer") || jdbcDriverName.startsWith("Apache Derby")) {
                    sqlType = 12;
                }
            }
            catch (Throwable ex) {
                Hasor.logDebug((String)"Could not check database or driver name", (Object[])new Object[]{ex});
            }
            if (useSetObject) {
                ps.setObject(paramIndex, null);
            } else {
                ps.setNull(paramIndex, sqlType);
            }
        } else {
            ps.setNull(paramIndex, sqlType);
        }
    }

    public static void cleanupParameters(Object[] paramValues) {
        if (paramValues != null) {
            StatementSetterUtils.cleanupParameters(Arrays.asList(paramValues));
        }
    }

    public static void cleanupParameters(Collection paramValues) {
        if (paramValues != null) {
            for (Object inValue : paramValues) {
                if (inValue instanceof DisposableSqlTypeValue) {
                    ((DisposableSqlTypeValue)inValue).cleanup();
                    continue;
                }
                if (!(inValue instanceof SqlValue)) continue;
                ((SqlValue)inValue).cleanup();
            }
        }
    }

    private static boolean isStringValue(Class<?> inValueType) {
        return CharSequence.class.isAssignableFrom(inValueType) || StringWriter.class.isAssignableFrom(inValueType);
    }

    private static boolean isDateValue(Class<?> inValueType) {
        return java.util.Date.class.isAssignableFrom(inValueType) && !Date.class.isAssignableFrom(inValueType) && !Time.class.isAssignableFrom(inValueType) && !Timestamp.class.isAssignableFrom(inValueType);
    }

    static {
        javaTypeToSqlTypeMap.put(Boolean.TYPE, new Integer(16));
        javaTypeToSqlTypeMap.put(Boolean.class, new Integer(16));
        javaTypeToSqlTypeMap.put(Byte.TYPE, -6);
        javaTypeToSqlTypeMap.put(Byte.class, -6);
        javaTypeToSqlTypeMap.put(Short.TYPE, 5);
        javaTypeToSqlTypeMap.put(Short.class, 5);
        javaTypeToSqlTypeMap.put(Integer.TYPE, 4);
        javaTypeToSqlTypeMap.put(Integer.class, 4);
        javaTypeToSqlTypeMap.put(Long.TYPE, -5);
        javaTypeToSqlTypeMap.put(Long.class, -5);
        javaTypeToSqlTypeMap.put(BigInteger.class, -5);
        javaTypeToSqlTypeMap.put(Float.TYPE, 6);
        javaTypeToSqlTypeMap.put(Float.class, 6);
        javaTypeToSqlTypeMap.put(Double.TYPE, 8);
        javaTypeToSqlTypeMap.put(Double.class, 8);
        javaTypeToSqlTypeMap.put(BigDecimal.class, 3);
        javaTypeToSqlTypeMap.put(Date.class, 91);
        javaTypeToSqlTypeMap.put(Time.class, 92);
        javaTypeToSqlTypeMap.put(Timestamp.class, 93);
        javaTypeToSqlTypeMap.put(Blob.class, 2004);
        javaTypeToSqlTypeMap.put(Clob.class, 2005);
    }
}

